<?php
/**
 * @package linea21.core
 * @subpackage workshop
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

/** Préparation du mail
 * $email_html_body
 * $email_text_body
 * $email_subject
 * $email_dest
 **/
switch($a['action']) {
  case 'file_alert':
    $email_html_body = "<p>". sprintf(_t('workshop','mail_file_body1'), $wname) . "</p>".END_LINE;
    $email_html_body .= "<p>". sprintf(_t('workshop','mail_file_body2'), $_COOKIE['linea21']['login']) . "</p>".END_LINE;
    $email_html_body .= "<em>".END_LINE;
    if(isset($a['files'])) {
      foreach($a['files'] as $file) {
        $email_html_body .= "- ".$file."<br />".END_LINE;
      }
    }
    $email_html_body .= "</em><br /><br />".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_body_url') . "<br />".END_LINE;
    $email_html_body .= "<a href=" . SITE_ROOT_URL. 'public/' .get_permalink($wlinkfiles). ">" . SITE_ROOT_URL. 'public/'  .get_permalink($wlinkfiles). "</a></p>".END_LINE;
    $email_html_body .= "<p>"._t('workshop','mail_body_auth') . "</p>".END_LINE;

    $email_text_body = strip_tags($email_html_body);

    $email_subject = sprintf(_t('workshop','mail_file_subject'), $wname, SITE_NAME);
    $email_dest = $user->profile_email;
    break;
  case 'topic_alert':
    $email_html_body = "<p>". sprintf(_t('workshop','mail_topic_body1'), $_COOKIE['linea21']['login'], formatText($a['topic_subject'], '2HTML'), formatText($wname, '2HTML')) . "</p>".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_msg_content') . " :</p>".END_LINE;
    $email_html_body .= "<p><em>". formatText($a['topic_body'], '2HTML') ."</em></p>".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_body_url') . "<br />".END_LINE;
    $email_html_body .= "<a href=" . SITE_ROOT_URL. 'public/' .get_permalink($wlinkforum). ">". SITE_ROOT_URL. 'public/'  .get_permalink($wlinkforum). "</a></p>".END_LINE;
    $email_html_body .= "<p>"._t('workshop','mail_body_auth') . "</p>".END_LINE;
    	
    $email_text_body = strip_tags($email_html_body);

    $email_subject = sprintf(_t('workshop','mail_topic_subject'), $wname, SITE_NAME);
    $email_dest = $user->profile_email;
    break;
  case 'post_alert':
    $email_html_body = "<p>". sprintf(_t('workshop','mail_post_body1'), $_COOKIE['linea21']['login'], formatText($a['topic_subject'], '2HTML'), formatText($wname, '2HTML')) . "</p>".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_msg_content') . " :</p>".END_LINE;
    $email_html_body .= "<p><em>". formatText($a['topic_body'], '2HTML') ."</em></p>".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_body_url') . "<br />".END_LINE;
    $email_html_body .= "<a href=" . SITE_ROOT_URL. 'public/' .get_permalink($wlinkforum). ">". SITE_ROOT_URL. 'public/'  .get_permalink($wlinkforum). "</a></p>".END_LINE;
    $email_html_body .= "<p>"._t('workshop','mail_body_auth') . "</p>".END_LINE;

    $email_text_body = strip_tags($email_html_body);

    $email_subject = sprintf(_t('workshop','mail_post_subject'), $wname, SITE_NAME);
    $email_dest = $user->profile_email;
    break;
  case 'workgroup_request':
    $email_html_body = "<p>" . sprintf(_t('workshop', 'workgroup_request'), $_COOKIE['linea21']['login']). "</p>".END_LINE;
    $email_html_body .= "<p>". $groups . "</p>".END_LINE;
    $email_html_body .= "<a href=" . SITE_ROOT_URL. 'admin/' .$linkuser. ">". SITE_ROOT_URL. 'admin/'  .$linkuser. "</a></p>".END_LINE;
    $email_html_body .= "<p><em>". _t('divers', 'comment')."</em> : ". formatText($_POST['comment'], '2HTML') ."</p>".END_LINE;

    $email_text_body = strip_tags($email_html_body);

    $email_subject = sprintf(_t('workshop','mail_request_subject'). '- %s', SITE_NAME);
    $email_dest = SITE_MAIL;
    break;
  default:
    exit();
}

?>
