<?php
/**
 * @package linea21.modules
 * @subpackage auth
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Plugin Management
 */

class auth {


	protected $dispatcher = null;

	public function __construct() {
		$this->dispatcher = $GLOBALS['dispatcher'];
	}

	public function __call($method, $arguments) {
		$event = $this->dispatcher->notifyUntil(new sfEvent($this, 'auth.extensible_function', array(
				'method'    => $method,
				'arguments' => $arguments
		)));
		if (!$event->isProcessed())
		{
			throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
		}

		return $event->getReturnValue();
	}

	/**
	 * AuthenthificationProcess()
	 * Authentification d'un utilisateur
	 *
	 * @param  $login
	 * @param  $pass
	 * @param  $type ='PUBLIC' || 'ADMIN'
	 * @return boolean (true) ou message d'erreur
	 */
	public function logIn($login, $pass, $type)
	{

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.logIn', array('login' => $login, 'password' => $pass, 'type' => $type)));

		if($type == 'PUBLIC') $src = LOG_PUBLIC_ACCESS;
		if($type == 'ADMIN') $src = LOG_ADMIN_ACCESS;
		logfile($src, array($type, $login, $_SERVER['HTTP_USER_AGENT'], $_SERVER['HTTP_REFERER'], $_SERVER['REQUEST_METHOD'], $_SERVER['REQUEST_URI'], $_SERVER['QUERY_STRING'], $_SERVER['HTTP_COOKIE'], i2c_realip()));

		$crypt_pass = crypt($pass, SALT_CRYPT);
		list($login, $crypt_pass) = $GLOBALS['sql_object']->DBEscape(array($login, $crypt_pass));

		$data = $GLOBALS['sql_object']->DBSelect(SQL_Get_UserInfo4Auth($login, $crypt_pass));

		if ($data != 0 && count($data) == 1) {

			// préparation du tableau de droits
			$right['dashboard'] = $data[0]['rights_dashboard'];
			$right['workshop'] = $data[0]['rights_workshop'];
			$right['project'] = $data[0]['rights_project'];
			$right['publication'] = $data[0]['rights_publication'];
			$right['news'] = $data[0]['rights_news'];
			$right['yellowpages'] = $data[0]['rights_yellowpages'];
			$right['theme'] = $data[0]['rights_theme'];
			$right['scale'] = $data[0]['rights_scale'];
			$right['level'] = $data[0]['rights_level'];
			$right['category_user'] = $data[0]['rights_category_user'];

			$_SESSION['authenticated'] = true;
			$_SESSION['userid'] = base64_encode($data[0]['user_id']);
			$_SESSION['userwhois'] = base64_encode($crypt_pass);
			$_SESSION['userlogin'] = $login;
			$_SESSION['lastcon'] = $data[0]['user_last_con'];

			if(!empty($data[0]['profile_firstname'])) {
				$_SESSION['userfirstname'] = $data[0]['profile_firstname'];
			}
			if(!empty($data[0]['profile_lastname'])) {
				$_SESSION['userlastname'] = $data[0]['profile_lastname'];
			}
			$_SESSION['userright'] = $right;

			$workgroups = $this->retrieveUserWorkgroups(array('login' => $login, 'pass' => $crypt_pass));
			$table['workshop'] = base64_encode($workgroups);
			$table['lifetime'] = time() + 3600 * 720;

			$this->destroyUserCookie();
			
			// we update the last connexion field
			$GLOBALS['sql_object']->DBQuery('UPDATE l21_user SET user_last_con = NOW() where user_id=' . $data[0]['user_id'] . ';');

			// Filter data event + return value
			$r = $this->dispatcher->filter(new sfEvent(__FUNCTION__, 'auth.extend_session', array('data' => $table)), $table);
			$table = $r->getReturnValue();

			$this->setUserCookie($table);


			if ($type == 'ADMIN') {
				// si est simple utilisateur
				if (!array_search ('A' , $right) && !array_search ('O' , $right)) {
					return _t('divers','errorauth');
					// est utilisateur avec droits
				}
			}
			return true;
		} else {
			$error_msg = _t('divers','errorauth');
			return $error_msg;
		}
	}

	/**
	 * isSimpleUser()
	 *
	 * @return boolean
	 */
	public function isSimpleUser() {
		if(!isset($_SESSION['userright'])) return false;

		if(!in_array('A', $_SESSION['userright']) && !in_array('O', $_SESSION['userright'])) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * isSuperAdmin()
	 *
	 * @return boolean
	 */
	public function isSuperAdmin() {
		return $this->hasRight('theme');
	}

	/**
	 * logOut()
	 *
	 * @return boolean
	 */
	public function logOut() {

		$_SESSION = array();
		session_unset();
		session_destroy();
		$this->destroyUserCookie();
	}
	/**
	 * hasRight()
	 *
	 * @param string $item
	 * @return bool
	 */
	public function hasRight($item)
	{
		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.has_right', array('element' => $item)));

		switch ($item) {
			case 'category_user':
				if ($this->GetSessionElement('right_category_user') != 'A') return false;
				else return true;
			case 'theme':
				if ($this->GetSessionElement('right_theme') != 'A') return false;
				else return true;
			case 'level':
				if ($this->GetSessionElement('right_level') != 'A') return false;
				else return true;
			case 'scale':
				if ($this->GetSessionElement('right_scale') != 'A') return false;
				else return true;
			case 'yellowpages':
				if ($this->GetSessionElement('right_yellowpages') != 'A') return false;
				else return true;
			case 'news':
				if ($this->GetSessionElement('right_news') != 'U') return true;
				else return false;
			case 'project':
				if ($this->GetSessionElement('right_project') != 'A') return false;
				else return true;
			case 'publication':
				if ($this->GetSessionElement('right_publication') != 'U') return true;
				else return false;
			case 'workshop':
				if ($this->GetSessionElement('right_workshop') != 'U') return true;
				else return false;
			case 'workshoprep':
				if ($this->GetSessionElement('right_workshop') != 'U') return true;
				else return false;
			case 'dashboard':
				if ($this->GetSessionElement('right_dashboard') != 'U') return true;
				else return false;
			default:
				return false;
		}
	}

	/**
	 * GetSessionElement()
	 *
	 * @param string $item
	 * @return $result
	 */

	public function GetSessionElement($item)	{
		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.get_session_element', array('element' => $item)));

		switch ($item) {
			case 'id':
				return base64_decode($_SESSION['userid']);
				break;
			case 'whois':
				return base64_decode($_SESSION['userwhois']);
				break;
			case 'login':
				return $_SESSION['userlogin'];
				break;
			case 'firstname':
				if(isset($_SESSION['userfirstname']))
					return $_SESSION['userfirstname'];
				break;
			case 'lastname':
				if(isset($_SESSION['userlastname']))
					return $_SESSION['userlastname'];
				break;
			case 'right_theme':
				return $_SESSION['userright']['theme'];
				break;
			case 'right_dashboard':
				return $_SESSION['userright']['dashboard'];
				break;
			case 'right_workshop':
				return $_SESSION['userright']['workshop'];
				break;
			case 'right_project':
				return $_SESSION['userright']['project'];
				break;
			case 'right_publication':
				return $_SESSION['userright']['publication'];
				break;
			case 'right_news':
				return $_SESSION['userright']['news'];
				break;
			case 'right_yellowpages':
				return $_SESSION['userright']['yellowpages'];
				break;
			case 'right_scale':
				return $_SESSION['userright']['scale'];
				break;
			case 'right_level':
				return $_SESSION['userright']['level'];
				break;
			case 'right_category_user':
				return $_SESSION['userright']['category_user'];
				break;
			default:
				return false;
				break;
		}
	}

	/**
	 * isWorkgroupUser()
	 * check if the current user belongs to a workgroup
	 * used in PUBLIC app
	 * @param  $workshop_id
	 * @return boolean
	 */
	public function isWorkgroupUser($workshop_id, $sql_object)
	{
		// check if user has cookie, if not we exit
		if(!$this->isAuthenticated()) return false;

		// if is SuperAdmin we allow the access
		if($this->isSuperAdmin()) return true;

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.is_workgroup_user', array('id' => $workshop_id)));

		include_once('../admin/'.SQL.'.inc.php');

		// 1 -we check that login and password stored in sessions are corrects
		$q = SQL_Get_UserInfo4Auth($this->GetSessionElement('login'), $this->GetSessionElement('whois'));
		$data = $sql_object->DBSelect($q);

		if ($data != 0 && count($data) == 1 && $data[0]['user_id'] == $this->GetSessionElement('id')) {
			// 2 - if ok,  we check that the user belongs to the given group
			$r = $sql_object->DBSelect(SQL_Get_isWorkgroupUser($data[0]['user_id']));

			for ($i = 0; $i < count($r); $i++) {
				if ($workshop_id == $r[$i]['jwu_workshop_id']) {
					return true;
				}

			}
		}
		return false;
	}

	/**
	 * isWorkgroupOrganiser()
	 * check if a given user is workgroup organiser
	 * used in ADMIN app
	 * @param  $id_user
	 * @param  $sql_object
	 * @param  $id_workshop
	 * @return boolean
	 */
	public function isWorkgroupOrganiser($id_user, $sql_object, $id_workshop)
	{
		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.is_workgroup_organiser', array('id' => $id_user, 'workgroup_id' => $id_workshop)));

		$data = $sql_object->DBSelect(SQL_Get_isWorkgroupOrganiser($id_user));

		for ($i = 0; $i < count($data); $i++) {
			if ($id_workshop == $data[$i]['jwu_workshop_id'])
				return true;
		}
		return false;
	}

	public function isAuthenticated() {
		if(isset($_SESSION['authenticated'])) return true;
		else return false;
	}

	/**
	 * identifyWithLogin()
	 * Authentification d'un utilisateur
	 * par son login seulement
	 * (oubli du mot de passe)
	 * @param  $login
	 * @return array
	 */
	public function identifyWithLogin($login) {

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.identify_login', array('login' => $login)));

		$data = $GLOBALS['sql_object']->DBSelect(SQL_get_UserInfo($login));
		if ($data != 0 && count($data) == 1) {
			return $data[0];
		} else {
			return false;
		}
	}


	/**
	 * retrieveUserWorkgroups()
	 * Retrieve Workgroups for a given user
	 * @param  $a array (optional)
	 * @return string
	 */
	public function retrieveUserWorkgroups($a = array()) {

		// user already logged-in
		if(isset($_SESSION['authenticated'])) {
			$login = $_SESSION['userlogin'];
			$crypt_pass = base64_decode($_SESSION['userwhois']);
		}
		else
		{
			if(isset($a['login'])) {
				$login = $a['login'];
				$crypt_pass = $a['pass'];
			} else {
				return false;
			}
		}

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.retrieve_user_workgroups', array('login' => $login, 'password' => $crypt_pass)));

		$data_w = $GLOBALS['sql_object']->DBSelect(SQL_Get_UserWorkshop($login, $crypt_pass));
		$workgroups = '';
		for ($i = 0; $i < count($data_w); $i++) {
			$workgroups .= "/" . $data_w[$i]['jwu_workshop_id'];
		}
		return $workgroups;

	}

	/**
	 * updateSessionPassword()
	 * Mise à jour du mot de passe en session (cas de changement)
	 * @param  $newpass
	 * @return boolean
	 */
	public function updateSessionPassword($newpass) {

		// Notify the beginning of the current method;
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.update_cookie_password'));

		$_SESSION['userwhois']= base64_encode($newpass);

		return true;
	}

	/**
	 * updateCookieWorkshop()
	 * Update workgroups list in cookie
	 * used in public/ part
	 *
	 * @return void
	 */
	function updateCookieWorkshop()
	{
		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.update_cookie_workshop'));

		$str = base64_encode($this->retrieveUserWorkgroups());
		setcookie('linea21[workshop]', $str, $_COOKIE['linea21']['lifetime'], '/');
	}

	/**
	 * setUserCookie()
	 * set les infos contenu en tableau PHP en cookie
	 *
	 * @param  $array
	 * @return void
	 */
	public function setUserCookie($array)
	{
		// Notify the beginning of the current method
		// Filter data event + return value
		$r = $this->dispatcher->filter(new sfEvent(__FUNCTION__, 'auth.set_user_cookie', array('data' => $array)), $array);
		$array = $r->getReturnValue();

		$cookie_expires = $array['lifetime'];
		while (list($key, $value) = @each($array)) {
			setcookie('linea21[' . $key . ']', $value, $cookie_expires, '/');
		}
	}

	/**
	 * destroyUserCookie()
	 * Détruit les infos contenues en cookie
	 *
	 * @return void
	 */
	public function destroyUserCookie()
	{
		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.destroy_user_cookie'));

		while (list($key, $val) = @each($_COOKIE['linea21'])) {
			setcookie('linea21[' . $key . ']', '', (time() - 3600), '/');
		}
	}

	/**
	 * setCookieLastPage()
	 * used for the admin/ part
	 */
	public function setCookieLastPage() {

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent(__FUNCTION__, 'auth.set_cookie_lastpage'));

		if(isset($_SESSION['authenticated'])) {
			setcookie('linea21_lastpage', 'index.php?'.$_SERVER['QUERY_STRING'], (time() + 3600 * 720), '/');
			setcookie('linea21_lastuser', $_SESSION['userlogin'], (time() + 3600 * 720), '/');
			setcookie('linea21_lastactivity', time(), (time() + 3600 * 720), '/');
		}
		return true;
	}
	/**
	 * isActive()
	 * check if last activity is less than SESS_INACTIVITY_MAXTIME
	 * If more, destroy the session
	 */
	public function isActive() {
		
		if (!$this->isAuthenticated()) return true;
		
		if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > SESS_INACTIVITY_MAXTIME)) {
			// last request was more than SESS_INACTIVITY_MAXTIME (in seconds) ago
			session_unset();     // unset $_SESSION variable for the run-time
			session_destroy();   // destroy session data in storage
			$_SESSION = array();
		}
		$_SESSION['LAST_ACTIVITY'] = time(); // update last activity time stamp
	}

}

?>