<?php
/**
 * @package linea21.modules
 * @subpackage news
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * News Management
 */

class news {
  /* @param
   * */
  public $TDB_NEWS = T_NEWS; // nom de la table.
  public $ID;
  public $TITLE;
  public $HEADER;
  public $BODY;
  public $THEME;
  public $SCALE;
  public $LEVEL;
  public $RANGE;
  public $POSTED_BY;
  public $POST_DATE;
  public $PUBLISHED_DATE;
  public $PEREMPT_DATE;
  public $IS_NATIONAL;
  public $STATUT;
  protected $dispatcher = null;


  public function __construct()
  {
    $this->dispatcher = $GLOBALS['dispatcher'];
  }

  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'news.extensible_function', array(
      'method'    => $method,
      'arguments' => $arguments
    )));
    if (!$event->isProcessed())
    {
      throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }

    return $event->getReturnValue();
  }


  /**
   * news::_getDate()
   * date courante et ajout
   *
   * @access private
   * @param int $m chiffre des mois
   * @param int $d chiffre des jours
   * @param int $y chiffre des années
   * @return string $format_date
   * @return
   */
  private function _getDate($m = 0, $d = 0, $y = 0)
  {
    $format_date = mktime(date("H"), date("i"), date("s"), date("m") + $m, date("d") , date("Y"), -1);
    $format_date = strftime('%Y-%m-%d %H:%M:%S', $format_date);

    return $format_date;
  }


  /**
   * news::CheckDataIntegrity()
   * Vérification intégrité des données
   *
   * @access public
   * @param array $table : contient les composants Nécessaires d'une news
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */

  public function CheckDataIntegrity($table)
  {
  	
  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'news.before_datacheck', array('data' => $table)), $table);
  	$table = $r->getReturnValue();

    if (strlen($table[0]) < 3) return _t('news','no_title');
    if (strlen($table[1]) < 3) return _t('news','no_header');
    if (strlen($table[2]) < 3) return _t('news','no_body');
    if ($table[3] <= 0 || !is_numeric($table[3])) return _t('news','no_theme');
    if ($table[4] <= 0 || !is_numeric($table[4])) return _t('news','no_scale');

    // Notify the beginning of the current method
  	$this->dispatcher->notify(new sfEvent($this, 'news.after_datacheck', array('data' => $table)));

    return true;
  }

  /**
   * news::AddNews()
   * Ajout d'une news
   *
   * @access public
   * @param array $a : contient les composants d'une news
   * @param object $sql_object
   * @return integer $last_id
   */
  public function AddNews($a, $sql_object)
  {
  	
  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'news.before_add', array('data' => $a)), $a);
  	$a = $r->getReturnValue();
  	
    $a=$sql_object->DBescape($a);

    if ($a[0] != '') {
      $this->TITLE = strip_input(trim($a[0]), true);
    }
    if ($a[1] != '') {
      $this->HEADER = strip_input(trim($a[1]), true);
    }
    if ($a[2] != '') {
      $this->BODY = strip_input(trim($a[2]), true);
    }
    if (is_numeric($a[3])) {
      $this->THEME = $a[3];
    }
    if (is_numeric($a[4])) {
      $this->SCALE = $a[4];
    }
    if (is_numeric($a[5])) {
      if($a[5] == -1) $a[5]=0;
      $this->LEVEL = $a[5];
    }
    if (is_numeric($a[6])) {
      $this->RANGE = $a[6];
    }
    if (is_numeric($a[7])) {
      $this->POSTED_BY = $a[7];
    }
    if ($a[9] != '') {
      $this->IS_NATIONAL = strtoupper($a[9]);
    }
    if ($a[10] != '') {
      $this->STATUT = strtoupper($a[10]);
    }
    if ($this->STATUT == 'P') {
      $this->PUBLISHED_DATE = $this->_getDate();
      if ($a[8] != '') {
        $this->PEREMPT_DATE = $a[8];
      } else {
        $this->PEREMPT_DATE = '0001-01-01';
      }
    } else {
      $this->PUBLISHED_DATE = '0001-01-01';
      $this->PEREMPT_DATE = '0001-01-01';
    }
    $q = "INSERT INTO " . $this->TDB_NEWS . " (news_title, news_header, news_body, news_theme, news_scale, " . "news_level, news_range, news_posted_by, news_published_date, " . "news_perempt_date, news_is_national, news_statut, news_date_crea) " . "VALUES('" . $this->TITLE . "', '" . $this->HEADER . "', '" . $this->BODY . "', " . $this->THEME . ", " . $this->SCALE . ", " . $this->LEVEL . ", " . $this->RANGE . ", " . $this->POSTED_BY . ", '" . $this->PUBLISHED_DATE . "' , '" . $this->PEREMPT_DATE . "', '" . $this->IS_NATIONAL . "', '" . $this->STATUT . "', now());";

    $last_id = $sql_object->DBInsert ($q, 1);
    
    // Notify the end of the current method
    $this->dispatcher->notify(new sfEvent($this, 'news.after_add', array('data' => $a, 'id' => $last_id)));
    
    return $last_id;
  }

  /**
   * news::DeleteNews()
   * suppression d'une news
   *
   * @access public
   * @param int $ID : identifiant de la news
   * @param object $sql_object
   * @return bool $result
   */

  public function DeleteNews($ID, $sql_object)
  {
  	// Notify the beginning of the current method
  	$this->dispatcher->notify(new sfEvent($this, 'news.delete', array('id' => $ID)));
  	
    $this->ID = $ID;
    $q = "UPDATE  " . $this->TDB_NEWS . " set news_statut='E', news_last_modify=NOW() WHERE news_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($q);
    return $result;
  }

  /**
   * news::ModifyNews()
   * modification d'une news
   *
   * @access public
   * @param integer $ID : identifiant de la news
   * @param object $sql_object
   * @param array $a : contient les composants d'une news
   * @return boolean $result
   */
  public function ModifyNews($ID, $a, $sql_object)
  {

  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'news.before_modify', array('data' => $a, 'id' => $ID)), $a);
  	$a = $r->getReturnValue();
  	
    $a=$sql_object->DBescape($a);
    if (is_numeric($ID)) {
      $this->ID = $ID;
    }
    if ($a[0] != '') {
      $this->TITLE = strip_input(trim($a[0]), true);
    }
    if ($a[1] != '') {
      $this->HEADER = strip_input(trim($a[1]), true);
    }
    if ($a[2] != '') {
      $this->BODY = strip_input(trim($a[2]), true);
    }
    if (is_numeric($a[3])) {
      $this->THEME = $a[3];
    }
    if (is_numeric($a[4])) {
      $this->SCALE = $a[4];
    }
    if (is_numeric($a[5])) {
      if($a[5] == -1) $a[5]=0;
      $this->LEVEL = $a[5];
    }
    if ($a[6] != '') {
      $this->STATUT = $a[6];
    }

    $mask = $this->_HavePublishedDate($a[7]);

    $q = "UPDATE  " . $this->TDB_NEWS . " set news_title='" . $this->TITLE . "', news_header='" . $this->HEADER . "', news_body='" . $this->BODY . "' , news_theme='" . $this->THEME . "', news_scale='" . $this->SCALE . "', news_level='" . $this->LEVEL . "', news_statut='" . $this->STATUT . "', news_last_modify=NOW() " . $mask . " WHERE news_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($q);
    
    // Notify the end of the current method
    $this->dispatcher->notify(new sfEvent($this, 'news.after_modify', array('data' => $a, 'id' => $this->ID)));
    
    return $result;
  }
  
  /**
   * news::changeRanges()
   * changes News range
   *
   * @access public
   * @param array : Id (key) and ranges (value)
   * @param object $sql_object
   * @return bool $result
   */

  function changeRanges($array, $sql_object)
  {
  	
    foreach ($array as $key => $value) {
      $query = "UPDATE " . $this->TDB_NEWS . " set news_range='".$value."' WHERE news_id='" . $key . "';";
      $result = $sql_object->DBQuery($query);
    }
    
    // Notify the beginning of the current method
    $this->dispatcher->notify(new sfEvent($this, 'news.change_ranges', array('data' => $array)));

    return $result;
  }

  /**
   * news::_HavePublishedDate()
   * Détermine la date de publication a inserer dans la bdd
   *
   * @access private
   * @param string $current_status : statut actuel de l'actualité
   * @return string $sql_mask
   */
  private function _HavePublishedDate($current_status)
  {
    switch ($this->STATUT) {
      case 'P':
        if ($current_status == 'D') $sql_mask = ", news_published_date= NOW()";
        else $sql_mask = '';
        break;
      case 'D':
        $sql_mask = ", news_published_date= '0001-01-01'";
        break;
      default:
        $sql_mask = '';
    }
    return $sql_mask;
  }
}

?>
