<?php

require_once dirname(__FILE__) .'/Renderer/Common.php';

/**
 * A loader class for the renderers.
 *
 * @package    linea21.externals
 * @subpackage PHP_DEBUG
 * @author     Vernet Loïc <qrf_coil[at]yahoo.fr>, modified by Linea21 <info@linea21.com>
 * @since V2.0.0 - 10 Apr 2006
 * @version    CVS: $Id: Renderer.php,v 1.1 2008/05/02 14:26:37 c0il Exp $
 */

class PHP_Debug_Renderer
{

  /**
   * Attempt to return a concrete Debug_Renderer instance.
   *
   * @param string $mode Name of the renderer.
   * @param array $options Parameters for the rendering.
   * @access public
   */
  public static function factory($debugObject, $options)
  {
    $className = 'PHP_Debug_Renderer_'. $options['render_type'].
            '_'. $options['render_mode'];
    $classPath = dirname(__FILE__) .'/Renderer/'. $options['render_type'].
            '/'. $options['render_mode']. '.php';

    include_once $classPath;

    if (class_exists($className)) {
      $obj = new $className($debugObject, $options);
    } else {
      include_once 'PEAR.php';
      PEAR::raiseError('PHP_Debug: renderer &gt;' .
      $options['DEBUG_render_mode'] . '&lt; not found', true);
      return NULL;
    }
    return $obj;
  }
}