<?php
/**
 * @package linea21.core
 * @subpackage workshop
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
	include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

/** Préparation du mail
 * $email_html_body
 * $email_text_body
 * $email_subject
 * $email_recipient
 **/
switch($a['action']) {
  case 'moderate_comment':
    $email_html_body  = "<p>". sprintf(_t('comment','mail_body1'), $a['name'], "<a href=\"".$a['item_link']."\">".$a['item_title']."</a> (" .$a['item_type']. ")") ." : </p>".END_LINE;
    $email_html_body .= "<p><em>". formatText($a['body'], '2HTML') ."</em></p>".END_LINE;
    $email_html_body .= "<p><a href=" . $a['moderate_link'] . ">" . ucfirst(_t('comment', 'mail_body2')). "</a> ";
    $email_html_body .= "("._t('comment','mail_body_auth') . ")</p>".END_LINE;

    $email_text_body  = sprintf(_t('comment','mail_body1'), $a['name'], $a['item_title'] . ' ('.$a['item_type'].') : ').END_LINE;
    $email_text_body .= " - ". $a['item_link'].END_LINE.END_LINE;
    $email_text_body .= formatText($a['body'], '2HTML').END_LINE.END_LINE;
    $email_text_body .= ucfirst(_t('comment', 'mail_body2')) . ' : '. $a['moderate_link'].END_LINE;
    $email_text_body .= "("._t('comment','mail_body_auth') . ")".END_LINE;
    
    $email_subject = sprintf(_t('comment','mail_subject_moderate'), SITE_NAME);
    $email_recipient = $a['recipient'];
    break;
  case 'notify_comment':
    $unsubscribe_link = $a['unsubscribe_link']. '&email='.$a['recipient'];
    $email_html_body  = "<p>". sprintf(_t('comment','mail_body1'), $a['name'], "<a href=\"".$a['item_link']."\">".$a['item_title']."</a> (" .$a['item_type']. ")") ." : </p>".END_LINE;
    $email_html_body .= "<p><em>". formatText($a['body'], '2HTML') ."</em></p>".END_LINE;
    if(!isset($a['adminuser'])) {
      $email_html_body .= "<p>" . ucfirst(_t('comment', 'mail_body3')) . "<a href=\"".$unsubscribe_link."\">" . $unsubscribe_link . "</a></p>".END_LINE;
    }
    
    $email_text_body  = sprintf(_t('comment','mail_body1'), $a['name'], $a['item_title'] . ' ('.$a['item_type'].') : ').END_LINE;
    $email_text_body .= " - ". $a['item_link'].END_LINE.END_LINE;
    $email_text_body .= formatText($a['body'], '2HTML').END_LINE.END_LINE;
    if(!isset($a['adminuser'])) {
      $email_text_body .= ucfirst(_t('comment', 'mail_body3')) . $unsubscribe_link .END_LINE;
    }
    $email_subject = sprintf(_t('comment','mail_subject_newcomment'), SITE_NAME);
    $email_recipient = $a['recipients'];
    break;
  default:
    exit();
}

?>
