<?php
/**
 * @package linea21.modules
 * @subpackage newsletter
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

$newsletter_object = new newsletter;

$mask_statut_D='';
$mask_statut_W='';



if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$newsletter_object->ModifyNewsletter($id, $data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

// Titre de la newsletter en cours de modification
$requete=SQL_getNewsletterTitle($id);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $news_current_title=formatText($result[0]['newsletter_title'],'2HTML');


// Obtention des données  de la BDD
$req_det= SQL_getoneCompleteNewsletter($id);
$result=$sql_object->DBSelect($req_det);
if($result==0 || count($result)!=1) exit;

$form_title=formatText($result[0]['newsletter_title'], '2FIELD');

$xml = simplexml_load_file(override("../newsletter/input/template.html", THEME_PUBLIC_PATH));
$form_body = str_replace('##CONTENTS##', formatText($result[0]['newsletter_body'], '2FIELD'), $xml->body->asXML());
// $form_body=formatText($result[0]['newsletter_body'], '2FIELD');
$form_statut=$result[0]['newsletter_statut'];
$news_owner = $result[0]['newsletter_posted_by'];

//////////// Check Droits utilisateur + statut newsletter courante ////////////
if (!$l21auth->isSuperAdmin() || $form_statut=='P') ReloadIndex('admin');
////////////

if(isset($_POST['valider'])) {
  $table[0]=$_POST['newsletter_title'];
  
  $html = $_POST['newsletter_body'];
  if (get_magic_quotes_gpc()) $html=stripslashes($html);
  $html = removeEmptyP($html);
  
    // we get only the text contained into #main div
  include_once('../lib/vendor/simpleDOM/SimpleDOM.php');
  $xml = simpledom_load_string($html);

  $att = 'id';
  $body_content = '';

  foreach ($xml->children() as $el) {
    if($el->attributes()->$att == 'main') {
      $body_content = $el->innerHTML();
    }
  }

  $table[1]=$body_content;
  
  $table[2]=$_POST['newsletter_statut'];

  $integrity=$newsletter_object->CheckDataIntegrity($table);

  if(is_string($integrity)) {
    $text_format='2FIELD';
    $body_content=$_POST['newsletter_body'];
  } else {
    $text_format='2HTML';
  }
  $form_title=formatText($_POST['newsletter_title'],$text_format);
  $form_body=formatText($body_content, $text_format);
  $form_statut=$_POST['newsletter_statut'];


  if($_POST['newsletter_statut']=='D') $mask_statut_D='checked="checked"'; else $mask_statut_D='';
  if($_POST['newsletter_statut']=='P') $mask_statut_P='checked="checked"'; else $mask_statut_W='';
  $table=urlencode(serialize($table));
}

// radio statut
if($form_statut=='W') $mask_statut_W='checked="checked"';
if($form_statut=='D') $mask_statut_D='checked="checked"';



?>


<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','newsletter');?></a></li>
	<li><span><?php echo formatNavTitle(_t('newsletter','mod'). ' : '.$news_current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($news_current_title); ?></h2>
<form id="modnews" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data">
<p>
  <label for="newsletter_title"><?php echo mb_ucfirst(_t('newsletter','title')); ?> : *</label>
  <input name="newsletter_title" type="text" class="textfield" id="newsletter_title" maxlength="200" 	value="<?php echo $form_title; ?>" />
</p>
<p>
  <label for="newsletter_body"><?php echo mb_ucfirst(_t('newsletter','body')); ?> : *</label>
  <textarea id="newsletter_body" name="newsletter_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
</p>
<div class="label"><?php echo mb_ucfirst(_t('newsletter','statut')); ?> : </div>
<div class="rightpanel">
  <input name="newsletter_statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> />
  <label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
  <input name="newsletter_statut" type="radio" id="statut_W" value="W" <?php echo $mask_statut_W; ?> />
  <label for="statut_W"><?php echo mb_ucfirst(_t('newsletter','nightsend')); ?></label>
</div>
<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?> 
  <input name="valider" type="submit" value="<?php echo _t('btn','valid'); ?>" class="button" id="valider" />
</div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
// Récapitulatif
} else	{
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"dl3\">\n";
echo "<dt>".mb_ucfirst(_t('newsletter','title'))." :</dt>\n";
echo "<dd>".$form_title."</dd>\n";
echo "<dt>".mb_ucfirst(_t('newsletter','body'))." :</dt>\n";
echo "<dd>".linkin_content($form_body)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut')) ." :</dt>\n";
echo "<dd>". display_statut($_POST['newsletter_statut']). "</dd>\n";
echo "</dl>\n";
?>
<form id="modscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
  <?php echo cancel_button('?rub=newsletter&amp;todo=list'); ?>
  <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
  <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
  </div>
  </form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
}
?>