<?php
/**
 * @package linea21.modules
 * @subpackage page
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////


if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

$page_object = new page;
$mask_statut_P='';
$mask_statut_D='';

if(isset($_POST['enregistrer'])) {
  $data_array=unserialize(urldecode($_POST['data_array']));
  $result=$page_object->ModifyPage($id, $data_array, $sql_object);

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

// Titre de l'actu en cours de modification
$requete=SQL_getPageTitle($id);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $page_current_title=formatText($result[0]['page_title'],'2HTML');


// Obtention des données  de la BDD
$req_det= SQL_getoneCompletePage($id);
$result=$sql_object->DBSelect($req_det);
if($result==0 || count($result)!=1) exit;

$form_title=formatText($result[0]['page_title'], '2FIELD');
$form_header=formatText($result[0]['page_header'], '2FIELD');
$form_body=formatText($result[0]['page_body'], '2FIELD');
$form_statut=$result[0]['page_status'];
$current_status=$result[0]['page_status'];
$page_owner = $result[0]['page_posted_by'];

if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';


if(isset($_POST['valider'])) {
  $table[0]=$_POST['page_title'];
  $table[1]=$_POST['page_header'];
  $table[2]=$_POST['page_body'];
  $table[3]=$l21auth->GetSessionElement('id'); // ID posteur
  $table[4]=$_POST['page_status'];
  $table[5]=$current_status;

  $integrity=$page_object->CheckDataIntegrity($table);


  if(is_string($integrity)) $text_format='2FIELD';
  else $text_format='2HTML';
  $form_title=formatText($_POST['page_title'],$text_format);
  $form_header=formatText($_POST['page_header'], $text_format);
  $form_body=formatText($_POST['page_body'], $text_format);
  $form_statut=$_POST['page_status'];

  if($_POST['page_status']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['page_status']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';

  $table=urlencode(serialize($table));
}


?>


<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','page');?></a></li>
	<li><span><?php echo formatNavTitle(_t('page','mod'). ' : '.$page_current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($page_current_title); ?></h2>
<form id="modpage" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="page_title"><?php echo mb_ucfirst(_t('page','title')); ?> : *</label>
  <input name="page_title" type="text" class="textfield" maxlength="200" id="page_title" value="<?php echo $form_title; ?>" />
</p>
<p>
  <label for="page_header"><?php echo mb_ucfirst(_t('page','header')); ?> : *</label>
  <textarea id="page_header" name="page_header" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_header; ?></textarea>
</p>
<p>
  <label for="page_body"><?php echo mb_ucfirst(_t('page','body')); ?> : *</label>
  <textarea id="page_body" name="page_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
</p>
<p>
  <div class="label"><?php echo mb_ucfirst(_t('page','statut')); ?> : *</div>
  <div class="rightpanel">
  <input name="page_status" type="radio" id="status_P" value="P" <?php echo $mask_statut_P; ?> /><label for="status_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
  <input name="page_status" type="radio" id="status_D" value="D" <?php echo $mask_statut_D; ?> /><label for="status_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
  </div>
</p>
<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?>
  <input name="valider" type="submit" value="<?php echo _t('btn','valid'); ?>" class="button" id="valider" />
</div>
</form>
</div>
	<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
	<?php
	// Récapitulatif
} else	{

  $display_form_header=formatText(empty_nc($form_header));

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"dl3\">\n";
echo "<dt>".mb_ucfirst(_t('page','title'))." :</dt>\n";
echo "<dd>".$form_title."</dd>\n";
echo "<dt>".mb_ucfirst(_t('page','header')). " :</dt>\n";
echo "<dd>".linkin_content($display_form_header)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('page','body'))." :</dt>\n";
echo "<dd>".linkin_content($form_body)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut')) ." :</dt>\n";
echo "<dd>". display_statut($_POST['page_status']). "</dd>\n";
echo "</dl>\n";
?>
<form id="modpage" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">
<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <input name="data_array" type="hidden" value="<?php echo $table; ?>" id="data_array" />
  <?php echo cancel_button('?rub=page&amp;todo=list'); ?>
  <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
  <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
</div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
}
?>