<?php
/**
 * @package linea21.modules
 * @subpackage project
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
?>

<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','project'); ?></a></li>
  	<li><span><?php echo formatNavTitle(_t('project','add')); ?></span></li>
  </ul>
</div>
<!--end barre haute -->
<?php
$form_name='';
$form_description='';
$form_body='';
$form_progression=0;
$form_parent_id=-1;
$form_theme_id=-1;
$form_scale_id=-1;
$form_priority_id=-1;
$form_workshop_id=-1;
$form_sdi= array();
$mask_statut_P="checked=\"checked\"";
$mask_statut_D='';
$form_begin_date='';
$form_estimated_date='';
$form_end_date='';


$project_object = new project;

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$project_object->AddProject($data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if(is_numeric($result)) header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {

  isset($_POST['choose_sdi']) ? $form_sdi=$_POST['choose_sdi'] : $form_sdi=array();

  $table[0]=$_POST['project_name'];
  $table[1]=$_POST['project_description'];
  $table[2]=$_POST['project_body'];
  $table[3]=$_POST['project_parent_id'];
  $table[4]=$_POST['project_scale_id'];
  $table[5]=$_POST['project_priority_id'];
  $table[6]=$_POST['project_begin_date'];
  $table[7]=$_POST['project_estimated_date'];
  $table[8]=$_POST['project_end_date'];
  $table[9]=$l21auth->GetSessionElement('id'); // ID posteur
  $table[10]=$_POST['project_statut'];
  $table[11]=$_POST['project_theme_id'];
  $table[12]=$_POST['project_workshop_id'];
  $table[13]=$form_sdi;
  $table[14]=$_POST['project_progression'];
  $project_object= new project;
  $integrity=$project_object->CheckDataIntegrity($table);
  

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  $form_name=formatText($_POST['project_name'], $text_format);
  $form_description=formatText($_POST['project_description'], $text_format);
  $form_body=formatText($_POST['project_body'], $text_format);
  $form_begin_date=$_POST['project_begin_date'];
  $form_estimated_date=$_POST['project_estimated_date'];
  $form_end_date=$_POST['project_end_date'];
  $form_progression=$_POST['project_progression'];

  $form_theme_id=$_POST['project_theme_id'];
  $form_workshop_id=$_POST['project_workshop_id'];
  $form_scale_id=$_POST['project_scale_id'];
  $form_parent_id=$_POST['project_parent_id'];
  $form_priority_id=$_POST['project_priority_id'];


  if($_POST['project_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['project_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  $table=urlencode(serialize($table));
}


if(!isset($integrity) || is_string($integrity)) {
  include_once("../lib/input_helpers.php");

  // select-box de thèmes
  $data=$sql_object->DBSelect($req_list_theme);
  $select_theme=ThemeSelectBox($data, "project_theme_id", $form_theme_id);

  // select-box de workshops
  $data=$sql_object->DBSelect($req_list_workshop);
  $select_workshop=WorkshopSelectBox($data, "project_workshop_id", $form_workshop_id);

  // select-box des projets
  $data=$sql_object->DBSelect(SQL_getProjectsList(0,1000, 'public'));
  $select_parent=ProjectSelectBox($data, "project_parent_id", $form_parent_id);

  // select-box des échelles
  $data=$sql_object->DBSelect($req_list_scale);
  $select_scale=ScaleSelectBox($data, "project_scale_id", $form_scale_id);

  // select-box des priorités
  $data=$sql_object->DBSelect($req_list_priority);
  $select_priority=PrioritySelectBox($data, "project_priority_id", $form_priority_id);

  // select-box des indicateurs
  $data=$sql_object->DBSelect($req_list_sdi);
  $select_sdi=SDIMultiSelectBox($data, "choose_sdi", $form_sdi);

}

include_once(THEME_ADMIN_PATH."quickicons.php");

footerAddJS('../lib/js/jquery.datePicker.l10n/jquery.ui.datepicker-'.U_L.'.js');
?>

<script type="text/javascript">
	
    $(document).ready( function()
    {
		$("#choose_sdi").multiselect({ noneSelectedText: '<?php echo _t('divers','select_choice'); ?>', selectedList:2, minWidth:'596px' } ).multiselectfilter(); 
		
    	$( "#project_slider" ).slider({
    		range: "min",
			value:<?php echo $form_progression; ?>,
			min: 0,
			max: 100,
			step: <?php echo PROJECT_STEP; ?>,
			slide: function( event, ui ) {
				$( "#project_progression" ).val( ui.value );
				$( "#progression_value" ).html( ui.value + ' %' );
			}
		});
		$( "#project_progression" ).val($( "#project_slider" ).slider( "value" ));
		$( "#project_progression" ).hide();
		$( "#progression_value" ).html( <?php echo $form_progression; ?> + ' %' );

		/** jquery UI datePicker integration
		---------------------------------------------------*/
		
		var dateFormat = "<?php echo DATE_FORMAT; ?>";
		dateFormat = dateFormat.replace("yyyy", "yy");
		
		$(".date-pick").datepicker({
			showOn: "button",
			beforeShow: getAvailableRange,
			buttonImage: "../lib/js/calendar.png",
			buttonImageOnly: true,
			dateFormat: dateFormat
		});
		$( ".date-pick" ).datepicker( $.datepicker.regional[ "<?php echo U_L; ?>" ] );


		function getAvailableRange(input) 
		{ 
		    	var min = new Date(2000, 1 - 1, 1); //Set this to your absolute minimum date
		        var dateMin = min;
		        var dateMax = null;
		        
		        if (input.id == "project_begin_date") 
		        {
		        	dateMin = min; // absolute minimum date                  
		        }
		        else if (input.id == "project_estimated_date")
		        {
		                if ($("#project_begin_date").datepicker("getDate") != null) 
		                {
		                        dateMin = $("#project_begin_date").datepicker("getDate");
		                        dateMin.setDate(dateMin.getDate() + 1);

		                }
		        }
		        else if (input.id == "project_end_date")
		        {
		                if ($("#project_begin_date").datepicker("getDate") != null) 
		                {
		                        dateMin = $("#project_begin_date").datepicker("getDate");
		                        dateMin.setDate(dateMin.getDate() + 1);
		                }
		        }
		    return {
		                minDate: dateMin, 
		                maxDate: dateMax,
		            }; 

		}
		
		
    });
</script>


<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2(_t('project','add')); ?></h2>
<form id="addproject" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
	<label for="project_name"><?php echo mb_ucfirst(_t('project','name')); ?> : *</label>
	<input name="project_name" type="text" maxlength="200" id="project_name" class="textfield" value="<?php echo $form_name; ?>" />
</p>
<p>
	<label for="project_parent_id"><?php echo mb_ucfirst(_t('project','parent')); ?> :</label>
	<?php echo $select_parent; ?>
	</p>
<p>
	<label for="project_description"><?php echo mb_ucfirst(_t('project','description')); ?> : *</label>
	<textarea id="project_description" name="project_description" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_description; ?></textarea>
</p>
<p>
	<label for="project_body"><?php echo mb_ucfirst(_t('project','body')); ?> : *</label>
	<textarea id="project_body" name="project_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
</p>
<p>
	<label for="project_begin_date"><?php echo mb_ucfirst(_t('project','begin_date')); ?> : </label>
	<input name="project_begin_date" type="text" maxlength="10"	id="project_begin_date" class="date-pick shorttextfield" value="<?php echo $form_begin_date; ?>" />
</p>
<p>
	<label for="project_estimated_date"><?php echo mb_ucfirst(_t('project','estimated_date')); ?> : </label>
	<input name="project_estimated_date" type="text" maxlength="10" id="project_estimated_date"	class="date-pick shorttextfield"	value="<?php echo $form_estimated_date; ?>" />
</p>
<p>
	<label for="project_end_date"><?php echo mb_ucfirst(_t('project','end_date')); ?> : </label>
	<input name="project_end_date" type="text" maxlength="10" id="project_end_date" class="date-pick shorttextfield" value="<?php echo $form_end_date; ?>" />
</p>
<div>
	<label for="project_progression"><?php echo mb_ucfirst(_t('project','progression')); ?> : </label>
	<div id="project_slider"></div><div id="progression_value"></div>
	<input type="text" name="project_progression" id="project_progression" value="<?php echo $form_progression; ?>" maxlength="3" class="shorttextfield"  />
</div>
<p>
	<label for="project_priority_id"><?php echo mb_ucfirst(_t('project','priority')); ?> : *</label>
	<?php echo $select_priority; ?>
</p>
<p>
	<label for="project_theme_id"><?php echo mb_ucfirst(_t('project','theme')); ?> : </label>
 	<?php echo $select_theme; ?>
</p>
<p>
	<label for="project_theme_id"><?php echo mb_ucfirst(_t('project','workshop')); ?> : </label>
	<?php echo $select_workshop; ?>
</p>
<p>
	<label for="project_scale_id"><?php echo mb_ucfirst(_t('project','scale')); ?> : *</label>
	<?php echo $select_scale; ?>
</p>
<p>
	<label for="choose_sdi"><?php echo mb_ucfirst(_t('project','sdi')); ?> : </label>
	<?php echo $select_sdi; ?>
</p>
<div class="label"><?php echo mb_ucfirst(_t('project','statut')); ?> : </div>
	<div class="rightpanel">
    	<input name="project_statut" type="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> />
    	<label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
    	<input name="project_statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> />
    	<label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
	</div>

<div>
<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
<?php echo cancel_button('javascript:history.go(-1);'); ?>
<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div>
	<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
	<?php
	// Récapitulatif
} else	{

  if($form_theme_id != -1) {
    $requete=SQL_getonethemeName($form_theme_id);
    $result=$sql_object->DBSelect($requete);
    if($result==0 || count($result)!=1) exit;
    else $theme_denomination=formatText($result[0]['theme_name'], '2HTML');
  } else $theme_denomination=_t('divers','none');

  $query=SQL_getonescaleDenomination($form_scale_id);
  $result=$sql_object->DBSelect($query);
  if($result==0 || count($result)!=1) exit;
  else $scale_denomination=formatText($result[0]['scale_denomination'], '2HTML');

  $query=SQL_getonepriorityName($form_priority_id);
  $result=$sql_object->DBSelect($query);
  if($result==0 || count($result)!=1) exit;
  else $priority_name=formatText($result[0]['priority_name'], '2HTML');

  if($form_parent_id != -1) {
    $query=SQL_getProjectName($form_parent_id);
    $result=$sql_object->DBSelect($query);
    if($result==0 || count($result)!=1) exit;
    else $parent_name=formatText($result[0]['project_name'], '2HTML');
  } else $parent_name=_t('divers','none');

  if($form_workshop_id != -1) {
    $query=SQL_getWorkshopName($form_workshop_id);
    $result=$sql_object->DBSelect($query);
    if($result==0 || count($result)!=1) exit;
    else $workshop_name=formatText($result[0]['workshop_denomination'], '2HTML');
  } else $workshop_name=_t('divers','none');

  if(count($form_sdi) > 0) {
    $sdi_list='<ul style="padding:0">';
    foreach ($form_sdi as &$value) {
      $query=SQL_getSdiName($value);
      $result = $sql_object->DBSelect($query);
      if($result==0 || count($result)!=1) exit;
      else $sdi_list.= '<li>'.formatText($result[0]['sdii_name'], '2HTML').'</li>'.END_LINE;
    }
    $sdi_list.='</ul>';
  } else $sdi_list=_t('divers','none');

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"dl3\">\n";
echo "<dt>".mb_ucfirst(_t('project','name'))." :</dt>\n";
echo "<dd>". $form_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','parent'))." :</dt>\n";
echo "<dd>". $parent_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','description')). " :</dt>\n";
echo "<dd>".empty_nc(linkin_content($form_description))."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','body'))." :</dt>\n";
echo "<dd>".linkin_content($form_body)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','begin_date'))." :</dt>\n";
echo "<dd>".empty_nc($form_begin_date)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','estimated_date'))." :</dt>\n";
echo "<dd>".empty_nc($form_estimated_date)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','end_date'))." :</dt>\n";
echo "<dd>".empty_nc($form_end_date)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','progression'))." :</dt>\n";
echo "<dd>".getProgressbar($form_progression, 100, '%')."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','priority'))." :</dt>\n";
echo "<dd>".$priority_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','theme'))." :</dt>\n";
echo "<dd>".$theme_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','scale'))." :</dt>\n";
echo "<dd>".$scale_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','workshop'))." :</dt>\n";
echo "<dd>".$workshop_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','sdi'))." :</dt>\n";
echo "<dd>".$sdi_list."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
echo "<dd>". display_statut($_POST['project_statut']). "</dd>\n";
echo "</dl>\n";
?>
<form id="addproject" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <?php echo cancel_button('?rub_project&amp;todo=list'); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
  </div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
}
?>