<?php
/**
 * @package linea21.modules
 * @subpackage project
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../project/' . SQL . '.inc.php'));

/**
 * DisplayListProject()
 * Affichage de la liste des projets publics
 *
 * @param string $statut
 * @param integer $filter
 * @param string $id_filter
 * @param integer $debut
 * @return string $content
 */
if(!function_exists('DisplayListProject')) {

  function DisplayListProject($statut, $filter, $id_filter, $debut)
  {
    if ($statut == 'public') {
      $pas = 100;
      $suffix = '';
    } else $pas = SELECT_LIMIT;
    if ($statut == 'archives_p') $suffix = ' "'.strtolower(_t('statut','PA')).'"';
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getProjectsList($debut, $pas, $statut, $filter, $id_filter));
    $datacount = $GLOBALS['sql_object']->DBSelect(SQL_getCountProjectsList($statut, $filter, $id_filter));
    $bdd_nb_com = $datacount[0]['num_rows'];
    $bdd_nb_com_display = '<p>' . $bdd_nb_com . ' ' . _t('project','name') . $suffix . '</p>' . END_LINE;
    $content = '<h1>' . _t('project','list') . '</h1>' . END_LINE;
    if ($data != 0) {
      // echo $bdd_nb_com_display;	// affichage du nombre d'enregistrements
      $current_link = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue']);
      Display_linkin_page($current_link, $bdd_nb_com, $debut, $pas);
      for($i = 0; $i < count($data); $i++) {
        $link_detail = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'id' => $data[$i]['project_id'], 'name' => $data[$i]['project_name']);
        $link_scale = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['scale']['linkvalue'], 'id' => $data[$i]['project_scale_id'], 'name' => $data[$i]['scale_denomination']);
        $link_priority = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['priority']['linkvalue'], 'id' => $data[$i]['priority_id'] , 'name' => $data[$i]['priority_name']);
        $link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[$i]['project_posted_by'], 'name' => $data[$i]['user_login']);
        $project_name = formatText($data[$i]['complete_project_name'], '2HTML');
        $project_description = formatText($data[$i]['project_description'], '2HTML');
        $scale_denomination = formatText($data[$i]['scale_denomination'], '2HTML');
        $project_posted_on = formatText($data[$i]['project_published_date_display'], '2HTML');
        $project_posted_by = formatText($data[$i]['user_login'], '2HTML');
        $project_priority = formatText($data[$i]['priority_name'], '2HTML');
        $project_theme_id = $data[$i]['project_theme_id'];
        if($project_theme_id != 0) {
          $project_theme = formatText($data[$i]['sdtheme_name'], '2HTML');
          $link_theme = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['theme']['linkvalue'], 'id' => $data[$i]['theme_sd_theme'], 'name' => $project_theme);
        }

        $content .= '<h2>' . END_LINE;
        $content .= '<a href="' . HrefMaker($link_detail) . '" title="' . formatText($project_name, '2ATT') . '">' . $project_name . '</a>' . END_LINE;
        $content .= '</h2>' . END_LINE;
        $content .= '<p class="published_by">' . END_LINE;
        $content .= _t('statut','published_on') . ' ' . $project_posted_on . ' ';
        $content .= _t('divers','by').' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links'][U_L]['user-profile']['desc'] . ' (' . $project_posted_by . ')">' . $project_posted_by . '</a>';
        $content .= '</p>' . END_LINE;
         
        $content .= '<div class="chapo">' . $project_description . '</div>' . END_LINE;
        $content .= '<a class="readmore" href="'.HrefMaker($link_detail).'">'._t('btn', 'read_more').'</a>';
        $content .= '<p class="filter_info">';
        $content .= _t('project','priority') . ' : ';
        $content .= ' <a href="' . HrefMaker($link_priority) . '" title="' . $GLOBALS['filters'][U_L]['priority']['desc'] . ' : ' . formatText($project_priority, '2ATT') . '" class="filter_info_priority">' . $project_priority . '</a> ' . END_LINE;
        $content .= _t('divers','scale') . ' : ';
        $content .= ' <a href="' . HrefMaker($link_scale) . '" title="' . $GLOBALS['filters'][U_L]['scale']['desc'] . ' : ' . formatText($scale_denomination, '2ATT') . '" class="filter_info_scale">' . $scale_denomination . '</a>' . END_LINE;
        if($project_theme_id != 0) {
          $content .= ' ' . _t('divers','themeref') . ' : ';
          $content .= '<a href="' . HrefMaker($link_theme) . '" title="' . $GLOBALS['filters'][U_L]['theme']['desc'] . ' : ' . formatText($project_theme, '2ATT') . '" class="filter_info_scale">' . $project_theme . '</a>' . END_LINE;
        }
        $content .= '</p>'.END_LINE;
        if($i<count($data)-1) $content .= '<hr />' . END_LINE;
      }
    } else {
      $content .= '<p class="info">' . _t('divers','nodata') . '</p>';
    }

    echo $content;
  }
}

/**
 * DisplayOneProject()
 * Affichage d'un projet en détail
 *
 * @param integer $project_id
 * @return string $stat status name
 */
if(!function_exists('DisplayOneProject')) {

  function DisplayOneProject($project_id)
  {
  	
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getoneCompleteProject($project_id, array('P', 'PA')));
    $content = '';
    
    if($data == 0) error_redirect();
    
    if (count($data) != 1) exit;
    else {
      $link_scale = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['scale']['linkvalue'], 'id' => $data[0]['project_scale_id'], 'name' => $data[0]['scale_denomination']);
      $link_priority = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['priority']['linkvalue'], 'id' => $data[0]['project_priority_id'], 'name' => $data[0]['project_priority']);
      $link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[0]['project_posted_by'], 'name' => $data[0]['user_login']);
      $link_parent = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'id' => $data[0]['project_parent_id'], 'name' => $data[0]['parent_name']);
      $link_self = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'id' => $project_id);
      $project_name = formatText($data[0]['project_name'], '2HTML');
      $project_description = linkin_content(formatText($data[0]['project_description'], '2HTML'));
      $project_body = linkin_content(formatText($data[0]['project_body'], '2HTML'));
      $project_parent = formatText($data[0]['parent_name'], '2HTML');
      $project_scale = formatText($data[0]['scale_denomination'], '2HTML');
      $project_priority = formatText($data[0]['project_priority'], '2HTML');
      $project_begin_date = formatText(empty_nc($data[0]['project_begin_date_display']), '2HTML');
      $project_estimated_date = formatText(empty_nc($data[0]['project_estimated_date_display']), '2HTML');
      $project_end_date = formatText(empty_nc($data[0]['project_end_date_display']), '2HTML');
      $project_progression = $data[0]['project_completed'];
      $workshop_id = formatText(empty_nc($data[0]['project_workshop_id']), '2HTML');
      $workshop_name = formatText(empty_nc($data[0]['workshop_denomination']), '2HTML');
      $scale_id = $data[0]['project_scale_id'];
      $project_theme_id = $data[0]['project_theme_id'];
      if($project_theme_id != 0) {
        $project_theme = formatText($data[0]['sdtheme_name'], '2HTML');
        $link_theme = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['theme']['linkvalue'], 'id' => $data[0]['theme_sd_theme'], 'name' => $project_theme);
      }

      $schedule_table = getScheduleTable($data[0]['project_begin_date_display'], $data[0]['project_estimated_date_display'], $data[0]['project_end_date_display']);

      $project_posted_on = formatText($data[0]['project_published_date_display'], '2HTML');
      $project_modify_on = formatText($data[0]['project_last_modify_display'], '2HTML');
      $project_posted_by = formatText($data[0]['user_login'], '2HTML');
      $project_status = $data[0]['project_statut'];

      if(commentEnabled('project')) {
        postCommentAction(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $project_id));
        $content .= '<div id="anchor-comments">'.END_LINE;
        $content .= getCommentsAnchor(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $project_id));
        if($project_status == 'P') $content .= getPostCommentAnchor(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $project_id));
        $content .= '</div>'.END_LINE;
      }
      $content .= '<h1>' . $project_name . '</h1>' . END_LINE;
      $content .= '<p class="published_by">' . END_LINE;
      $content .= _t('statut','published_on') . ' ' . $project_posted_on . ' ';
      $content .= _t('divers','by').' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links'][U_L]['user-profile']['desc'] . ' (' . $project_posted_by . ')">' . $project_posted_by . '</a>';
      if ($project_status == 'PA') {
        $content .= ' (' . _t('statut','archived_on') . ' ' . $project_modify_on . ')';
      }
      $content .= formatted_permalink($link_self, ' - ');
      $content .= '</p>' . END_LINE;
      if($data[0]['project_parent_id'] != 0) {
        $content .= '<div id="parent_project">' . END_LINE;
        $content .= _t('project','parent') . ' : ';
        $content .= '<a href="' . HrefMaker($link_parent) . '" title="' . _t('project','parent') . ' : ' . formatText($project_parent, '2ATT') . '" class="filter_info_parent">' . $project_parent . '</a> ';
        $content .= '</div>' . END_LINE;
      }
      $content .= '<div class="chapo">' . $project_description . '</div>' . END_LINE;
      
      $content .= '<div class="schedule">' . $schedule_table . '</div>' . END_LINE;
      $content .= '<div class="progression">'. _t('project','progression'). ' : ' .getProgressbar($project_progression, 100, '%'). '</div>' . END_LINE;
      
      $content .= '<div class="body">' . $project_body . '</div>' . END_LINE;
      $content .= getProjectChildren($project_id);
      //$content .= getAssociatedIndicators($project_id, $scale_id);
      $content .= getAssociatedIndicatorsValues($project_id, $scale_id);
      $content .= getAssociatedWorkshop($workshop_id, $workshop_name);
      $content .= '<p class="filter_info">' . END_LINE;
      $content .= _t('project','priority') . ' : ';
      $content .= '<a href="' . HrefMaker($link_priority) . '" title="' . $GLOBALS['filters'][U_L]['priority']['desc'] . ' : ' . formatText($project_priority, '2ATT') . '" class="filter_info_priority">' . $project_priority . '</a> ' . END_LINE;
      $content .= ' ' . _t('divers','scale') . ' : ';
      $content .= '<a href="' . HrefMaker($link_scale) . '" title="' . $GLOBALS['filters'][U_L]['scale']['desc'] . ' : ' . formatText($project_scale, '2ATT') . '" class="filter_info_scale">' . $project_scale . '</a>' . END_LINE;
      if($project_theme_id != 0) {
        $content .= ' ' . _t('divers','themeref') . ' : ';
        $content .= '<a href="' . HrefMaker($link_theme) . '" title="' . $GLOBALS['filters'][U_L]['theme']['desc'] . ' : ' . formatText($project_theme, '2ATT') . '" class="filter_info_scale">' . $project_theme . '</a>' . END_LINE;
      }
      $content .= '</p>' . END_LINE;
    }
    echo $content;
    return GetStatusName($project_status);
  }
}

/**
 * GetProjectChildren()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getProjectChildren')) {

  function getProjectChildren($id)
  {
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getProjectChildren($id));

    $content = '';
    if (count($data) != 0 && $data[0]!=0) {

      $content .= '<div id="project_children">'.END_LINE;
      $content .= '<p>'._t('project','sub-projects').' : </p><ul>'.END_LINE;
      for($i = 0; $i < count($data); $i++) {
        $link = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'id' => $data[$i]['project_id'], 'name' => $data[$i]['project_name']);
        $name = formatText($data[$i]['project_name'], '2HTML');

        $content .= '<li><a href="' . HrefMaker($link) . '" title="' . _t('project','parent') . ' : ' . formatText($name, '2ATT') . '" class="filter_info_parent">' . $name . '</a></li>' .END_LINE;
      }
      $content .= '</ul></div>'.END_LINE;
    }

    return $content;
  }
}

/**
 * GetStatusName()
 *
 * @param  $status
 * @return $stat Status name
 */
if(!function_exists('GetStatusName')) {

  function GetStatusName($status)
  {
    switch ($status) {
      case 'P':
        $stat = 'public';
        break;
      case 'PA':
        $stat = 'archives_p';
        break;
      case 'AA':
        $stat = 'archives_a';
        break;
      default:
        $stat = 'public';
    }
    return $stat;
  }
}

/**
 * getScheduleTable()
 *
 * @param string $s_date
 * @param string $es_date
 * @param string $e_date
 * @return string $content
 */
if(!function_exists('getScheduleTable')) {

  function getScheduleTable($s_date, $es_date, $e_date) {

    $es_date_class = 'nothing';
    $e_date_class = 'nothing';

    if(!isNullDate($es_date)) {
      if(!isNullDate($e_date)) $es_date_class = date_compare($e_date, $es_date, '>') ? 'warn' : 'good';
      else $es_date_class = date_compare(date("Y-m-d"), $es_date, '>') ? 'bad' : 'good';
    }
    if(!isNullDate($e_date)) {
      if(!isNullDate($es_date)) $e_date_class = date_compare($e_date, $es_date, '>') ? 'bad' : 'good';
      else $e_date_class = 'good';
    } else {
      if(!isNullDate($es_date)) {
        $e_date_class = date_compare(date("Y-m-d"), $es_date, '>') ? 'warn' : 'nothing';
      }
    }

    $content  = '<table class="project" summary="">'.END_LINE;
    $content .= '<thead>'.END_LINE;
    $content .= '<tr>'.END_LINE;
    $content .= '<th>'._t('project','begin_date').'</th>'.END_LINE;
    $content .= '<th>'._t('project','estimated_date').'</th>'.END_LINE;
    $content .= '<th>'._t('project','end_date').'</th>'.END_LINE;
    $content .= '</tr>'.END_LINE;
    $content .= '</thead>'.END_LINE;
    $content .= '<tbody>'.END_LINE;
    $content .= '<tr>'.END_LINE;
    $content .= '<td>'.formatText(empty_nc($s_date)).'</td>'.END_LINE;
    $content .= '<td class="'.$es_date_class.'">'.formatText(empty_nc($es_date)).'</td>'.END_LINE;
    $content .= '<td class="'.$e_date_class.'">'.formatText(empty_nc($e_date)).'</td>'.END_LINE;
    $content .= '</tr>'.END_LINE;
    $content .= '</tbody>'.END_LINE;
    $content .= '</table>'.END_LINE;
    return $content;
  }
}

/**
 * getAssociatedWorkshop()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getAssociatedWorkshop')) {

  function getAssociatedWorkshop($wid, $wname)
  {
    $content = '';
    if($wid != 0) {
      $link = array('rub' => $GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id' => $wid, 'name' => $wname);
      $content .= '<div id="project_workshop">'.END_LINE;
      $content .= '<h3>'.ucfirst(_t('project','workshop')).'</h3>'.END_LINE;
      $content .= '<p><a href="' . HrefMaker($link) . '" title="' . _t('project','workshop') . ' : ' . formatText($wname, '2ATT') . '">' . $wname . '</a></p>' .END_LINE;
      $content .= '</div>'.END_LINE;
    }

    return $content;
  }
}

/**
 * getAssociatedWorkshop()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getAssociatedIndicators')) {

  function getAssociatedIndicators($id, $scale_id)
  {
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getProjectSdi($id));

    $content = '';
    if (count($data) != 0 && $data[0]!=0) {

      $content .= '<div id="project_indicators">'.END_LINE;
      $content .= '<h3>'.ucfirst(_t('project','sdi')).'</h3>'.END_LINE;
      $content .= '<ul>'.END_LINE;
      for($i = 0; $i < count($data); $i++) {
        $link = array('rub' => $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $data[$i]['sdii_id'], 'parentid' => $scale_id, 'name' => $data[$i]['sdii_name']);
        $name = formatText($data[$i]['sdii_name'], '2HTML');

        $content .= '<li><a href="' . HrefMaker($link) . '" title="' . _t('project','sdi') . ' : ' . formatText($name, '2ATT') . '">' . $name . '</a></li>' .END_LINE;
      }
      $content .= '</ul></div>'.END_LINE;
    }

    return $content;
  }
}

/**
 * getAssociatedWorkshop()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getAssociatedIndicatorsValues')) {

	function getAssociatedIndicatorsValues($id, $cursorcssposition = 0)
	{
		
		include_once('../dashboard/display.php');
		include_once('../dashboard/mysql.inc.php');
				
		$result_sdi = $GLOBALS['sql_object']->DBSelect(SQL_getProjectSdiValues($id));

		$content = '';
		$id_filter= 1; // scale id value 
		
		if (count($result_sdi) != 0 && $result_sdi[0]!=0) {

			$content .= '<div id="project_indicators">'.END_LINE;
			$content .= '<h3>'.ucfirst(_t('project','sdi')).'</h3>'.END_LINE;
			
			// table header
			$content .= '<table cellspacing="0" cellpadding="5" class="table_dashboard">' . END_LINE;
			$content .= '<thead>' . END_LINE;
			$content .= '<tr>' . END_LINE;
			$content .= '<td style="width:250px">'.mb_ucfirst(_t('dashboard','graphic_value')).'</td>' . END_LINE;
			//$content .= '<td>'.mb_ucfirst(_t('dashboard','numeric_value')).'</td>' . END_LINE;
			$content .= '<td>'.mb_ucfirst(_t('dashboard','label_value')).'</td>' . END_LINE;
			$content .= '</tr>' . END_LINE;
			$content .= '</thead>' . END_LINE;
			$content .= '<tbody>' . END_LINE;
			
			for ($j = 0;$j < count($result_sdi);$j++) {
			
				// setting $threshold_value
				// By default initial value
				$threshold_value = $result_sdi[$j]['sdii_threshold_value'];
				// if set, we get the latest for the given scale
				$r = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($result_sdi[$j]['sdii_id'], 1));
				if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
					$threshold_value = $r[0]['sdiv_threshold'];
				}
				
				if(CURRENT_APP == 'admin') {
					$link_det_sdi = './index.php?rub=dashboard&todo=det&id='.$result_sdi[$j]['sdii_id'].'&scale_id='.$id_filter;
						
				} else {
					$link_det_sdi= HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$result_sdi[$j]['sdii_id'], 'parentid'=> $id_filter, 'name' => $result_sdi[$j]['sdii_name']));
						
				}
				$content .= "<tr>" . END_LINE;
				$content .= "<td>";
				$content .= getViz($GLOBALS['sql_object'], $id_filter, $result_sdi[$j], $threshold_value, null, $cursorcssposition);
				$content .= "</td>";
				$content .= "<td><a href=\"" . $link_det_sdi . "\" title=\"" . formatText($result_sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText(cutText($result_sdi[$j]['sdii_name'], 53), '2HTML') . "</a></td>" . END_LINE;
				$content .= "</tr>" . END_LINE;
			
			}
			
			$content .= "</tbody>" . END_LINE;
			$content .= "</table>" . END_LINE;
			$content .= "</div>" . END_LINE;
		}
		
			$js = '<script type="text/javascript">
							$(document).ready(function() {
								$(".dashboard-indicator-gauge .cursor").removeAttr("title");
								$(".infobox").hover(
									function() {
										$(this).next().fadeIn("fast");
									},
									function() {
										$(this).next().hide();
									}
								);
								});
						</script>';
		footerAddInlineJS($js, 'default', false);
		

		return $content;

	}
}


?>