<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


// @todo the way filters are handled should be enhanced


/**
 * DisplayFilter()
 * Call specific filters functions
 * filters are defined in config/define_globals.php
 * filters methods are declared in this file.
 * @return void
 */
function DisplayFilter() {

  $content='';
  if(is_array($GLOBALS['filters'][U_L])) {
    $bool = (in_array(1, array_values($GLOBALS['filters'][U_L]))) ? true : false;
    if($bool) echo '<div id="filtercontent">'.END_LINE;
    while (list($key,$value) = each ($GLOBALS['filters'][U_L])) {
      if($value['active'] == 1 && function_exists('Get'.ucfirst($key).'Filter')) {
        eval('Get'.ucfirst($key).'Filter();');
      }
    }
    if($bool) echo '</div>'.END_LINE;
  }
}

/**
 * GetPriorityFilter()
 * Display a list of priorities
 * as filter criteria
 * @return void
 */
function GetPriorityFilter() {
  $result=$GLOBALS['sql_object']->DBSelect(SQL_Get_FilterPriority());
  $list="<div id=\"filterpriority\">".END_LINE;
  $list.= "<h3>"._t('divers','priority_choice')."</h3>".END_LINE;
  $list.= "<ul>".END_LINE;
  $item_active=ActiveItemAlias($GLOBALS['activeitem']);
  for ($i=0;$i<count($result);$i++){
    $name=formatText(cutText($result[$i]['priority_name'],50), '2HTML');
    if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter']==$GLOBALS['filters'][U_L]['priority']['linkvalue'] && $_REQUEST['id']==$result[$i]['priority_id']) {
      $list.="<li>".$name."</li>".END_LINE;
    } else {
      $url = array('rub' => $GLOBALS['links'][U_L][$item_active]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['priority']['linkvalue'], 'id' => $result[$i]['priority_id'], 'name'=> $result[$i]['priority_name']);
      $list.="<li><a href=\"".Hrefmaker($url)."\" title=\"".$GLOBALS['filters'][U_L]['priority']['desc'].' : '.$name."\">".$name."</a></li>".END_LINE;
    }
  }
  $list.="</ul></div>".END_LINE;
  echo $list;

}
/**
 * GetThemeFilter()
 * Display a list of themes
 * as filter criteria
 * @return void
 */
function GetThemeFilter() {
  $result_sdtheme=$GLOBALS['sql_object']->DBSelect(SQL_Get_FilterTheme());
  $sdtheme_list="<div id=\"filtertheme\">".END_LINE;
  $sdtheme_list.= "<h3>"._t('divers','themeref_choice')."</h3>".END_LINE;
  $sdtheme_list.= "<ul>".END_LINE;
  $item_active=ActiveItemAlias($GLOBALS['activeitem']);
  for ($i=0;$i<count($result_sdtheme);$i++){
    $sdtheme_display=formatText(cutText($result_sdtheme[$i]['sdtheme_name'],50), '2HTML');
    if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter']==$GLOBALS['filters'][U_L]['theme']['linkvalue'] && $_REQUEST['id']==$result_sdtheme[$i]['sdtheme_id']) {
      $sdtheme_list.="<li>".$sdtheme_display."</li>".END_LINE;
    } else {
      $URLtheme = array('rub' => $GLOBALS['links'][U_L][$item_active]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['theme']['linkvalue'], 'id' => $result_sdtheme[$i]['sdtheme_id'], 'name'=> $result_sdtheme[$i]['sdtheme_name']);
      $sdtheme_list.="<li><a href=\"".Hrefmaker($URLtheme)."\" title=\"".$GLOBALS['filters'][U_L]['theme']['desc'].' : '.$sdtheme_display."\">".$sdtheme_display."</a></li>".END_LINE;
    }
  }
  $sdtheme_list.="</ul></div>".END_LINE;
  echo $sdtheme_list;
}

/**
 * GetLevelFilter()
 * Display a list of levels
 * as filter criteria
 * @return string
 */
function GetLevelFilter() {
  $result_level=$GLOBALS['sql_object']->DBSelect(SQL_Get_FilterLevel());
  $level_list="<div id=\"filterlevel\">".END_LINE;
  $level_list.="<h3>"._t('divers','level_choice')."</h3>".END_LINE;
  $level_list.="<ul>".END_LINE;
  $item_active=ActiveItemAlias($GLOBALS['activeitem']);
  for ($i=0;$i<count($result_level);$i++){
    $level_display=formatText(cutText($result_level[$i]['level_name'],50), '2HTML');
    if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter']==$GLOBALS['filters'][U_L]['level']['linkvalue'] && $_REQUEST['id']==$result_level[$i]['level_id']) {
      $level_list.="<li>".$level_display."</li>".END_LINE;
    } else {
      $URLlevel= array('rub' => $GLOBALS['links'][U_L][$item_active]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['level']['linkvalue'], 'id' => $result_level[$i]['level_id'], 'name'=> $result_level[$i]['level_name']);
      $level_list.="<li><a href=\"".Hrefmaker($URLlevel)."\" title=\"".$GLOBALS['filters'][U_L]['level']['desc'].' : '.$level_display."\">".$level_display."</a></li>".END_LINE;
    }
  }

  $level_list.="</ul></div>".END_LINE;
  echo $level_list;
}

/**
 * GetScaleFilter()
 * Build the form and include
 * a select box filledd-up by scales
 * @return void
 */
function GetScaleFilter() {
	
	$rubname = $GLOBALS['activeitem'];
	
  $scale_list='<form action="index.php" method="get">'.END_LINE;
  $scale_list.="<div id=\"filterscale\">".END_LINE;
  $scale_list.="<h3>"._t('divers','scale_choice')."</h3>".END_LINE;
  if(isset($_REQUEST['parentid'])) {
  	$scale_list.=GetScaleSelectBox('parentid');
  	$scale_list.='<input type="hidden" value="'.$_REQUEST['id'].'" name="id" id="id_scale" />'.END_LINE;
  } else {
  	$scale_list.=GetScaleSelectBox();
  }

  $scale_list.='<input type="hidden" value="'.$GLOBALS['filters'][U_L]['scale']['linkvalue'].'" name="filter" id="filter" />'.END_LINE;
  $scale_list.='<input type="hidden" value="'.$rubname.'" name="rub" id="rub_scale" />'.END_LINE;
  if(isset($_REQUEST['altmode'])) {
  	$scale_list.='<input type="hidden" value="true" name="altmode" id="altmode_scale" />'.END_LINE;
  }
  $scale_list.='<input type="submit"  value="'._t('btn','valid').'" title="'._t('btn','valid').'" name="valid" id="valid" />'.END_LINE;
  $scale_list.="</div>".END_LINE;
  $scale_list.='</form>'.END_LINE;
  echo $scale_list;
}

/**
 * GetScaleSelectBox()
 * Called by GestFilterScale()
 * Prepare select Box items
 * @return string
 */
function GetScaleSelectBox($field_name = 'id') {
  if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter']==$GLOBALS['filters'][U_L]['scale']['linkvalue']) $current_id=$_REQUEST['id']; else $current_id=-1;
  if(ActiveItemAlias($GLOBALS['activeitem'])=='dashboard' && isset($_REQUEST['parentid'])) $current_id=$_REQUEST['parentid'];

  if (ActiveItemAlias($GLOBALS['activeitem'])==$GLOBALS['links'][U_L]['news']['linkvalue']) {
    $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_FilterScale("I"));
  }
  else $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_FilterScale());

  $scale_list='';
  $item_active=ActiveItemAlias($GLOBALS['activeitem']);
  for ($i=0;$i<count($data);$i++){
    if($data[$i]['scale_id']==$current_id) {
      $mask=' selected="selected"';
    } else $mask='';
    $scale_display=formatText(cutText($data[$i]['scale_denomination'],20));
    $scale_list.="<option value=\"".$data[$i]['scale_id']."\"".$mask.">".$scale_display."</option>".END_LINE;
  }
  $select_scale ='<select name="'.$field_name.'" id="scaleFilter'.$field_name.'">'.END_LINE;
  $select_scale.='<option value="1">'._t('divers','select_choice2').'</option>'.END_LINE;
  $select_scale.=$scale_list;
  $select_scale.='</select>'.END_LINE;

  return $select_scale;
}

?>