<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>


<?php
// set HTML Title
SetHTMLTitle('Charte d\'accessibilité Linea21');
setBreadcrumb(array('Charte d\'accessibilité Linea21' => false));
?>

<div id="accessibilite">
<h1>Charte d'accessibilité Linea21</h1>
<div class="sub-title">Ce site est conçu pour
être lu par tous les internautes, indépendamment de leurs handicaps, du
medium utilisé et de la configuration matérielle.</div>


<h2>Access key</h2>
<p>La plupart des navigateurs autorise le suivi de liens par une
combinaison de touches définie sur le site. Sous Windows, tapez alt +
une clef d'accés. Sous Macintosh, tapez ctrl + une clef d'accés. <br />
Toutes les pages sur ce site contiennent ces <span xml:lang="en">accesskey</span>
:</p>
<dl>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['accessibility']['accesskey'] ?></kbd>
	:</dt>
	<dd>Charte d'accessibilité</dd>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['home']['accesskey'] ?></kbd>
	:</dt>
	<dd>Accueil</dd>
	<dt xml:lang="en">Access key <kbd>2</kbd> :</dt>
	<dd>Contenu</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['search']['accesskey'] ?></kbd>
	:</dt>
	<dd>Recherche</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['news']['accesskey'] ?></kbd>
	:</dt>
	<dd>Actualités</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['project']['accesskey'] ?></kbd>
	:</dt>
	<dd>Projets</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['directory']['accesskey'] ?></kbd>
	:</dt>
	<dd>Annuaire</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['workgroup']['accesskey'] ?></kbd>
	:</dt>
	<dd>Groupes de travail</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['publication']['accesskey'] ?></kbd>
	:</dt>
	<dd>Dossiers</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['dashboard']['accesskey'] ?></kbd>
	:</dt>
	<dd>Tableau de bord</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['user-prefs']['accesskey'] ?></kbd>
	:</dt>
	<dd>Compte utilisateurs</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['user-registration']['accesskey'] ?></kbd>
	:</dt>
	<dd>Création de compte</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['logout']['accesskey'] ?></kbd>
	:</dt>
	<dd>Déconnexion</dd>
</dl>
<br style="clear: both;" />
<h2 style="margin-top: 1em">Respects des standards</h2>
<ul>
	<li>Toutes les pages sur ce site ont été validées en <abbr
		title="eXtensible HyperText Markup Language">XHTML</abbr> 1.0 Strict</li>
	<li>Toutes les pages sur ce site ont été testées avec <a
		href="http://www-3.ibm.com/able/solution_offerings/hpr.html"
		title="Information" xml:lang="en" hreflang="en">Home Page Reader 3.0
	(IBM® Accessibility Tool)</a>.</li>
	<li>Toutes les pages sur ce site respectent les valeurs sémantiques.
	les balises H1 sont utilisées pour les titres principaux les balises H2
	pour les sous titres. Par exemple, sur cette page, les utilisateurs du
	logiciel <abbr title="Job Access With Speech">JAWS</abbr> peuvent
	accéder à la section suivante en pressant la combinaison de touche :
	ALT+INSERT+3</li>
</ul>


<h2>Aide à la navigation</h2>
<ul>
	<li>Toutes les pages de ce site contiennent les élements de navigation
	et de relations entre elles. <br />
	<pre>
			<code>
&lt;link rel="home" title="accueil" href="accueil" /&gt;
&lt;link rel="search" title="recherche" href="recherche" /&gt;
&lt;link rel="help" title="Charte d'accessibilité Linea21" href="accessibilite" /&gt;
			</code>
		</pre></li>
	<li>La page d'accueil et toutes les autres pages incluent un champ de
	recherche (access key <kbd>4</kbd>).</li>
</ul>

<h2>Liens</h2>
<ul>
	<li>La plupart des liens ont un attribut "title" qui décrit le lien en
	détail.</li>
	<li>Les liens sont écrits pour avoir un sens hors contexte.</li>
	<li>Les langages de script sont utilisés pour améliorer le confort de
	navigation, néanmoins leurs désactivations n'occasionnent aucune
	restriction d'accessibilité au contenu et à la navigation.</li>
</ul>

<h2>Images</h2>
<ul>
	<li>Toutes les images décoratives sont incluses sous formes de style <abbr
		title="Cascadind Style Sheet">CSS</abbr>.</li>
	<li>Les images relatives au contenu utilisent toutes les balises
	descriptives <acronym title="Alternative">Alt</acronym>.</li>
</ul>

<h2>Formulaires</h2>
<ul>
	<li>Un effort a été fait pour rendre les formulaires accessibles :
	l'utilisation de la balise 'LABEL' associe un sens à chaque champ.</li>
</ul>

<h2>Design visuel</h2>
<ul>
	<li>Ce site utilise les feuilles de style en cascade (<abbr
		title="Cascadind Style Sheet">CSS</abbr>) pour la présentation
	graphique. Si votre navigateur ne supporte pas les <abbr
		title="Cascadind Style Sheet">CSS</abbr>, le contenu du site reste
	lisible.</li>
	<li>Ce site utilise exclusivement des tailles de polices relatives,
	compatible avec l'option "taille de texte" spécifiée par l'utilisateur
	dans les navigateurs visuels. Vous pouvez par le raccourci clavier <kbd>ctrl
	+ molette</kbd>, changer le taille du texte.</li>
</ul>

<h2>Feuilles de style alternatives</h2>
<ul>
	<li>Ce site peut être parcouru avec les feuilles de styles alernatives
	disponible en bas de page :</li>
	<li>Quatre styles sont disponibles : noir et blanc, minimal, classique,
	et sans style.</li>
</ul>

<h2>Avertissements - responsabilité</h2>
<ul>
	<li>Le contenu publié sur ce site n'est pas issu de <a
		href="<?php echo SITE_LINEA_URL; ?>">Linea21</a>, nous ne pouvons
	garantir une accessibilité parfaite des données contenues au sein de
	l'application.</li>
	<li>N'hésitez pas à nous signaler les points faibles ou nous faire part
	de vos remarques relatives à l'accessibilité de l'information contenue
	sur ce site : <a href="mailto:<?php echo MAIL_LINEA; ?>"><?php echo MAIL_LINEA; ?></a></li>
</ul>

<h2>Références</h2>
<ul>
	<li><a href="http://handy.univ-lyon1.fr/access/"
		title="par la Mission handicap de l'Universit&eacute; Claude Bernard Lyon I">Traduction
	française des normes</a> de la <abbr
		title="Web Accessibility Initiative">WAI</abbr> sur l'accessibilité.</li>
	<li><a href="http://www.la-grange.net/accessibilite/index.html"
		title="Pourquoi dois-je rendre mon site Web plus accessible ? Comment puis-je rendre mon site web plus accessible ?">Plongez
	dans l'accessibilité</a> : traduction française par Karl Dubost d'un
	texte très pédagogique écrit par Mark Pilgrim.</li>
</ul>

<h2>Outils gratuits</h2>
<ul>
	<li><a href="http://validator.w3.org/" hreflang="en">W3C MarkUp
	Validation Service</a> : contrôle de la syntaxe des pages <abbr
		title="HyperText Markup Language ">HTML</abbr> et <abbr
		title="eXtensible HyperText Markup Language">XHTML</abbr>.</li>
	<li><a href="http://jigsaw.w3.org/css-validator/" hreflang="en">W3C CSS
	Validation service</a> : contrôle de conformité syntaxique des feuilles
	de style en cascade.</li>
	<li><a href="http://bobby.watchfire.com/bobby/html/en/index.jsp"
		title="La version gratuite en ligne permet de tester une page &agrave; la fois"
		hreflang="en">Bobby</a> : outil de contrôle en ligne de la conformité
	de pages par rapport aux recommendations de la <abbr
		title="Web Accessibility Initiative">WAI</abbr> et du gouvernement
	américain en ce qui concerne l'accessibilité.</li>
	<li><a href="http://www.w3.org/People/Raggett/tidy/"
		title="Clean up your Web pages with HTML TIDY" hreflang="en"><abbr
		title="HyperText Markup Language ">HTML</abbr> Tidy</a> : un outil qui
	corrige rapidement la plupart des erreurs de syntaxe sur le langage <abbr
		title="HyperText Markup Language ">HTML</abbr> et donne quelques
	conseils d'accessibilité.</li>
	<li><a href="http://www.delorie.com/web/wpbcv.html" hreflang="en">Web
	Page Backward Compatibility Viewer</a> : permet de se rendre compte de
	l'aspect d'une page Web dans un logiciel plus ancien ou moins puissant.</li>
	<li><a href="http://lynx.isc.org/release/"
		title="Page de la distribution stable de Lynx" hreflang="en">Lynx</a>
	: un navigateur en mode texte.</li>
	<li><a href="http://artax.karlin.mff.cuni.cz/~mikulas/links/"
		title="Sources du programme Links" hreflang="en">Links</a> : un autre
	navigateur en mode texte, pour Unix et OS/2.</li>
</ul>
</div>
