<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../workshop/display.php'));

SetHTMLTitle(_t('workshop','section'));

$GLOBALS['filters'][U_L]['theme']['active'] = 1; // filter activation
$GLOBALS['filters'][U_L]['level']['active'] = 1; // filter activation


/* Post Values instances */
//filter theme & scale
$filter= isset($_REQUEST['filter']) ? $_REQUEST['filter'] : '';
//value of pagination
$debut= isset($_REQUEST['debut']) ? $_REQUEST['debut'] : 0;
//id for workgroup
$workshop_id= isset($_REQUEST['id']) ? $_REQUEST['id'] : '';
//body for topic
$body= isset($_REQUEST['body']) ? $_REQUEST['body'] : '';
//title for topic
$title= isset($_REQUEST['title']) ? $_REQUEST['title'] : '';
// case for test integrity for update a post or add a topic
$confirm= isset($_REQUEST['confirm']) ? $_REQUEST['confirm'] : '';


if(ActiveItemKey($GLOBALS['activeitem']) == 'topic' || ActiveItemKey($GLOBALS['activeitem']) == 'post-add') {
  $topic_id=$_REQUEST['id'];
  $workshop_id=$_REQUEST['parentid'];
}

if (ActiveItemKey($GLOBALS['activeitem']) == 'post-update') {
  $topic_id=$_REQUEST['parentparentid'];
  $workshop_id=$_REQUEST['parentid'];
  $post_id=$_REQUEST['id'];
}

$is_authenticated=$GLOBALS['l21auth']->isWorkgroupUser($workshop_id, $GLOBALS['sql_object']);


//display list workgroup
if (!isset($_REQUEST['id']) || isset($_REQUEST['filter']))
{
  setBreadcrumb(array(ucfirst(_t('workshop', 'section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']))));
  echo "<h1>"._t('workshop','h1_public')."</h1>";
  echo "<div class=\"sub-title\">"._t('workshop','h1_public_comment')."</div>";
  DisplayListWorkshop($workshop_id, $filter);
}
else
{
  //display one workgroup
  $result=$GLOBALS['sql_object']->DBSelect(SQL_getWorkshopDenomination($workshop_id));
  $workshop_name = formatText($result[0]['workshop_denomination'], '2HTML');
  SetHTMLTitle($workshop_name);
  setBreadcrumb(array(ucfirst(_t('workshop', 'name')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']))));
  setBreadcrumb(array($workshop_name => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id'=>$_REQUEST['id']))));
  DisplayOneWorkshop($workshop_id, "title");
  ?>
<!-- workgroup data -->
<div id="workshop"><?php DisplayOneWorkshop($workshop_id);?> <?php if (!$is_authenticated) DisplayUrlInscription($workshop_id, $is_authenticated); ?>
</div>
<!-- end workgroup data -->

<div class="internal-nav">
<ul>
	<li><?php  DisplayUrlCalendar($workshop_id, $workshop_name); ?></li>
	<?php if ($is_authenticated) {?>
	<li><?php DisplayUrlTopicList($workshop_id, $workshop_name );?></li>
	<li><?php DisplayUrlFiles($workshop_id, $workshop_name); ?></li>
	<?php } ?>
	<li><?php  DisplayUrlListerapport($workshop_id, $workshop_name); ?></li>
	<?php if ($is_authenticated){?>
	<li><?php DisplayUrlListeutilisateur($workshop_id, $workshop_name); ?></li>
	<?php }?>
</ul>
</div>

<div class="internal-content <?php echo ActiveItemKey($GLOBALS['activeitem']); ?>"><?php
switch( ActiveItemKey($GLOBALS['activeitem']) )
{
  case "topic-list":
    if($is_authenticated){
      echo "<h2>"._t('workshop','com')."</h2>";
      DisplayListTopic($workshop_id, $debut);
      setBreadcrumb(array(_t('workshop','com_public') => false));
    }
    break;

  case "topic":
    if($is_authenticated){
      echo "<h2>"._t('workshop','com')."</h2>";
      DisplayTopic($workshop_id, $topic_id, $debut);
      setBreadcrumb(array(_t('workshop','com_public') => false));
    }
    break;

  case "files":
    if($is_authenticated){
      echo '<h2>'._t('workshop','shared_files').'</h2>'.END_LINE;
      uploadForm($workshop_id);
      echo '<div id="allfiles">'.END_LINE;
      DisplayFiles($workshop_id, SITE_ROOT_URL);
      echo '</div>'.END_LINE;
      setBreadcrumb(array(_t('workshop','shared_files') => false));
    }
    break;

  case "topic-add":
    if($is_authenticated){
      setBreadcrumb(array(ucfirst(_t('workshop', 'add_com')) => false));
      echo "<h2>"._t('workshop','com')."</h2>";
      AddTopic($workshop_id, $debut, $body, $title, $confirm);
    }
    break;

  case "post-add":
    if($is_authenticated){
      echo "<h2>"._t('workshop','com')."</h2>";
      AddPost($workshop_id, $topic_id, $debut, $body, $title);
    }
    break;

  case "post-update":
    if($is_authenticated){
      echo "<h2>"._t('workshop','com')."</h2>";
      UpdatePost($workshop_id, $topic_id, $debut, $body, $title, $post_id, $confirm);
    }
    break;

  case "user-all":
    echo "<h2>"._t('workshop','participant')."</h2>";
    DisplayUserWorkshop($workshop_id);
    setBreadcrumb(array(_t('workshop','participant') => false));
    break;

  case "report-all":
    echo '<div id="reports">'.END_LINE;
    echo "<h2>"._t('workshop','report')."</h2>";
    DisplayListReport($workshop_id, 'P');
    echo '</div>'.END_LINE;
    echo '<div id="reports-archived">'.END_LINE;
    echo "<h2>"._t('workshop','archived_report')."</h2>";
    DisplayListReport($workshop_id, 'PA');
    echo '</div>'.END_LINE;
    setBreadcrumb(array(_t('workshop','barre_report') => false));
    break;

  default:
    echo "<h2>"._t('workshop','calendar')."</h2>";
    DisplayCalendar($workshop_id);
    setBreadcrumb(array(_t('workshop','cal_all') => false));
    break;
} 
?>
</div>
<br style="clear: both" />
<?php
}
?>