<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../config/define.php');
include_once('../lib/no_cache.php');
distInclude('../public/'.SQL.'.inc.php', THEME_PUBLIC_DIST);
include_once('../languages/' . U_L. '/lang_common.' . CHARSET . '.php');

$data=$sql_object -> DBSelect(SQL_getRSS2formatedNews());

$content='';
if($data!=0) {

  for($i=0; $i<count($data); $i++) {
    $news_id=$data[$i]['news_id'];
    $news_title=$data[$i]['news_title'];
    $news_posted_by=$data[$i]['user_login'];
    $news_header=$data[$i]['news_header'];
    $news_body=$data[$i]['news_body'];
    $news_theme=$data[$i]['theme_name'];
    $news_date=date_rfc2822($data[$i]['news_published_date_display']);
    $link_news=array ('rub'=>$GLOBALS['links'][U_L]['news']['linkvalue'], 'id'=>$news_id, 'name' => $news_title);
    
    if(!empty($news_header)) $news_content = $news_header;
    else   $news_content = $news_body;

    $content.='<item>'.END_LINE;
    $content.='	<title>'.$news_title.'</title>'.END_LINE;
    $content.='	<link>'.CURRENT_APP_URL . HrefMaker($link_news).'</link>'.END_LINE;
    $content.='	<pubDate>'.$news_date.'</pubDate>'.END_LINE;
    $content.='	<category>'.$news_theme.'</category>'.END_LINE;
    $content.='	<guid isPermaLink="false">'.$news_id.'@'. CURRENT_APP_URL .'</guid>'.END_LINE;
    $content.='	<description>'.END_LINE;
    $content.='	<![CDATA[ '.$news_header.' ]]>';
    $content.='	</description>'.END_LINE;
    $content.='	<content:encoded><![CDATA['.$news_body.']]></content:encoded>';
    $content.='</item>'.END_LINE;
  }
}





/**
 * HEADER RSS
 ****************************************************************/
header('Content-Type: application/rss+xml');
echo '<?xml version="1.0" encoding="UTF-8"?>';
echo '<rss version="2.0" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
	xmlns:admin="http://webns.net/mvcb/"
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
	xmlns:atom="http://www.w3.org/2005/Atom" 
	xmlns:content="http://purl.org/rss/1.0/modules/content/">'.END_LINE;

echo '<channel>'.END_LINE;
echo '	<title>'.SITE_NAME.'</title>'.END_LINE;
echo '	<link>'.CURRENT_APP_URL.'</link>'.END_LINE;
echo '	<atom:link href="'.CURRENT_APP_URL.'rss2.php" rel="self" type="application/rss+xml" />'.END_LINE;
echo '	<description>'.CURRENT_APP_URL.'</description>'.END_LINE;
echo '	<language>'.strtolower(U_L).'</language>'.END_LINE;
echo '	<copyright>Copyright '.date('Y').' - '.SITE_NAME.'</copyright>'.END_LINE;
echo '	<managingEditor>'.SITE_MAIL.'</managingEditor>'.END_LINE;
echo '	<webMaster>'.SITE_MAIL.'</webMaster>'.END_LINE;
echo '	<lastBuildDate>'.date('r').'</lastBuildDate>'.END_LINE;
echo '	<generator>'.SITE_LINEA_NAME.'</generator>'.END_LINE;
echo '	<sy:updatePeriod>hourly</sy:updatePeriod>'.END_LINE;
echo '	<sy:updateFrequency>1</sy:updateFrequency>'.END_LINE;
echo '	<sy:updateBase>2000-01-01T12:00+00:00</sy:updateBase>'.END_LINE;
echo '	<image>'.END_LINE;
echo '		<url>http://www.linea21.com/logo_linea.gif</url>'.END_LINE;
echo '      <link>http://www.linea21.com</link>'.END_LINE;
echo '		<title>linea21.com</title>'.END_LINE;
echo '	</image>'.END_LINE;



echo $content;


/**
 * FOOTER RSS
 **********************************************************/
echo '</channel>'.END_LINE;
echo '</rss>';
?>