<?php
/**
 * @package linea21.modules
 * @subpackage publication
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../publication/'.SQL.'.inc.php'));

if(!function_exists('DisplayListPublication')) {

  function DisplayListPublication($statut, $filter, $id_filter, $debut) {

    if($statut=='public') {
      $pas=100;
      $suffix='';
    } else $pas=SELECT_LIMIT;
    if($statut=='archives_p') $suffix=' '._t('statut','PA');
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationList($debut, $pas, $statut, $filter, $id_filter));
    $datacount=$GLOBALS['sql_object'] -> DBSelect(SQL_getCountPublicationList($statut, $filter, $id_filter));
    $bdd_nb_com=$datacount[0]['num_rows'];
    $bdd_nb_com_display = '<p>'.$bdd_nb_com.' '._t('publication','name2').' '.$suffix.'</p>'.END_LINE;

    $content= '<h1>'._t('publication','listing').'</h1>'.END_LINE;
    $content.='<div class="sub-title">';
    $content.=_t('publication','h1_public_comment');
    $content.='</div>';
    if($data!=0)
    {
      //echo $bdd_nb_com_display;
      $current_link = array('rub' => $GLOBALS['links'][U_L]['publication-archives']['linkvalue']);
      Display_linkin_page($current_link,$bdd_nb_com, $debut, $pas);
      for($i=0; $i<count($data); $i++) {
        $link_detail= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'],'id'=>$data[$i]['publi_id'], 'name' => $data[$i]['publi_title']);
        $link_theme= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['theme']['linkvalue'],'id'=>$data[$i]['sdtheme_id'], 'name' =>  $data[$i]['sdtheme_name']);
        $link_level= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['level']['linkvalue'],'id'=>$data[$i]['publi_level'], 'name' =>  $data[$i]['level_name']);
        $link_scale= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['scale']['linkvalue'],'id'=>$data[$i]['publi_scale'], 'name' =>  $data[$i]['scale_denomination']);
        $link_user= array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'],'id'=>$data[$i]['publi_posted_by'], 'name' => $data[$i]['user_login']);
        $publi_title=formatText($data[$i]['complete_publi_title'], '2HTML');
        $publi_resume=formatText($data[$i]['publi_resume'], '2HTML');
        $publi_sdtheme=formatText($data[$i]['sdtheme_name'], '2HTML');
        $level_name=formatText($data[$i]['level_name'], '2HTML');
        $scale_denomination=formatText($data[$i]['scale_denomination'], '2HTML');
        $publi_posted_on=formatText($data[$i]['publi_published_date_display'], '2HTML');
        $publi_posted_by=formatText($data[$i]['user_login'], '2HTML');
         
        $content.='<h2>'.END_LINE;
        $content.='<a href="'.HrefMaker($link_detail).'" title="'.$publi_title.'">'.$publi_title.'</a>'.END_LINE;
        $content.='</h2>'.END_LINE;
        $content.='<p class="published_by">'.END_LINE;
        $content.=_t('statut','published_on') . ' ' .$publi_posted_on.' ';
        $content.=_t('divers','by').' <a href="'.HrefMaker($link_user).'" title="'.formatText($GLOBALS['links'][U_L]['user-profile']['desc']. ' ('.$publi_posted_by.')', '2ATT').'">'.$publi_posted_by.'</a>';
        $content.='</p>'.END_LINE;
        $content.='<div class="chapo">'.$publi_resume.'</div>'.END_LINE;
        $content .= '<a class="readmore" href="'.HrefMaker($link_detail).'">'._t('btn', 'read_more').'</a>';
        $content.='<p class="filter_info">';
        $content .= _t('divers','level') . ' : ';
        $content.='<a href="'.HrefMaker($link_level).'" title="'.formatText($GLOBALS['filters'][U_L]['level']['desc'].' : '.$level_name, '2ATT').'" class="filter_info_level">'.$level_name.'</a> '.END_LINE;
        $content .= _t('divers','themeref') . ' : ';
        $content.='<a href="'.HrefMaker($link_theme).'" title="'.formatText($GLOBALS['filters'][U_L]['theme']['desc'].' : '.$publi_sdtheme, '2ATT').'" class="filter_info_theme">'.$publi_sdtheme.'</a>'.END_LINE;
        $content .= _t('divers','scale') . ' : ';
        $content.='<a href="'.HrefMaker($link_scale).'" title="'.formatText($GLOBALS['filters'][U_L]['scale']['desc'].' : '.$scale_denomination, '2ATT').'" class="filter_info_scale">'.$scale_denomination.'</a>'.END_LINE;
        $content.='</p>'.END_LINE;
        $content.='<hr />'.END_LINE;
      }
    }
    else
    {
      $content.='<p class="info">'._t('divers','nodata').'</p>';
    }

    echo $content;
  }
}

if(!function_exists('DisplayOnePublication')) {

  function DisplayOnePublication($publi_id) {
  	
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getoneCompletePublication($publi_id, array('P', 'PA')));
    $content = '';    
    
    if($data == 0) error_redirect();
    
    if (count($data) != 1) exit;
    else {
      $link_theme= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['theme']['linkvalue'],'id'=>$data[0]['theme_sd_theme'], 'name' => $data[0]['sdtheme_name']);
      $link_level= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['level']['linkvalue'],'id'=>$data[0]['publi_level'], 'name' => $data[0]['level_name']);
      $link_scale= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['scale']['linkvalue'],'id'=>$data[0]['publi_scale'], 'name' => $data[0]['scale_denomination']);
      $link_user= array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'],'id'=>$data[0]['publi_posted_by'], 'name' => $data[0]['user_login']);
      $link_self = array('rub' => $GLOBALS['links'][U_L]['publication']['linkvalue'], 'id' => $publi_id);
       
      $publi_title=formatText($data[0]['publi_title'], '2HTML');
      $publi_resume=linkin_content(formatText($data[0]['publi_resume'], '2HTML'));
       
      $publi_sdtheme=formatText($data[0]['sdtheme_name'], '2HTML');
      $publi_scale_denomination=formatText($data[0]['scale_denomination'], '2HTML');
      $publi_theme=formatText($data[0]['theme_name'], '2HTML');
      $publi_level=formatText($data[0]['level_name'], '2HTML');
       
      $publi_posted_on=formatText($data[0]['publi_published_date_display'], '2HTML');
      $publi_posted_by=formatText($data[0]['user_login'], '2HTML');
      $publi_modify_on=formatText($data[0]['publi_last_modify_display'], '2HTML');
      $publi_statut=$data[0]['publi_statut'];
       
      // workrep_workshop_id
    if(commentEnabled('publication')) {
        postCommentAction(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $publi_id));
        $content .= '<div id="anchor-comments">'.END_LINE;
        $content .= getCommentsAnchor(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $publi_id));
        if($publi_statut == 'P') $content .= getPostCommentAnchor(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $publi_id));
        $content .= '</div>'.END_LINE;
      }
      $content.='<h1>'.$publi_title.'</h1>'.END_LINE;
      $content.='<p class="published_by">'.END_LINE;
      $content.=_t('statut','published_on').' '.$publi_posted_on.' ';
      $content.=_t('divers','by').' <a href="'.HrefMaker($link_user).'" title="'.$GLOBALS['links'][U_L]['user-profile']['desc']. ' ('.$publi_posted_by.')">'.$publi_posted_by.'</a>';
      if($publi_statut=='PA')  {
        $content.=' ('._t('statut','archived_on').' '.$publi_modify_on.')';
      }
      $content .= formatted_permalink($link_self, ' - ');
      $content.='</p>'.END_LINE;
      $content.='<div class="chapo">'.$publi_resume.'</div>';

      $content.='<p class="filter_info">';
      $content.=_t('divers','level').' : '.END_LINE;
      $content.='<a href="'.HrefMaker($link_level).'" title="'.formatText($GLOBALS['filters'][U_L]['level']['desc'].' : '.$publi_level, '2ATT').'" class="filter_info_level">'.$publi_level.'</a> '.END_LINE;
      $content.=_t('divers','themeref').' : '.END_LINE;
      $content.='<a href="'.HrefMaker($link_theme).'" title="'.formatText($GLOBALS['filters'][U_L]['theme']['desc'].' : '.$publi_sdtheme, '2ATT').'" class="filter_info_theme">'.$publi_sdtheme.'</a>'.END_LINE;
      //$content._t('divers','sousthemeref').' : '.END_LINE;
      //$content.=$publi_theme.END_LINE;
      $content.=_t('divers','scale').' : ';
      $content.='<a href="'.HrefMaker($link_scale).'" title="'.formatText($GLOBALS['filters'][U_L]['scale']['desc'].' : '.$publi_scale_denomination, '2ATT').'" class="filter_info_scale">'.$publi_scale_denomination.'</a>'.END_LINE;
      $content.='</p>'.END_LINE;
      $content.='<hr />'.END_LINE;

       
    }
    echo $content;
    
    return $publi_statut;
    
  }
}

if(!function_exists('DisplayPublicationParts')) {

  function DisplayPublicationParts($publi_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationParts($publi_id));
    $content ='<div class="parts">'.END_LINE;
    $content.='<h2>'._t('publication','parts').'</h2>'.END_LINE;
    if($data!=0)
    {
      $content.='<ol>'.END_LINE;
      for($i=0; $i<count($data); $i++) {
        $link_parts= array('rub'=> $GLOBALS['links'][U_L]['publication-part']['linkvalue'],'id'=> $data[$i]['publicon_id'],'parentid'=>$publi_id, 'name' => $data[$i]['publicon_title']);
        $publicon_title=formatText($data[$i]['publicon_title'], '2HTML');
        $content.='<li>'.END_LINE;
        //$content.='<span class="num">'.($i+1).' - </span>'.END_LINE;
        $content.='<a href="'. HrefMaker($link_parts).'">';
        $content.=$publicon_title;
        $content.='</a>';
        $content.='</li>'.END_LINE;
      }
      $content.='</ol>'.END_LINE;
    }
    else
    {
      $content.='<p class="info">'._t('publication','no_part').'</p>';
    }
    $content.='</div>'.END_LINE;
    //$content.='<hr />';

    echo $content;
  }
}

if(!function_exists('DisplayPublicationLinks')) {

  function DisplayPublicationLinks($publi_id) {

    $data=SQL_GetResources($publi_id, 'P', 'LINK', $GLOBALS['sql_object']);
    $content ='<div class="links">'.END_LINE;
    $content.='<h2>'._t('publication','link_res').'</h2>'.END_LINE;
    if($data!=0)
    {
      $content.='<ul>'.END_LINE;
      for($i=0; $i<count($data); $i++) {
        $linkres_mask=formatText($data[$i]['linkres_mask'], '2HTML');
        $linkres_text=$data[$i]['linkres_text'];
        $content.='<li>'.END_LINE;
        $content.='<a href="'. $linkres_text.'" class="out">';
        $content.=$linkres_mask;
        $content.='</a>';
        $content.='</li>'.END_LINE;
      }
      $content.='</ul>'.END_LINE;

    }
    else
    {
      $content.='<p class="info">'._t('publication','no_link').'</p>';
    }
    $content.='</div>'.END_LINE;
    //$content.='<hr />'.END_LINE;

    echo $content;
  }
}

if(!function_exists('DisplayPublicationBiblio')) {

  function DisplayPublicationBiblio($publi_id) {

    $data=SQL_GetResources($publi_id, 'P', 'BIBLIO', $GLOBALS['sql_object']);
    $content ='<div class="biblio">'.END_LINE;
    $content.='<h2>'._t('publication','biblio_res').'</h2>'.END_LINE;
    if($data!=0)
    {
      $content.='<ul>'.END_LINE;
      for($i=0; $i<count($data); $i++) {
        $bibliores_author=formatText($data[$i]['bibliores_author'], '2HTML');
        $bibliores_title=formatText($data[$i]['bibliores_title'], '2HTML');
        $bibliores_sub_title=empty($data[$i]['bibliores_sub_title']) ?  '' : ', '.formatText($data[$i]['bibliores_sub_title'], '2HTML');
        $bibliores_editor=empty($data[$i]['bibliores_editor']) ?  '' : ' - '.formatText($data[$i]['bibliores_editor'], '2HTML');
        $bibliores_date=empty($data[$i]['bibliores_date']) ?  '' : ', '.formatText($data[$i]['bibliores_date'], '2HTML');
         
        $content.='<li>'.END_LINE;
        $content.=$bibliores_author.' - <span class="biblio_title">'.$bibliores_title;
        $content.=$bibliores_sub_title.'</span>'. $bibliores_editor.$bibliores_date;
        $content.='</li>'.END_LINE;
      }
      $content.='</ul>'.END_LINE;

    }
    else
    {
      $content.='<p class="info">'._t('publication','no_biblio').'</p>';
    }
    $content.='</div>'.END_LINE;
    //$content.='<hr />'.END_LINE;

    echo $content;
  }
}

if(!function_exists('DisplayPublicationMulti')) {

  function DisplayPublicationMulti($publi_id) {

    $data=SQL_GetResources($publi_id, 'P', 'MULTI', $GLOBALS['sql_object']);
    $content ='<div class="multi">'.END_LINE;
    $content.='<h2>'._t('publication','multi_res').'</h2>'.END_LINE;
    if($data!=0)
    {
      $content.='<ul>'.END_LINE;
      for($i=0; $i<count($data); $i++) {
        $multires_name=formatText($data[$i]['multires_name'], '2HTML');
        $multires_description=formatText($data[$i]['multires_description'], '2HTML');
        if($data[$i]['multires_media_uri'][0]=='m') $multires_media_uri='../'.$data[$i]['multires_media_uri'];
        else $multires_media_uri=$data[$i]['multires_media_uri'];
         
        $content.='<li>'.END_LINE;
        $content.='<a href="'.$multires_media_uri.'" class="out">'.$multires_name.'</a><br />'.END_LINE;
        $content.='<div>'.END_LINE;
        $content.=$multires_description.END_LINE;
        $content.='</div>'.END_LINE;
        $content.='</li>'.END_LINE;
         
      }
      $content.='</ul>'.END_LINE;
    }
    else
    {
      $content.='<p class="info">'._t('publication','no_multi').'</p>';
    }
    $content.='</div>'.END_LINE;

    echo $content;
  }
}
?>