<?php
/**
 * @package linea21.utils
 * @subpackage report_sdi
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

///////////////////////////////////
// Récupération de données
///////////////////////////////////

// liste des échelles sélectionées
$scale_content='';
for($i=0; $i<count($scale_array); $i++) {
  $scale_content.=$scale_denomination_array[$scale_array[$i]].'<br />'.END_LINE;
}

// liste des indicateurs sélectionés
$sdi_content='';
for($i=0; $i<count($sdi); $i++) {
  $sdi_content.=$sdi[$i]['sdii_name'].'<br />'.END_LINE;
}
//////////////////////////////////


$pdf->AddPage();
$pdf->SetY($pdf->GetY()+20);
$pdf->SetX($pdf->GetX()+152);
$pdf->Bookmark($lang['dashboard']['rap_infopubli']);
// logo
$pdf->Image('inc_report/logo_p.png',$pdf->GetX(), $pdf->GetY(), 0, 0, 'PNG', SITE_LINEA_URL);


//////////////////////////////////
// 	tableau récapitulatif
//////////////////////////////////
$margin = 20;
$pdf->SetY($pdf->GetY()+20);
$pdf->SetFont(DOC_POLICE, ARRAY_DATA_STYLE, ARRAY_DATA_SIZE);

$tbl = '
<table cellspacing="0" cellpadding="5" border="1">
	<thead>
    <tr>
        <td>'.$lang['dashboard']['rap_title'].'</td>
        <td>'.formatText($report_settings['title']).'</td>
    </tr>
    </thead>
    <tr>
        <td>'.$lang['divers']['date_crea'].'</td>
        <td>'.date("d-m-Y H:i:s").'</td>
    </tr>
    <tr>
        <td>'.$lang['dashboard']['rap_author'].'</td>
        <td>'.formatText($report_settings['author']).'</td>
    </tr> 
    <tr>
        <td>'.$lang['dashboard']['rap_mail_author'].'</td>
        <td>'.formatText($report_settings['mail_author']).'</td>
    </tr> 
    <tr>
        <td>'.$lang['dashboard']['rap_service'].'</td>
        <td>'.formatText($report_settings['service_author']).'</td>
    </tr> 
    <tr>
        <td>'.$lang['dashboard']['rap_adress'].'</td>
        <td>'.formatText($report_settings['adress_author']).'</td>
    </tr>
    <tr>
        <td>'.$lang['dashboard']['rap_indicators'].'</td>
        <td>'.$sdi_content.'</td>
    </tr> 
    <tr>
        <td>'.$lang['dashboard']['rap_scale'].'</td>
        <td>'.$scale_content.'</td>
    </tr>
    <tr>
        <td>'.$lang['dashboard']['rap_generated'].' ('.$lang['divers']['seconds'].')'.'</td>
        <td>'.$total_time.'</td>
    </tr> 
</table>';

$pdf->writeHTML($tbl, true, false, false, false, '');

$pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
?>