<?php
/**
 * @package linea21.modules
 * @subpackage sdi
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if(!isset($_GET['id']) && !isset($_POST['id'])) {
  $id="1";
} else {
  if(isset($_POST['id']))	$id=$_POST['id'];
  if(isset($_GET['id']))	$id=$_GET['id'];
}

$sdi_object= new sdi;



$req_sdii=SQL_getInfoSdi($id);
$result_sdii = $sql_object -> DBSelect($req_sdii);

$req_sdir=SQL_getRules( $id, $sql_object, $ID=-1);
$result_r = $sql_object -> DBSelect($req_sdir);

$req_sdie=SQL_getEvaluation( $id, $sql_object, $ID=-1);
$result_e = $sql_object -> DBSelect($req_sdie);

$req_sdip=SQL_getProvider( $id, $sql_object, $ID=-1);
$result_p = $sql_object -> DBSelect($req_sdip);


$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_det_theme="index.php?rub=theme&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_mod_e=$rub_link."&amp;todo=mod_e&amp;id=";
$link_mod_r=$rub_link."&amp;todo=mod_r&amp;id=";
$link_mod_p=$rub_link."&amp;todo=mod_p&amp;id=";
$navtitle=_t('sdi','det')." : ".$result_sdii[0]['sdii_name'];

if ($result_sdii[0]['sdii_to_dashboard']=='Y') $display_attached_to_dashboard = _t('divers','yes');
else $display_attached_to_dashboard = _t('divers','no');
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','sdi')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle);?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2($result_sdii[0]['sdii_name']);?></h2>

<?php echo "<a href=\"".$link_sup.$id."\" title=\""._t('sdi','sup')."\" class=\"ico_sup2\">";?></a>
<?php echo "<a href=\"".$link_mod.$id."\" title=\""._t('sdi','mod')."\" class=\"ico_mod2\">";?></a>

<dl class="dl2">
	<dt><?php echo mb_ucfirst(_t('sdi','theme')) ?> :</dt>
	<dd><?php echo "<a href=\"".$link_det_theme.$result_sdii[0]['sdii_theme']."\" title=\"".formatText($result_sdii[0]['theme_name'], '2HTML')."\">".formatText($result_sdii[0]['theme_name'], '2HTML')."</a></dd>"; ?>
	<dt><?php echo mb_ucfirst(_t('sdi','name2')) ?> :</dt>
	<dd><?php echo formatText(mb_ucfirst($result_sdii[0]['sdii_name']), '2HTML');?></dd>
	<?php /*
	<dt><?php echo mb_ucfirst(_t('sdi','type')) ?> : </dt>
	<dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_type'][$result_sdii[0]['sdii_type']]), '2HTML');?></dd>
	*/ ?>
	<dt><?php echo mb_ucfirst(_t('sdi','dashboard_viz')) ?> : </dt>
	<dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_dashboard_viz'][$result_sdii[0]['sdii_dashboard_viz']]), '2HTML');?></dd>
	<?php /*
	<dt><?php echo mb_ucfirst(_t('sdi','detail_viz')) ?> : </dt>
	<dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_detail_viz'][$result_sdii[0]['sdii_detail_viz']]), '2HTML');?></dd>
	*/ ?>
	<?php /*
	<dt><?php echo mb_ucfirst(_t('sdi','range')) ?> : </dt>
	<dd><?php echo formatText($result_sdii[0]['sdii_range'], '2HTML');?></dd> 
	*/ ?>
	<dt><?php echo mb_ucfirst(_t('sdi','description')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_sdii[0]['sdii_description'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','goal')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_sdii[0]['sdii_goal'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','consulting')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_sdii[0]['sdii_consulting'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','attached_to_dashboard')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($display_attached_to_dashboard, '2HTML'));?></dd>
	
	<dt><?php echo mb_ucfirst(_t('sdi','threshold_relative')) ?> :</dt>
	<dd>
	<?php 
	if ($result_sdii[0]['sdii_threshold_relative']=='Y') echo _t('sdi','threshold_relative_Y');
	else echo _t('sdi','threshold_relative_N');
	?>
	</dd>
	<dt><?php echo mb_ucfirst(_t('sdi','comment')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_sdii[0]['sdii_comment'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','statut')) ?> :</dt>
	<dd><?php echo display_statut($result_sdii[0]['sdii_statut']);?></dd>

</dl>
<br class="brendstep" />
<h2><?php echo _t('sdi','info_mesure'); ?></h2>

<br class="brendstep" />
<table cellspacing="0" cellpadding="3">
	<thead>
		<tr>
		<?php
		echo "<td>"._t('sdi','max_value')." (".$result_sdii[0]['sdii_unit'].")"."</td>\n";
		echo "<td>"._t('sdi','min_value')." (".$result_sdii[0]['sdii_unit'].")"."</td>\n";
		echo "<td>"._t('sdi','initial_threshold_value')." (".$result_sdii[0]['sdii_unit'].")"."</td>\n";
		echo "<td>"._t('sdi','frequency')."</td>\n";
		?>
		</tr>
	</thead>
	<tbody>
	<?php echo "<tr>\n";
	echo "<td>". empty_nc($result_sdii[0]['sdii_max_value'])."</td>\n";
	echo "<td>". empty_nc($result_sdii[0]['sdii_min_value'])."</td>\n";
	echo "<td>". empty_nc($result_sdii[0]['sdii_threshold_value'])."</td>\n";
	echo "<td>". $result_sdii[0]['sdii_frequency']."</td>\n";
	echo "</tr>\n";
	?>
	</tbody>
</table>
<br class="brendstep" />



<div class="toggle_title">
	<a id="affprovider" href="#" title="<?php echo _t('sdi','aff_sdi_p');?>"><?php echo _t('sdi','aff_sdi_p');?></a>
</div>
<div id="provider" style="display: none;"><?php if ($result_p[0]['sdip_name']=="") {
  echo "<h2 class=\"info\">"._t('sdi','noresultp')."</h2>"
		   ?> <?php echo "<a href=\"".$link_mod_p.$id."\" title=\""._t('sdi','modify_sdi_p')."\" class=\"ico_mod2\">";?></a>

  <?php } else { ?>
<h2><?php echo formatTitleh2($result_p[0]['sdip_name']);?></h2>

  <?php echo "<a href=\"".$link_mod_p.$id."\" title=\""._t('sdi','modify_sdi_p')."\" class=\"ico_mod2\">";?></a>

<dl class="dl2">
	<dt><?php echo mb_ucfirst(_t('sdi','p_service')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_service'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_incharge')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_incharge'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_address')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_address'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_phone')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_phone'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_fax')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_fax'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_email')) ?> :</dt>
	<dd><?php echo "<a href=\"mailto:".$result_p[0]['sdip_email']."\" title=\"".formatText($result_p[0]['sdip_email'], '2HTML')."\" >".formatText($result_p[0]['sdip_email'], '2HTML')."</a>"; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_description')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_description'], '2HTML'));?></dd>
</dl>
  <?php } ?></div>
<br class="brendstep" />


<div class="toggle_title">
	<a id="affeval" href="#"title="<?php echo _t('sdi','aff_sdi_e');?>"><?php echo _t('sdi','aff_sdi_e');?></a>
</div>
<div id="evaluation" style="display: none;"><br class="brendstep" />
  <?php echo "<a href=\"".$link_mod_e.$id."\" title=\""._t('sdi','modify_sdi_e')."\" class=\"ico_mod2\">";?></a>
<br class="brendstep" />
<table cellspacing="0" cellpadding="3">
	<thead>
		<tr>
		<?php
		echo "<td>".mb_ucfirst(_t('sdi','e_scale_compare'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_fiability'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_accessibility'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_lisibility'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_relevance'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_global_performance'))."</td>\n";
		?>
		</tr>
	</thead>
	<tbody>
	<?php echo "<tr>\n";
	echo "<td>". $result_e[0]['sdie_scale_compare']."</td>\n";
	echo "<td>". $result_e[0]['sdie_fiability']."</td>\n";
	echo "<td>". $result_e[0]['sdie_accessibility']."</td>\n";
	echo "<td>". $result_e[0]['sdie_lisibility']."</td>\n";
	echo "<td>". $result_e[0]['sdie_relevance']."</td>\n";
	echo "<td>". $result_e[0]['sdie_global_performance']."</td>\n";
	echo "</tr>\n";
	?>
	</tbody>
</table>
</div>
<br class="brendstep" />


<div class="toggle_title">
	<a href="#affreg" id="affreg" title="<?php echo _t('sdi','aff_sdi_r');?>"><?php echo mb_ucfirst(_t('sdi','aff_sdi_r'));?></a>
</div>
<div id="reglementation" style="display: none;"><?php if ($result_r[0]['sdir_title']=="") {
  echo "<h2 class=\"info\">"._t('sdi','noresultr')."</h2>"
		?> <?php echo "<a href=\"".$link_mod_r.$id."\" title=\""._t('sdi','modify_sdi_r')."\" class=\"ico_mod2\">";?></a>

  <?php } else { ?>

<h2><?php echo empty_nc(formatTitleh2($result_r[0]['sdir_title']));?></h2>

<?php echo "<a href=\"".$link_mod_r.$id."\" title=\""._t('sdi','modify_sdi_r')."\" class=\"ico_mod2\">";?></a>

<dl class="dl2">
	<dt><?php echo mb_ucfirst(_t('sdi','r_referer_uri')) ?> :</dt>
	<?php
	if ($result_r[0]['sdir_referer_uri']<>"") echo "<dd><a href=\"".formatText($result_r[0]['sdir_referer_uri'], '2HTML')."\" title=\"".empty_nc(formatText($result_r[0]['sdir_mask_uri'], '2ATT'))."\" >".empty_nc(formatText($result_r[0]['sdir_mask_uri'], '2HTML'))."</a></dd>";

	else echo "<dd>".empty_nc(formatText($result_r[0]['sdir_mask_uri'], '2HTML'))."</dd>";
	?>
</dl>

<div class="brendstep">
<?php echo empty_nc(formatText($result_r[0]['sdir_body'], '2HTML')); ?>
</div>
	<?php } ?> <br class="brendstep" />
</div>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>