<?php
/**
 * @package linea21.core
 * @subpackage system
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once ("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

include_once('../lib/input_helpers.php');

// @todo handle files to exclude from theme.xml

if (isset($_REQUEST['file']) && !empty($_REQUEST['file'])) {
  $file = $_REQUEST['file'];
  $file_path = THEME_PUBLIC_PATH. $file;
} else {
  $file = 'index.php';
  $file_path = THEME_PUBLIC_PATH. $file;
}

$edit_link=$rub_link."&amp;todo=edit_files&amp;file=";
$link_confirm="confirm.php?rub=".$rub."&todo=".$todo.'&file='.$file;

if(isset($_POST['save'])) {
  if (get_magic_quotes_gpc()) {
    $savecontent = stripslashes($_POST['file_content']);
  }
  else {
    $savecontent = $_POST['file_content'];
  }

  if(!is_writable($file_path)) {
    $user_msg = array('class' => 'error', 'msg' => _t('sys_theme', 'not_writable'));
  } else {
    $r = file_put_contents($file_path, $savecontent, LOCK_EX);

    if(is_numeric($r)) header("Location: ".$link_confirm);
    else  system_error();
  }
}

// we get current file content for edit
$content = '';
if(file_exists($file_path) && is_readable($file_path)) {
  $content = file_get_contents($file_path);
} else {
  $user_msg = array('class' => 'error', 'msg' => _t('sys_theme', 'not_accessible'));
}
if(!is_writable($file_path)) {
  $user_msg = array('class' => 'error', 'msg' => _t('sys_theme', 'not_writable'));
}

// we get all editables files
$editables = GetAllFiles(THEME_PUBLIC_PATH,array('php', 'css', 'js', 'txt'), true);
// and populate the container
$edit_files = '<ul>';
foreach ($editables as &$item) {
	$shortname = str_replace(THEME_PUBLIC_PATH.'/', '', $item);
	if($shortname == $file) {
	  $class="active";
	} else {
	  $class='';
	}
	$edit_files .= '<li><a href="'.$edit_link. $shortname.'" title="'. _t('sys_theme', 'edit_file').' : ' .$shortname.'" class="'.$class.'">'. $shortname. "</a></li>";
}
$edit_files .= '</ul>';

?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','system')?></a></li>
	<li><span><?php echo _t('sys_theme','theme_editor') ?></span></li>
</ul>
</div>

<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer">
<?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));?>
<div id="content">
<h2><?php echo _t('sys_theme','theme_editor'); ?></h2>
<h3><?php echo _t('sys_theme','current_file'). ' : ' .$file; ?></h3>
<?php
// we display user message if needed
if(isset($user_msg)) {
  echo '<p class="'.$user_msg['class'].'">'.$user_msg['msg'].'</p>';
}
?>
<div id="filelinks">
  <h3><?php echo _t('sys_theme','files'); ?> : </h3>
  <?php echo $edit_files; ?>
</div>
<form id="edit_file" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <textarea id="file_content" name="file_content" cols="90" rows="35"><?php echo $content; ?></textarea>
  <div>
    <input name="file" type="hidden" value="<?php echo $file; ?>" id="file" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" /> 
    <?php echo cancel_button('?rub=system&amp;todo=list'); ?>
    <input name="save" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="save" />
  </div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>