<?php
/**
 * @package linea21.core
 * @subpackage user
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////


$req_quickbox_add = "SELECT user_id, user_login, profile_firstname, profile_lastname, DATE_FORMAT(user_last_modify, '".toStringSqlDate('long')."') AS user_last_modify_display, DATE_FORMAT(user_date_crea, '".toStringSqlDate()."') AS user_date_crea_display FROM " . T_USER . " LEFT OUTER JOIN ".T_PROFILE." ON user_profile=profile_id  WHERE user_validity <> 'N' ORDER BY user_date_crea DESC, user_login ASC LIMIT 0 , 10;";
$req_quickbox_list = "SELECT user_id, user_login, profile_firstname, profile_lastname, DATE_FORMAT(user_last_modify, '".toStringSqlDate('long')."') AS user_last_modify_display, DATE_FORMAT(user_date_crea, '".toStringSqlDate()."') AS user_date_crea_display FROM " . T_USER . " LEFT OUTER JOIN ".T_PROFILE." ON user_profile=profile_id  WHERE user_validity <> 'N' ORDER BY user_last_modify DESC, user_login ASC LIMIT 0 , 10;";
$req_quickbox_sup = "SELECT user_id, user_login, profile_firstname, profile_lastname, DATE_FORMAT(user_last_modify, '".toStringSqlDate('long')."') AS user_last_modify_display, DATE_FORMAT(user_date_crea, '".toStringSqlDate()."') AS user_date_crea_display FROM " . T_USER . " LEFT OUTER JOIN ".T_PROFILE." ON user_profile=profile_id  WHERE user_validity = 'N' ORDER BY user_last_modify DESC, user_login ASC LIMIT 0 , 10;";

$req_list_group="SELECT catus_id, catus_name FROM " . T_CAT_USER . ";";
$req_alphabetical="SELECT DISTINCT UPPER(LEFT( user_login, 1)) AS first_letter FROM ". T_USER." WHERE user_validity<>'N' ORDER BY first_letter ASC;";
$req_nb_inscrit="SELECT COUNT(user_id) AS nb_inscrit FROM ". T_USER." WHERE user_validity<>'N'";

function SQL_getUserLogin($user_id) {
  $q="SELECT user_login FROM ". T_USER." WHERE user_validity<>'N' AND user_id='".$user_id."'";
  return $q;
}

function SQL_getAllUserInfo($user_id) {
  $q="SELECT U.user_login, U.user_validity, U.user_category, R.*, P.*, DATE_FORMAT(profile_birthdate, '".toStringSqlDate()."') AS profile_birthdate, DATE_FORMAT(profile_last_modify, '".toStringSqlDate('long')."') AS profile_last_modify_display, DATE_FORMAT(user_last_con, '".toStringSqlDate('long')."') AS user_last_con_display, DATE_FORMAT(profile_date_crea, '".toStringSqlDate()."') AS profile_date_crea_display, C.catus_id, C.catus_name FROM ". T_USER." AS U LEFT OUTER JOIN ".T_RIGHT." AS R on R.rights_id=U.user_rights LEFT OUTER JOIN ".T_PROFILE." AS P on P.profile_id=U.user_profile LEFT OUTER JOIN ".T_CAT_USER." AS C on C.catus_id=U.user_category WHERE user_validity <> 'N' AND user_id='".$user_id."'";
  return $q;
}

function SQL_getlistuser($debut, $limite = SELECT_LIMIT, $filter='', $search='' ) {
  if($search!='') {
    switch ($filter) {
      case 'ALPHA':
        $mask=" AND lower(user_login) LIKE lower('\\".$search."%') ";
        break;
      case 'GROUP':
        $mask=" AND user_category='".$search."' ";
        break;
      default:
        $mask='';
        break;
    }
  } else $mask='';
  $q= "SELECT U.user_login, U.user_id, P.profile_firstname, P.profile_lastname, DATE_FORMAT(user_date_crea, '".toStringSqlDate()."') AS user_date_crea_display, C.catus_name FROM " . T_USER . " AS U LEFT OUTER JOIN ".T_CAT_USER." AS C ON U.user_category=C.catus_id LEFT OUTER JOIN ".T_PROFILE." AS P ON U.user_profile=P.profile_id WHERE user_validity<>'N'".$mask." ORDER BY user_date_crea DESC, user_login ASC LIMIT ".$debut." , ".$limite.";";
  return $q;
}

function SQLCount_getlistuser($filter='', $search='' ) {

  if($search!='') {
    switch ($filter) {
      case 'ALPHA':
        $mask=" AND lower(user_login) LIKE lower('\\".$search."%') ";
        break;
      case 'GROUP':
        $mask=" AND user_category='".$search."' ";
        break;
      default:
        $mask='';
        break;
    }
  } else $mask='';
  $q= "SELECT COUNT(user_login) AS num_rows FROM " . T_USER . " WHERE user_validity<>'N'".$mask.";";
  return $q;
}

function SQL_Get_WorkshopsDenomination($array) {

  $str='';
  $sep='';
  foreach($array as $v) {
    $str .= $sep. 'workshop_id='.$v;
    $sep = ' OR ';
  }
  $query = "SELECT workshop_denomination, workshop_id FROM ". T_WORK ." WHERE (". $str .") AND workshop_statut <> 'E' ORDER BY workshop_id DESC";

  return $query;
}

function SQL_getWorkgroupsList() {
  $q = "SELECT workshop_id as id, workshop_denomination as name FROM ". T_WORK ." WHERE workshop_statut = 'P' OR workshop_statut = 'D';";
  return $q;
}

function SQL_getUserWorkgroups($id) {
	$q = 	"SELECT workshop_id as id, workshop_denomination as name FROM ". J_WORK_USERS .
	        " LEFT OUTER JOIN " . T_WORK . " ON jwu_workshop_id = workshop_id " .
			" WHERE jwu_user_id = '".$id."' AND workshop_statut='P' ORDER BY workshop_range ASC, workshop_denomination ASC;";
	
	return $q;
}

function SQL_getUserNotifyExceptionsSettings($id) {
  $q = 	"SELECT CONCAT_WS('-',type,workshop_id) as exception FROM ". T_WORK_NOTIFY .	" WHERE user_id = '".$id."';";
  
  return $q;
}
?>