<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
session_start();

include_once('../config/define.php');

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
////////////

include_once('../workshop/'.SQL.'.inc.php');

if(isset($_GET['groupmembers'])) $data=$sql_object->DBSelect(SQL_getWorkgroupUsersList($_GET['groupmembers']));
if($_GET['type']=='O') $data=$sql_object->DBSelect(SQL_getOrganizersList());
if($_GET['type']=='U') $data=$sql_object->DBSelect(SQL_getAllUsersList());

$response = array();

foreach ($data as $i => $user)
{
  $fullname = '';
  if(!empty($user['profile_firstname']) || $user['profile_lastname']) {
  	$fullname = ' - '. $user['profile_firstname'].' '.$user['profile_lastname'];
  }
  $str_id = $user['user_login'];
  $html_str = $user['user_login'] . $fullname . ' ('.$user['profile_email'].')';
  $response[] = array($str_id, $html_str, null, $html_str);
}

header('Content-type: application/json');
echo json_encode($response);