<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once("../lib/input_helpers.php");
if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

if(isset($_POST['com_id']))	$com_id=$_POST['com_id'];
if(isset($_GET['com_id']))	$com_id=$_GET['com_id'];

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin())
ReloadIndex('admin');
////////////


$user_id=$l21auth->GetSessionElement('id');

$form_subject='';
$form_owner='';
$form_body='';
$mask_owner='';
$mask_notify='';
$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_add_com=$rub_link."&amp;todo=add_com&amp;id=".$id."&amp;com_id=";
if($com_id <> 0) $link_cancel=$rub_link."&amp;todo=det_com&amp;id=".$id."&amp;com_id=".$com_id;
else $link_cancel=$rub_link."&amp;todo=list_com&amp;id=".$id;



$req_det_workshop= SQL_getoneCompleteWorkshop($id);
$result_workshop=$sql_object->DBSelect($req_det_workshop);
$workshop_denomination=formatText($result_workshop[0]['workshop_denomination'], '2HTML');

$req_com_root = SQL_getOnetopicWorkcom($id, $com_id, $com_id);
$result_com_root = $sql_object -> DBSelect($req_com_root);
$com_root_subject=formatText($result_com_root[0]['workcom_subject'], '2HTML');
$workshop_com_object= new workshop_com;
if(!empty($com_root_subject)) $form_subject=$com_root_subject;

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
//   print_r($data_table);
//   $b = array('id' => $result,'user' => $_SESSION['userlogin'],'owner' => $data_table[6], 'action' => 'topic_alert', 'topic_subject' => $data_table[0], 'topic_body' => $data_table[1]);
//   echo "<br /><br /><br /><br />";
//   print_r($data_table);
//   echo "<br /><br /><br /><br />";
//   print_r($b);
//   exit;
  //faire l'ajout de user avec AddUserWorkshop
  $result=$workshop_com_object->AddCom($data_table , $sql_object);
  if($com_id == 0) $com_id=$result;
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id."&com_id=".$com_id."&mes_id=".$result;
  if(is_numeric($result)) {
  	// we notify users if needed
  	if($data_table[5]===true) {
  		// new topic
  		if($data_table[2] == 0) {
  			notifyUsersMsg(array('id' => $id,'user' => $_SESSION['userlogin'],'owner' => $data_table[6], 'action' => 'topic_alert', 'topic_subject' => $data_table[0], 'topic_body' => $data_table[1]));
  		// new post in existing topic
  		} else {
  			notifyUsersMsg(array('id' => $result,'user' => $_SESSION['userlogin'],'owner' => $data_table[6], 'action' => 'post_alert', 'topic_subject' => $data_table[0], 'topic_body' => $data_table[1], 'tid' => $data_table[2], 'parentid' => $id));
  		}
  	}
  	header("Location: ".$link_confirm);
  }
  else  system_error();
}

if(isset($_POST['valider'])) {

  $table[0] = $_POST['subject'];
  $table[1] = $_POST['body'];
  $table[2] = $_POST['com_id'];
  if(isset($_POST['change-owner'])) {
  	$r=$sql_object -> DBSelect(SQL_get_UserInfo($_POST['owner']));
  	$table[3] = $r[0]['user_id'];
  	$mask_owner =' checked="checked"';
  	$table[6] = $_POST['owner'];
  } else {
 		$table[3] = $user_id;
 		$mask_owner = '';
 		$table[6] = $_SESSION['userlogin'];
  }
  $table[4] = $_POST['id'];
  
  if(isset($_POST['notify-users'])) {
  	$mask_notify=' checked="checked"';
  	$table[5] = true;
  	$notifyusers_display = _t('divers', 'yes');
  } else {
  	$mask_notify='';
  	$table[5] = false;
  	$notifyusers_display = _t('divers', 'no');
  }

  $integrity=$workshop_com_object->CheckDataIntegrity($table, $sql_object);

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }

  $form_subject=formatText($_POST['subject'], $text_format);
  if(isset($_POST['change-owner'])) {
  	$form_owner=formatText($_POST['owner'], $text_format);
  } else {
  	$form_owner=formatText($_SESSION['userlogin']);
  }
  $form_body=formatText($_POST['body'], $text_format);
  $table=urlencode(serialize($table));
}
include_once(THEME_ADMIN_PATH."quickicons.php");
if ($com_id==0) {
  $navtitle=_t('workshop','add_com')." : ".$workshop_denomination;
  $titleh2=_t('workshop','name')." : ".$workshop_denomination;
}
else {
  $navtitle=_t('workshop','add_com_mes')." : ".$com_root_subject." (".$workshop_denomination.")";
  $titleh2=_t('workshop','com_name')." : ".$com_root_subject." ("._t('workshop','name')." :".$workshop_denomination.")";
}?>
<script type="text/javascript">
    $(document).ready( function()
    {
      if(!$("#change-owner").is(':checked')) $("#owner-container").hide();
    	
    	$("#change-owner").click(
				function( objEvent ){
					var todo = this.checked;
					if(todo == true ) {
						$("#owner-container").fadeIn("slow");
						
					} else {
						$("#owner-container").fadeOut("slow");
					}
				}
				);
		
    	// Autocomplete initialization
		var t = new $.TextboxList('#owner', {unique: true, max:1, plugins: {autocomplete: {onlyFromValues: true, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
					
		$.ajax({url: '../workshop/_ajax_user_autocomplete.php?groupmembers=<?php echo $id; ?>', dataType: 'json', success: function(r){
			t.plugins['autocomplete'].setValues(r);
		}});
    });
</script>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php  echo formatnavTitle($navtitle);?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
if(!isset($integrity) || is_string($integrity)) {
	?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?> 
<?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo formatTitleh2($titleh2); ?></h2>
<form id="addcom" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
	<label for="change-owner"><?php echo mb_ucfirst(_t('workshop','com_change_owner')); ?> : </label>
	<input type="checkbox" name="change-owner" id="change-owner" value=""<?php echo $mask_owner; ?> />
</p>
<p id="owner-container">
	<label for="owner"><?php echo mb_ucfirst(_t('workshop','com_owner')); ?> : * </label>
	<input name="owner" type="text" class="textfield" id="owner" maxlength="150" value="<?php echo $form_owner; ?>" />
</p>
<p>
	<label for="subject"><?php echo mb_ucfirst(_t('workshop','com_subject')); ?> : *</label>
	<input name="subject" type="text" class="textfield" id="subject" maxlength="150" value="<?php echo $form_subject; ?>" />
</p>
<p>
	<label for="body"><?php echo mb_ucfirst(_t('workshop','com_body')); ?> : *</label>
	<textarea id="body" name="body" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_body; ?></textarea>
</p>
<p>
	<label for="notify-users"><?php echo mb_ucfirst(_t('workshop','com_notify')); ?> : </label>
	<input type="checkbox" name="notify-users" id="notify-users" value=""<?php echo $mask_notify; ?> />
</p>
<div>
	<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
	<input name="com_id" type="hidden" value="<?php echo $com_id; ?>" id="com_id" /> <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" /> <?php echo cancel_button($link_cancel); ?>
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
// Récapitulatif
} else	{
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('recap','title') ?></h2>

<?php
echo "<dl class=\"dl3\">\n";
// we display user login only if we change it
if(isset($_POST['change-owner'])) {
	echo "<dt>".mb_ucfirst(_t('workshop','com_owner'))." : </dt>\n";
	echo "<dd>".$form_owner."</dd>\n";
}
echo "<dt>".mb_ucfirst(_t('workshop','com_subject'))." : </dt>\n";
echo "<dd>".$form_subject."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','com_body')) ." : </dt>\n";
echo "<dd>".$form_body."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','com_notify')) ." : </dt>\n";
echo "<dd>".$notifyusers_display."</dd>\n";
echo "</dl>\n";
?>
<form id="addworkshop" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<div>
	<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
	<input name="com_id" type="hidden" value="<?php echo $com_id; ?>"id="com_id" />
	<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<?php echo cancel_button($link_cancel); ?>
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
	<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
</div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
	}
	?>