<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop') && !$l21auth->isSuperAdmin())
	ReloadIndex('admin');
////////////

if(!isset($_GET['statut']) || $_GET['statut']==-1) $statut=-1;
elseif($_GET['statut']!=-1) $statut=$_GET['statut'];

if (isset($_POST['id'])) $id = $_POST['id'];
if (isset($_GET['id'])) $id = $_GET['id'];

$req_det = SQL_getoneCompleteWorkshop($id);
$result = $sql_object -> DBSelect($req_det);
$workshop_denomination = formatText($result[0]['workshop_denomination'], '2HTML');

if(!isset($_GET['debut'])) $debut=0;
else $debut=$_GET['debut'];

// Nombre d'enregistrement total dans la bdd
$req_count_com = SQL_getcountnbcom($id);
$result_nb_com=$sql_object->DBSelect($req_count_com);
$bdd_nb_com=$result_nb_com[0]['num_rows'];
$bdd_nb_com_display = $bdd_nb_com." "._t('workshop','nb_total_com')."<br />\n";

$link_back='';
$count_request=$bdd_nb_com;
$req_list_workcom=SQL_getWorkcomList($debut, SELECT_LIMIT, $id);
$result_workcom_list=$sql_object->DBSelect($req_list_workcom);

if($count_request<=1) $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','record')."<br />\n";
else $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','records')."<br />\n";


$link_sup_com=$rub_link."&amp;todo=sup_com&amp;id=".$id."&amp;com_id=";
$link_mod_com=$rub_link."&amp;todo=mod_com&amp;id=".$id."&amp;com_id=";
$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_det_user="index.php?rub=user&amp;todo=det&amp;id=";
$link_statut=$rub_link."&amp;todo=list&amp;statut=";
$link_add_com=$rub_link."&amp;todo=add_com&amp;id=".$id."&amp;com_id=";
$link_list_com=$rub_link."&amp;todo=list_com&amp;id=".$id;
$link_self=$link_list_com;
$link_det_com=$rub_link."&amp;todo=det_com&amp;id=".$id."&amp;com_id=";
$navtitle=_t('workshop','list_com')." : ".$workshop_denomination;
$titleh2=_t('workshop','name')." : ".$workshop_denomination;
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">
<?php afflinkbar($todo,$id, $lang); ?> 
<?php
echo "<h2>" . formatTitleh2($titleh2). "</h2>\n";
?> 
<?php
echo $link_back;
?>
<p><?php
echo $bdd_nb_com_display;
echo $count_request_display;
if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin())
echo "<a href=\"" . $link_add_com."0\" title=\"" . _t('workshop','add_com') . "\" class=\"ico_add2\" style=\"margin-right:20px;\"></a>";
?></p>
<?php
echo linkin_page($link_self, $count_request, $debut);

if($result_workcom_list!=0) {
  echo "<table cellspacing=\"0\" cellpadding=\"3\" class=\"table2\">\n";
  echo "<thead>\n";
  echo "<tr>\n";
  echo "<td>".mb_ucfirst(_t('workshop','com_statut'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('workshop','com_subject'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('workshop','com_author'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('workshop','com_nb_rep'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('workshop','com_date_last'))."</td>\n";
  echo "<td><span class=\"semnone\">".mb_ucfirst(_t('divers','actions'))."</span></td>\n";
  echo "</tr>\n";
  echo "</thead>\n";
  echo "<tbody>\n";


  for($i=0; $i<count($result_workcom_list); $i++) {

    $req_workcom_det=SQL_getWorkcom_detList($result_workcom_list[$i]['workcom_id']);
    $result_workcom_det=$sql_object->DBSelect($req_workcom_det);

    $workcom_title=formatText(cutText($result_workcom_list[$i]['workcom_subject'], 90, 1), '2HTML');
    $workcom_user=formatText(cutText($result_workcom_list[$i]['user_login'], 10, 1), '2HTML');

    echo "<tr>\n";
    if ($result_workcom_list[$i]['workcom_statut']=='C') {
      echo "<td><img src=\"" .THEME_ADMIN_PATH. "images/ico_lock.gif\" alt=\"".$result_workcom_list[$i]['workcom_statut']."\" class=\"iconetodo\" /></td>\n";
    }
    else echo "<td width=\"5%\">&nbsp;</td>\n";
    echo "<td width=\"50%\"><a href=\"".$link_det_com.$result_workcom_list[$i]['workcom_id']."\" title=\""._t('workshop','com')."\">".$workcom_title."</a></td>\n";
    if ($l21auth->isSuperAdmin())
    echo "<td width=\"15%\"><a href=\"".$link_det_user.$result_workcom_list[$i]['workcom_user_id']."\" title=\""._t('workshop','com_author')."\">".$workcom_user."</a></td>\n";
    else 	echo "<td width=\"15%\"><span>".$workcom_user."</span></td>\n";
    if ($result_workcom_det[0]['nb_rep']=="") {
      echo "<td width=\"5%\"><span class=\"date_table\">0</span></td>\n";
    }
    else echo "<td width=\"5%\"><span class=\"nb_rep_table\">".$result_workcom_det[0]['nb_rep']."</span></td>\n";
    if ($result_workcom_det[0]['workcom_date_crea_display']=="") {
      echo "<td width=\"15%\"><span class=\"date_table\">".$result_workcom_list[$i]['workcom_date_crea_display']."</span></td>\n";
    }
    else echo "<td width=\"15%\"><span class=\"date_table\">".$result_workcom_det[0]['workcom_date_crea_display']."</span></td>\n";

    if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin()){
      echo "<td width=\"15%\"><div class=\"iconetab\"><a href=\"".$link_sup_com.$result_workcom_list [$i]['workcom_id']."&amp;mes_id=".$result_workcom_list [$i]['workcom_id']."\" title=\""._t('workshop','sup_com')."\" class=\"ico_sup\"></a>\n";
      echo "<a href=\"".$link_mod_com.$result_workcom_list [$i]['workcom_id']."&amp;mes_id=".$result_workcom_list [$i]['workcom_id']."\" title=\""._t('workshop','mod_com')."\" class=\"ico_mod\"></a></div></td>";
    }
    else echo "<td width=\"15%\">&nbsp;</td>\n";
    echo "</tr>\n";
  }

  echo "</tbody>";
  echo "</table>";
} else {
  echo "<div class=\"info\">"._t('workshop','no_com')."</div>";
}
echo linkin_page($link_self, $count_request, $debut);

?></div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>