<?php
/**
 * @package linea21.modules
 * @subpackage comment
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
	include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////


if(isset($_GET['statut']) && $_GET['statut'] != -1) {
  $status=$_GET['statut'];
  $status_q=array($_GET['statut']);
} else {
  $status = -1;
  $status_q = array('P', 'D', 'E');
}

if(isset($_GET['module']) ) {
  $module=$_GET['module'];
} else {
  $module= 'all';
}

if(!isset($_GET['debut'])) $debut=0;
else $debut=$_GET['debut'];

$mask_statut_1='';
$mask_statut_2='';
$mask_statut_3='';
$mask_statut_4='';
$mask_statut_5='';
$mask_statut_6='';
$mask_statut_7='';

if($status=='public') $mask_statut_1='selected="selected"';
if($status=='draft') $mask_statut_2='selected="selected"';


// Nombre d'enregistrement total dans la bdd
$r = $sql_object->DBSelect(SQL_getTotalCountNumber());
$nb=$r[0]['nb'];
$nb_comments = sprintf(_t('comment','nb_total'), $nb);

$comm = new comment();

if($module=='all') {
  // tous les commentaires sont retournés !!!
  // et la pagination est effectuée ici via array_slice()
  // @todo Optimiser
  $data = $comm->getAllByModule($status_q, $sql_object, false, 'date');
  (count($data) == 1 && $data == 0) ?  $nb_q_comments = 0 : $nb_q_comments = count($data);
  $data = array_slice($data, $debut, SELECT_LIMIT);
  $html_comments = getMarkup($data, true);
} else {
  $data = $comm->getByModule(array('module' => $module, 'status' => $status_q, 'limit' => false), $sql_object);
  (count($data) == 1 && $data == 0) ?  $nb_q_comments = 0 : $nb_q_comments = count($data);
  $data = array_slice($data, $debut, SELECT_LIMIT);
  $html_comments = getMarkup($data, true);
}

echo getAjaxFunction(); // for ajax call

if($module != 'all' || $status != -1) {
  $link_back="<div class=\"filter\"><a href=\"".$rub_link."&amp;todo=list\">"._t('comment','all')."</a></div>";
} else {
  $link_back='';
}



if($nb_q_comments<=1) $query_count = _t('divers','query_result')." : ".$nb_q_comments." "._t('divers','record')."<br />\n";
else $query_count = _t('divers','query_result')." : ".$nb_q_comments." "._t('divers','records')."<br />\n";

$link_status=$rub_link."&amp;todo=list&amp;module=".$module."&amp;statut=";
$link_module=$rub_link."&amp;todo=list&amp;statut=".$status."&amp;module=";
$link_self=$rub_link."&amp;todo=list&amp;statut=".$status."&amp;module=".$module;

// Liste des modules disponibles
if($module=='news') $mask_statut_1 = 'selected="selected"';
if($module=='project') $mask_statut_2 = 'selected="selected"';
if($module=='publication') $mask_statut_3 = 'selected="selected"';
if($module=='report') $mask_statut_4 = 'selected="selected"';
if($module=='indicator') $mask_statut_5 = 'selected="selected"';
if($module=='files') $mask_statut_6 = 'selected="selected"';
if($module=='contribute') $mask_statut_7 = 'selected="selected"';
$select_module="<select name=\"statut_filter\" id=\"statut_filter\"  onchange=\"ChangeLocation(this)\">\n";
$select_module.="<option value=\"-1\">"._t('comment','module_filter')."</option>\n";
$select_module.="<option value=\"".$link_module."news\"".$mask_statut_1."> -- ".ucfirst(_t('comment_map', 'news'))."</option>\n";
$select_module.="<option value=\"".$link_module."project\"".$mask_statut_2."> -- ".ucfirst(_t('comment_map', 'project'))."</option>\n";
$select_module.="<option value=\"".$link_module."publication\"".$mask_statut_3."> -- ".ucfirst(_t('comment_map', 'publication'))."</option>\n";
$select_module.="<option value=\"".$link_module."report\"".$mask_statut_4."> -- ".ucfirst(_t('comment_map', 'report'))."</option>\n";
$select_module.="<option value=\"".$link_module."indicator\"".$mask_statut_5."> -- ".ucfirst(_t('comment_map', 'indicator'))."</option>\n";
$select_module.="<option value=\"".$link_module."files\"".$mask_statut_6."> -- ".ucfirst(_t('comment_map', 'files'))."</option>\n";
$select_module.="<option value=\"".$link_module."contribute\"".$mask_statut_7."> -- ".ucfirst(_t('comment_map', 'contribute'))."</option>\n";
$select_module.="</select>\n";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','comment'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('comment','list')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
  <div id="content">
  <div class="filter">
    	<a href="<?php echo $link_status; ?>D"><?php echo ucfirst(_t('comment', 'awaiting')); ?></a> |
    	<a href="<?php echo $link_status; ?>P"><?php echo ucfirst(_t('comment', 'all_approved')); ?></a> |
    	<a href="<?php echo $link_status; ?>E"><?php echo ucfirst(_t('comment', 'all_disapproved')); ?></a> |
    	<a href="index.php?rub=comment&amp;todo=list"><?php echo _t('comment','all'); ?></a>
    </div>
  <div class="filterselect"><?php echo $select_module; ?></div>
  <p>
    <?php
    echo $nb_comments.'<br />';
    echo $query_count;
    ?>
  </p>
  <?php
  echo linkin_page($link_self, $nb_q_comments, $debut);
  echo '<div id="comments">';
  if(!empty($html_comments)) echo $html_comments;
  else echo "<div class=\"info\">"._t('comment','noresult')."</div>";
  echo '</div>';
  echo linkin_page($link_self, $nb_q_comments, $debut);
  ?>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>