<?php
/**
 * @package linea21.core
 * @subpackage library
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
include_once('../config/define.php');

$file = str_replace('//', '/', SITE_PATH . '/' . $_REQUEST['file']);

if (file_exists($file)) {
  // default type
  $m = 'application/octet-stream';
  if(function_exists('finfo_file')) {
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $m = finfo_file($finfo, $file);
    $m = mime_content_type($file);
    finfo_close($finfo);
  } else {
    if(function_exists('mime_content_type')) $m = mime_content_type($file);
  }

  header('Content-Description: File Transfer');
  header('Content-Type: '.$m);
  header('Content-Disposition: attachment; filename='.basename($file));
  header('Content-Transfer-Encoding: binary');
  header('Expires: 0');
  header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
  header('Pragma: public');
  header('Content-Length: ' . filesize($file));
  ob_clean();
  flush();
  readfile($file);
  exit;
}
?>