<?php
/**
 * @package linea21.modules
 * @subpackage page
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../page/' . SQL . '.inc.php'));

/**
 * DisplayOnePage()
 * Affichage d'une pageen détail
 *
 * @param  $page_id
 * @return $stat Nom du statut + echo content
 */
if(!function_exists('DisplayOnePage')) {

  function DisplayOnePage($page_id)
  {
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getoneCompletePage($page_id));
    $content = '';
    if (count($data) != 1) exit;
    else {

    	$title = formatText($data[0]['page_title'], '2HTML');
    	$header = linkin_content(formatText($data[0]['page_header'], '2HTML'));
    	$body = linkin_content(formatText($data[0]['page_body'], '2HTML'));
    	$posted_on = formatText($data[0]['page_published_date_display'], '2HTML');
    	$modify_on = formatText($data[0]['page_last_modify_display'], '2HTML');
    	$posted_by = formatText($data[0]['user_login'], '2HTML');
    	$statut = $data[0]['page_status'];
    	
      $link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[0]['page_posted_by'], 'name' => $data[0]['user_login']);
      $link_self = array('rub' => $GLOBALS['links'][U_L]['page']['linkvalue'], 'id' => $page_id, 'name' => $title);
      
      

      $content .= '<h1>' . $title . '</h1>' . END_LINE;

//       $content .= '<p class="published_by">' . END_LINE;
//       $content .= _t('statut','published_on') . ' ' . $posted_on . ' ';
//       $content .= _t('divers','by').' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links'][U_L]['user-profile']['desc'] . ' (' . $posted_by . ')">' . $posted_by . '</a>';
//       $content .= formatted_permalink($link_self, ' - ');
//       $content .= '</p>' . END_LINE;

      $content .= '<div class="chapo">' . $header . '</div>' . END_LINE;
      $content .= '<div class="body">' . $body . '</div>' . END_LINE;

    }
    echo $content;
  }
}


?>