<?php
/**
 * @package linea21.modules
 * @subpackage project
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////


if (isset($_GET['id'])) $id = $_GET['id'];
if (isset($_POST['id'])) $id = $_POST['id'];

$req_det = SQL_getoneCompleteProject($id);
$result = $sql_object->DBSelect($req_det);
if ($result == 0 || count($result) != 1) exit;

// Option [1] Only  Getting Indicators list with links
// $query = SQL_getProjectSdi($id);
// $data = $sql_object->DBSelect($query);

// if($data != 0 || count($data)!=1) {
//   $sdi_list='<ul style="padding:0">';
//   foreach ($data as &$value) {
//     $sdi_list.= '<li><a href="index.php?rub=sdi&amp;todo=det&amp;id='.$value['sdii_id'].'">'.formatText($value['sdii_name'], '2HTML').'</a></li>'.END_LINE;
//   }
//   $sdi_list.='</ul>';
// } else $sdi_list=_t('divers','none');

// Option [2] Getting indicators values
include_once(override('../project/display.php'));
$sdi_list = getAssociatedIndicatorsValues($id, 10);


$project_object = new project;

$display_name = formatText($result[0]['project_name'], '2HTML');
$display_priority = formatText($result[0]['project_priority'], '2HTML');
if(!is_numeric($result[0]['project_parent_id']) || $result[0]['project_parent_id']==0) {
  $display_parent = _t('divers','none');
} else {
  $display_parent = '<a href="'.$rub_link .'&amp;todo=det&amp;id='.$result[0]['project_parent_id'].'" title="'._t('project','det').' '.formatText($result[0]['parent_name'], '2ALT').'">'.formatText($result[0]['parent_name'], '2HTML').'</a>';
}
$display_description = linkin_content(formatText(empty_none($result[0]['project_description']), '2HTML'));
$display_body = linkin_content(formatText($result[0]['project_body'], '2HTML'));

$display_theme = formatText($result[0]['theme_name'], '2HTML');
$display_workshop = formatText($result[0]['workshop_denomination'], '2HTML');
$display_scale = formatText($result[0]['scale_denomination'], '2HTML');
$display_user = formatText($result[0]['user_login'], '2HTML');
$display_begin_date = empty_nc($result[0]['project_begin_date_display']);
$display_estimated_date = empty_nc($result[0]['project_estimated_date_display']);
$display_end_date = empty_nc($result[0]['project_end_date_display']);
$display_progression = $result[0]['project_completed'];
$display_date_crea = $result[0]['project_date_crea_display'];
$display_last_modify = $result[0]['project_last_modify_display'];
$project_posted_by = $result[0]['project_posted_by'];
$project_scale_id = $result[0]['project_scale_id'];
$project_theme_id = $result[0]['project_theme_id'];
$project_workshop_id = $result[0]['project_workshop_id'];


$display_statut = display_statut($result[0]['project_statut']);
if ($result[0]['project_published_date_display'] == '01-01-0001') $display_published_date = _t('statut','draft');
else $display_published_date = $result[0]['project_published_date_display'];

$link_sup = $rub_link . "&amp;todo=sup&amp;id=";
$link_mod = $rub_link . "&amp;todo=mod&amp;id=";

?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"> <?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"> <?php echo _t('menu','project'); ?> </a></li>
	<li><span><?php echo formatNavTitle(_t('project','det') . " : " . $display_name); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");

?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

?>
<div id="content"><?php
echo "<h2>";
echo formatTitleh2($display_name);
echo "</h2>\n";
echo "\t<a href=\"" . $link_sup . $id . "\" class=\"ico_sup2\" title=\"" . _t('project','sup') . "\"></a>\n";
echo "\t<a href=\"" . $link_mod . $id . "\" class=\"ico_mod2\" title=\"" . _t('project','mod') . "\"></a>\n";

echo "<dl class=\"dl3\">\n";
echo "<dt>" . mb_ucfirst(_t('project','name')) . " :</dt>\n";
echo "<dd>" . $display_name . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','parent')) . " :</dt>\n";
echo "<dd>" . $display_parent . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','description')) . " :</dt>\n";
echo "<dd>" . $display_description . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','body')) . " :</dt>\n";
echo "<dd>" . $display_body . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','begin_date')) . " :</dt>\n";
echo "<dd>" . $display_begin_date . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','estimated_date')) . " :</dt>\n";
echo "<dd>" . $display_estimated_date . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','end_date')) . " :</dt>\n";
echo "<dd>" . $display_end_date . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','progression'))." :</dt>\n";
echo "<dd>" . getProgressbar($display_progression, 100, '%') . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','priority')) . " :</dt>\n";
echo "<dd>" . $display_priority . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','theme')) . " :</dt>\n";
if($project_theme_id != 0) {
  echo '<dd><a href="?rub=theme&amp;todo=det&amp;id='.$project_theme_id.'">' . $display_theme . '</a></dd>'.END_LINE;
} else {
  echo "<dd>" . empty_none($display_theme) . "</dd>\n";
}
echo "<dt>" . mb_ucfirst(_t('project','workshop')) . " :</dt>\n";
if($project_workshop_id != 0) {
  echo '<dd><a href="?rub=workshop&amp;todo=det&amp;id='.$project_workshop_id.'">' . $display_workshop . '</a></dd>'.END_LINE;
} else {
  echo "<dd>" . empty_none($display_workshop) . "</dd>\n";
}
echo "<dt>" . mb_ucfirst(_t('project','scale')) . " :</dt>\n";
echo '<dd><a href="?rub=scale&amp;todo=det&amp;id='.$project_scale_id.'">' . $display_scale . '</a></dd>'.END_LINE;
echo "<dt>" . mb_ucfirst(_t('project','sdi'))." :</dt>\n";
echo "<dd>" . $sdi_list."</dd>\n";
echo "<dt>" . mb_ucfirst(_t('project','author')) . " :</dt>\n";
echo '<dd><a href="?rub=user&amp;todo=det&amp;id='.$project_posted_by.'">' . $display_user . '</a></dd>'.END_LINE;
echo "<dt>" . mb_ucfirst(_t('statut','published_on')) . " :</dt>\n";
echo "<dd>" . $display_published_date . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','date_crea')) . " :</dt>\n";
echo "<dd>" . $display_date_crea . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','last_modify')) . " :</dt>\n";
echo "<dd>" . $display_last_modify . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','statut')) . " :</dt>\n";
echo "<dd>" . $display_statut . "</dd>\n";
echo "</dl>\n";

?></div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>