<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>


<?php
// set HTML Title
SetHTMLTitle('Linea21 web accessibility charter');
setBreadcrumb(array('Linea21 web accessibility charter' => false));
?>

<div id="accessibilite">
<h1>Linea21 web accessibility charter</h1>
<div class="sub-title">This website is designed
to be read by all users, independently of their handicaps, and hardware
devices.</div>


<h2>Access key</h2>
<p>Most of web-browsers allows user to open links by keys combination.
Under Windows, type alt + access-key. Under Macintosh, type ctrl +
access-key. <br />
Each page has its own <span xml:lang="en">accesskey</span> :</p>
<dl>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['accessibility']['accesskey'] ?></kbd>
	:</dt>
	<dd>accessibility charter</dd>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['home']['accesskey'] ?></kbd>
	:</dt>
	<dd>Home</dd>
	<dt xml:lang="en">Access key <kbd>2</kbd> :</dt>
	<dd>Content</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['search']['accesskey'] ?></kbd>
	:</dt>
	<dd>Search</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['news']['accesskey'] ?></kbd>
	:</dt>
	<dd>News</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['project']['accesskey'] ?></kbd>
	:</dt>
	<dd>Projects</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['directory']['accesskey'] ?></kbd>
	:</dt>
	<dd>Directory</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['workgroup']['accesskey'] ?></kbd>
	:</dt>
	<dd>Workgroups</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['publication']['accesskey'] ?></kbd>
	:</dt>
	<dd>Publications</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['dashboard']['accesskey'] ?></kbd>
	:</dt>
	<dd>Indicators dashboard</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['user-prefs']['accesskey'] ?></kbd>
	:</dt>
	<dd>User account</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['user-registration']['accesskey'] ?></kbd>
	:</dt>
	<dd>User account creation</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['logout']['accesskey'] ?></kbd>
	:</dt>
	<dd>Log-out</dd>
</dl>
<br style="clear: both;" />
<h2 style="margin-top: 1em">Web standards respectful</h2>
<ul>
	<li>Each page was validated on <abbr
		title="eXtensible HyperText Markup Language">XHTML</abbr> 1.0 Strict</li>
	<li>Each page was tested with <a
		href="http://www-3.ibm.com/able/solution_offerings/hpr.html"
		title="Information" xml:lang="en" hreflang="en">Home Page Reader 3.0
	(IBM® Accessibility Tool)</a>.</li>
	<li>Each page respects a semantic structure. H1 tags are used for main
	titles, H2 tags are used for sub-titles. For exemple, on this page, <abbr
		title="Job Access With Speech">JAWS</abbr> software users can access
	the next section by keys combination : ALT+INSERT+3</li>
</ul>


<h2>Navigation helpers</h2>
<ul>
	<li>Each page has navigation items and are related to others. <br />
	<pre>
			<code>
&lt;link rel="home" title="home" href="home" /&gt;
&lt;link rel="search" title="search" href="search" /&gt;
&lt;link rel="help" title="Linea21 accessibility charter" href="accessibility" /&gt;
			</code>
		</pre></li>
	<li>All pages include a search field (access key <kbd>4</kbd>).</li>
</ul>

<h2>Links</h2>
<ul>
	<li>Most of the links have a "title" attribute given a description of
	the current link</li>
	<li>Links are written to keep a semantic value even beyond the context.</li>
	<li>Scripts langages are used to enhance navigation confort, but they
	can be disabled without reducing accessibility of the content.</li>
</ul>

<h2>Images</h2>
<ul>
	<li>All ornamental images are <abbr title="Cascadind Style Sheet">CSS</abbr>
	included.</li>
	<li>Images as content have descriptive tag <acronym title="Alternative">Alt</acronym>.</li>
</ul>

<h2>Forms</h2>
<ul>
	<li>An effort was done to make forms accessible : the 'LABEL' tag gives
	sense to associated fields.</li>
</ul>

<h2>Graphic design</h2>
<ul>
	<li>This website uses (<abbr title="Cascadind Style Sheet">CSS</abbr>)
	style sheets for layout. Even if your browser does not support <abbr
		title="Cascadind Style Sheet">CSS</abbr>, the content is still
	readable.</li>
	<li>This website only uses drelative font sizes, compatible with the
	"text size" option of your web-browser. Use the shortcut <kbd>ctrl +
	wheel mouse</kbd> to change the font size.</li>
</ul>

<h2>Alternatives style cheets</h2>
<ul>
	<li>You can choose the style cheets you want to display the site with
	(see in the bottom of the page) :</li>
	<li>Four styles are available : black and white, minimal, classic, no
	style.</li>
</ul>

<h2>Warning - responsability</h2>
<ul>
	<li>The content published on this site is not the property of <a
		href="<?php echo SITE_LINEA_URL; ?>">Linea21</a>, we can't assure the
	warranty of a perfect data accessibility on this website.</li>
	<li>Do not hesitate to send us your critics or remarks regarding the
	website accessibility: <a href="mailto:<?php echo MAIL_LINEA; ?>"><?php echo MAIL_LINEA; ?></a></li>
</ul>

<h2>References</h2>
<ul>
	<li><a href="http://handy.univ-lyon1.fr/access/"
		title="Web Accessibility Initiative (WAI) home page">Web Accessibility
	Initiative (<abbr title="Web Accessibility Initiative">WAI</abbr> )
	home page</a>.</li>
	<li><a href="http://diveintoaccessibility.org/"
		title="a Mark Pilgrim explanation of why to build up accessible website">a
	Mark Pilgrim explanation of why to build up accessible website </a>.</li>
</ul>

<h2>Outils gratuits</h2>
<ul>
	<li><a href="http://validator.w3.org/" hreflang="en">W3C MarkUp
	Validation Service</a> : Page syntax check <abbr
		title="HyperText Markup Language ">HTML</abbr> and <abbr
		title="eXtensible HyperText Markup Language">XHTML</abbr>.</li>
	<li><a href="http://jigsaw.w3.org/css-validator/" hreflang="en">W3C CSS
	Validation service</a> : Cascading stylesheet conformity check.</li>
	<li><a href="http://bobby.watchfire.com/bobby/html/en/index.jsp"
		title="online free version of Bobby" hreflang="en">Bobby</a> :
	Accessibility Online tool based on <abbr
		title="Web Accessibility Initiative">WAI</abbr> and United States
	Government on accessibility recommandations.</li>
	<li><a href="http://www.w3.org/People/Raggett/tidy/"
		title="Clean up your Web pages with HTML TIDY" hreflang="en"><abbr
		title="HyperText Markup Language ">HTML</abbr> Tidy</a> : un outil qui
	corrige rapidement la plupart des erreurs de syntaxe sur le langage <abbr
		title="HyperText Markup Language ">HTML</abbr> et donne quelques
	conseils d'accessibilité.</li>
	<li><a href="http://www.delorie.com/web/wpbcv.html" hreflang="en">Web
	Page Backward Compatibility Viewer</a> : to ensure the compatibility of
	your website with old browsers.</li>
	<li><a href="http://lynx.isc.org/release/" title="Lynx software page"
		hreflang="en">Lynx</a> : a (dinosaur) text navigator.</li>
	<li><a href="http://artax.karlin.mff.cuni.cz/~mikulas/links/"
		title="Links softaware" hreflang="en">Links</a> : another text
	navigator, for Unix and OS/2.</li>
</ul>
</div>
