<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
if( ActiveItemKey($GLOBALS['activeitem']) =='comment-unsubscribe') {
  // set HTML Title
  SetHTMLTitle(_t('comment','unsubscribe_title'));
  setBreadcrumb(array(_t('comment','unsubscribe_title') => false));
  $a['module']= $_GET['name'];
  $a['module_id']= $_GET['id'];
  $a['email']= $_GET['email'];
  include_once('../class/class.comment.php');
  $comm = new comment;
  $r = $comm->unsubscribe($a, $GLOBALS['sql_object']);
  
  $item = $comm->getCommentItem($a, $GLOBALS['sql_object']);
  $itemM = itemMapping($a['module']);

  $full_item = $item[0]['item_title'] .' ('.$itemM['name'].')';
  
  echo '<h1>'._t('comment','unsubscribe_title').'</h1>'.END_LINE;
  if($r === true) {
    echo '<div class="confirm">'.END_LINE;
    echo $full_item . ' : ' ._t('comment','unsubscribe_successful').END_LINE;
    echo '</div>'.END_LINE;
  }

}


if( ActiveItemKey($GLOBALS['activeitem']) =='subscribe-newsletter') {
  // set HTML Title
  SetHTMLTitle(_t('newsletter','subscribe_title'));
  setBreadcrumb(array(_t('newsletter','subscribe_title') => false));
  include_once('../newsletter/subscribe.php');
  echo '<h1>'._t('newsletter','subscribe_title').'</h1>'.END_LINE;
  echo '<div class="sub-title">'.END_LINE;
  echo _t('divers','newsletter_public_comment').END_LINE;
  echo '</div>'.END_LINE;
  if(isset($msg)) {
    echo '<div class="'.$msg['code'].'">'.END_LINE;
    echo $msg['string'].END_LINE;
    echo '</div>'.END_LINE;
  }

}

if( ActiveItemKey($GLOBALS['activeitem']) =='contact') {
  // set HTML Title
  SetHTMLTitle(_t('contact','contact_us'));
  setBreadcrumb(array(_t('contact','contact_us') => false));
  include_once('../class/system/class.form.php');

  $name='';
  $email='';
  $subject='';
  $body='';

  if(isset($_POST['name'])) {
    $passed = true;
    $name=$_POST['name'];
    $email=$_POST['email'];
    $subject=$_POST['subject'];
    $body=$_POST['body'];

    if(strlen($body)< 8) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'body'));
      $class='error';
      $passed = false;
    }
    if(strlen($subject)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'subject'));
      $class='error';
      $passed = false;
    }
    if(!validEmail($email)) {
      $msg=sprintf(_t('contact','email_error'), $email);
      $class='error';
      $passed = false;
    }
    if(strlen($email)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'email'));
      $class='error';
      $passed = false;
    }
    if(strlen($name)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'name'));
      $class='error';
      $passed = false;
    }
    if($passed == true) {
      $class = 'info';
      $msg = _t('contact', 'message_sent');
      $email_recipient = SITE_MAIL;
      $email_fromname = $name;
      $email_from = $email;
      $email_subject = formatText($subject, '2HTML') . ' - '. SITE_NAME;
      $email_html_body = formatText($body, '2HTML');
      $email_text_body = strip_tags($email_html_body);
      include_once(override('../mail/template.php'));
    }
  }

  echo '<h1>'._t('contact','contact_us').'</h1>'.END_LINE;
  if(isset($passed)) echo '<div class="'.$class.'">'.$msg.'</div>'.END_LINE;

  if(!isset($passed) || $passed == false) {
    $form = new genForm;
    $form->startForm('index.php', '#contactform');
    $form->textInput('name', mb_ucfirst(_t('contact', 'name')). ' : ', 'shorttextfield', 'labelised', 'title', 100, 30, false, $name, false);
    $form->insertBR();
    $form->textInput('email', mb_ucfirst(_t('contact', 'email')). ' : ', 'shorttextfield', 'labelised', 'title', 150, 30, false, $email, false);
    $form->insertBR();
    $form->textInput('subject', mb_ucfirst(_t('contact', 'subject')). ' : ', 'shorttextfield', 'labelised', 'title', 150, 30, false, $subject, false);
    $form->insertBR();
    $form->textareaInput('body',mb_ucfirst(_t('contact', 'body')) .' : ',false,'labelised', false, $body, 60, 10);
    $form->insertBR();
    $form->submitButton(false, _t('btn', 'valid'), true, 'submitbut');
    $form->hiddenInput('rub', $_REQUEST['rub']);
    $form->closeForm();
    if(!$output = $form->getForm()) { die("error: " . $form->error); }
    else { echo $output; }
  }
}

if(ActiveItemKey($GLOBALS['activeitem']) =='css-switch') {
  include_once(override('../lib/styleswitcher.php'));
  if(isset($msg)) {
    echo '<div class="'.$msg['code'].'">';
    echo $msg['string'];
    echo '</div>';
  }
}
?>