<?php
/**
 * @package linea21.utils
 * @subpackage report_sdi
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

ob_start();
include_once('../config/define.php');
include_once('../languages/'.U_L.'/lang_common.' . CHARSET . '.php');
include_once('../languages/'.U_L.'/lang_sdi.' . CHARSET . '.php');
include_once('../languages/'.U_L.'/lang_dashboard.' . CHARSET . '.php');
include_once('phpsql.process.php');
require_once('../class/system/tcpdf/tcpdf.php');

// DO NOT REMOVE - usefull for debug !
// error_reporting(E_ALL);
// ini_set('display_errors', '1');

include_once(override('../report_sdi/pdf.report.inc.php', THEME_ADMIN_PATH));

require_once(override('../report_sdi/extendedTCPDF.php', THEME_ADMIN_PATH));

SureRemoveDir('../tmp/report', 1);

# bench start tag
$start_time=getmicrotime();

# we create the pdf
$pdf = new eTCPDF('P', 'mm', 'A4', true, 'UTF-8');

#inclusion propriétés du document
include_once(override('../report_sdi/pdf.doc_define.php', THEME_ADMIN_PATH));

#inclusion page de garde
include_once(override('../report_sdi/pdf.firstpage.php', THEME_ADMIN_PATH));

for($i=0; $i<count($sdi); $i++) {
  DisplayOneSdi($i);
}

#inclusion sommaire
if($report_settings['summary']===true) include_once(override('../report_sdi/pdf.summary.php', THEME_ADMIN_PATH));

# bench stop tag
$stop_time=getmicrotime();

$total_time=(float) $stop_time-$start_time;

#inclusion page d'infos de génération
if($report_settings['publi_infos']===true) include_once(override('../report_sdi/pdf.lastpage.php', THEME_ADMIN_PATH));

# pdf output
$pdf->Output('rapport'.date("dmY_His").'.pdf', $report_settings['file']);
ob_end_flush();

SureRemoveDir('../tmp/report', 1);
?>