<?php
/**
 * @package linea21.core
 * @subpackage search
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home');?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','search');?></a></li>
	<li><span><?php echo formatNavTitle(_t('menu_alt',$rub)) ?></span></li>
</ul>
</div>
<!--end barre haute -->

<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH)); ?>
<div id="content">
<?php
if (!isset($_POST['valid'])) {
  echo '<h2>' . _t('menu','search') . '</h2>' . END_LINE;
?>
  <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
    <div id="searchcontent">
    	<label for="search"><?php echo _t('search','keywords');?></label>
    	<input type="text" maxlength="150" class="textfield" name="search" id="search" style="margin-right: 30px" /> <br class="brendstep" />
    	<div style="margin: 3em 200px">
        	<input type="radio" name="searchtype" id="searchtype_1" value="one" checked="checked" />
        	<label for="searchtype_1" class="autowidth"><?php echo _t('search','one_of_them');?></label>
        	<input type="radio" name="searchtype" id="searchtype_2" value="all" />
        	<label for="searchtype_2" class="autowidth"><?php echo _t('search','all_of_them');?></label>
        	<input type="radio" name="searchtype" id="searchtype_3" value="exp" />
        	<label for="searchtype_3" class="autowidth"><?php echo _t('search','expression');?></label>
    	</div>
    	<input type="hidden" name="rub" id="rubsearch" value="<?php echo $rub;?>" />
    	<br class="brendstep" />
    	<input type="submit" value="<?php echo _t('search','text_button');?>" name="valid" class="button" id="validsearch" />
    </div>
   </form>
<?php
} else {
  $type = 'ADMIN';
  include_once($dir . "/display.php");
  if (!isset($_REQUEST['search']) || strlen($_REQUEST['search']) <= 3)
  {
    echo '<div class="info">'.END_LINE;
    echo _t('search','min_length');
    echo  '</div>'.END_LINE;
  } else {
    if (isset($_REQUEST['searchincome'])) $str = trim($_REQUEST['searchincome']);
    else $str = $_REQUEST['search'];
    if (!isset($_REQUEST['searchtype'])) $searchtype = 'one';
    else $searchtype = $_REQUEST['searchtype'];
    if($searchtype=='one') $display_method=_t('search','one_of_them');
    if($searchtype=='all') $display_method=_t('search','all_of_them');
    if($searchtype=='exp') $display_method=_t('search','expression');
    echo '<h2>' . _t('search','result') . '</h2>' . END_LINE;

    echo '<div id="KeyWords">'.END_LINE;
    echo _t('search','keywords');
    echo formatText($str, '2HTML').'<br />'.END_LINE;
    echo _t('search','method');
    echo $display_method.'<br />'.END_LINE;
    echo '</div>'.END_LINE;
    echo '<div id="search-results">'.END_LINE;
    $start_time = getmicrotime();
    if ($rub == 'home') $rub = 'all';
    switch ($rub) {
    	case 'page':
    		$l21auth->isSuperAdmin() ? DisplaySearchPage($str, $type, $searchtype) : ReloadIndex('admin');
    		break;
      case 'project':
        $l21auth->isSuperAdmin() ? DisplaySearchProject($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'news':
        $l21auth->hasRight('news') ? DisplaySearchNews($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'newsletter':
        $l21auth->isSuperAdmin() ? DisplaySearchNewsletter($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'publication':
        $l21auth->hasRight('publication') ? DisplaySearchPublication($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('publication') ? DisplaySearchPubliContents($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'workshop':
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshop($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopRep($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopRepContents($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopCalendar($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopCom($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'workshoprep':
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopRep($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopRepContents($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'dashboard':
        $l21auth->hasRight('dashboard') ? DisplaySearchSdi($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'sdi':
        $l21auth->hasRight('dashboard') ? DisplaySearchSdi($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'comment':
        $l21auth->isSuperAdmin() ? DisplaySearchComment($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'yellowpages':
        $l21auth->isSuperAdmin() ? DisplaySearchYellowpages($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'user':
        $l21auth->isSuperAdmin() ? DisplaySearchUser($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'theme':
        $l21auth->isSuperAdmin() ? DisplaySearchTheme($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'scale':
        $l21auth->isSuperAdmin() ? DisplaySearchScale($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'level':
        $l21auth->isSuperAdmin() ? DisplaySearchLevel($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'all':
      	if ($l21auth->isSuperAdmin()) DisplaySearchPage($str, $type, $searchtype);
      	echo '<hr />';
        if ($l21auth->isSuperAdmin()) DisplaySearchProject($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->hasRight('news')) DisplaySearchNews($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->isSuperAdmin()) DisplaySearchNewsletter($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->hasRight('publication')) DisplaySearchPublication($str, $type, $searchtype);
        if ($l21auth->hasRight('publication')) DisplaySearchPubliContents($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshop($str, $type, $searchtype);
        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshopRep($str, $type, $searchtype);
        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshopRepContents($str, $type, $searchtype);
        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshopCalendar($str, $type, $searchtype);
        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshopCom($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->hasRight('dashboard')) DisplaySearchSdi($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->isSuperAdmin()) DisplaySearchComment($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->isSuperAdmin()) DisplaySearchYellowpages($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->isSuperAdmin()) DisplaySearchUser($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->isSuperAdmin()) DisplaySearchTheme($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->isSuperAdmin()) DisplaySearchScale($str, $type, $searchtype);
        echo '<hr />';
        if ($l21auth->isSuperAdmin()) DisplaySearchLevel($str, $type, $searchtype);
        echo '<hr />';
        break;
      default:
    }
    echo '</div>'.END_LINE;
    $end_time = getmicrotime();
    DisplayQueryTime($start_time, $end_time);
    logfile(LOG_KEYWORDS,array($str, $type, $searchtype, $rub, i2c_realip()));
    
    footerAddJS('../lib/js/jquery.easyMark.js');
    // we remove words < 3 chars
    $keywords = preg_replace(array('/\b\w{1,2}\b/','/\s+/'),array('',' '),$_REQUEST['search']);
    $js = "$('#search-results').easymark('highlight', '".formatText($keywords)."');";
    footerAddInlineJS($js);
  }
}
?>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>