<?php
/**
 * @package linea21.core
 * @subpackage system
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once ("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

$config_file = new config_file;

$link_mod=$rub_link."&amp;todo=mod&amp;type=";
$edit_theme=$rub_link."&amp;todo=edit_files";
?>
<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"> <?php echo _t('menu','system'); ?> </a></li>
  </ul>
</div>
<!--end barre haute -->
<?php include_once(THEME_ADMIN_PATH."quickicons.php"); ?>
<div class="contentcontainer"><?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));?>
<div id="content">

  <div id="define_readonly">
    <h2>LINEA RELEASE</h2>
    <?php echo check4newVersion(); ?>
    <dl>
    	<dt><?php echo _t('system','LINEA_VERSION'); ?></dt>
    	<dd><?php echo SITE_LINEA_NAME . ' - ' . LINEA_VERSION ?></dd>
    	<dt><?php echo _t('system','SITE_LINEA_URL'); ?></dt>
    	<dd><a href="<?php echo SITE_LINEA_URL; ?>" class="out"><?php echo SITE_LINEA_URL; ?></a></dd>
    	<dt><?php echo _t('system','MAIL_LINEA'); ?></dt>
    	<dd><a href="mailto:<?php echo MAIL_LINEA; ?>"><?php echo MAIL_LINEA; ?></a></dd>
    </dl>
    <br style="clear: both;" />
  </div>
  
    <div id="permissions_check">
    <h2><?php echo _t('system', 'permission_check'); ?></h2>
    <?php 
    
    function plugins_prefix($item)
    {
    	return '/plugins/'. $item;
    }
    $plugins = array_map('plugins_prefix', availablePlugins());
    $folders = array('/config','/library/userfiles', '/logs', '/tmp', str_replace('..', '', THEME_PUBLIC_PATH), $plugins);
    
    ?>
    <table>
    	<?php foreach($folders as $folder) { ?>
	    	<?php if(is_string($folder)) {?>
	    	<tr>
	    	<td><?php echo sprintf(_t('system', 'permission_writable'), '<code>'.$folder.'</code>'); ?> : </td>
	    	<td><?php if(is_writable ('..'.$folder)) echo '<div class="permission-ok" title="'._t('system', 'permission_ok').'"><span>'._t('system', 'permission_ok').'</span></div>';  else echo '<div class="permission-warn" title="'._t('system', 'permission_warn').'"><span>'._t('system', 'permission_warn').'</span></div>'; ?></td>
	    	</tr>
	    	<?php } elseif(is_array($folder)) { ?>
	    		<?php foreach($folder as $plugin) { ?>
	    		<tr>
		    	<td><?php echo sprintf(_t('system', 'permission_writable'), '<code>'.$plugin.'</code>'); ?> : </td>
		    	<td><?php if(is_writable ('..'.$plugin)) echo '<div class="permission-ok" title="'._t('system', 'permission_ok').'"><span>'._t('system', 'permission_ok').'</span></div>';  else echo '<div class="permission-warn" title="'._t('system', 'permission_warn').'"><span>'._t('system', 'permission_warn').'</span></div>'; ?></td>
		    	</tr>
	    		<?php } ?>
	    	<?php } ?>
    	<?php } ?>
    </table>
    <br style="clear: both;" />
  </div>
  
  <div class="toggle_title">
  	<a href="#define_theme"><?php echo _t('system','title_theme'); ?></a>
  </div>
  
  <div id="define_theme" style="display: none;">
  	<a href="<?php echo $edit_theme; ?>" class="edit_files"><?php echo _t('sys_theme', 'edit_public'); ?></a> 
    <?php echo ("<a href=\"".$link_mod."theme\" title=\""._t('system','mod')."\" class=\"ico_mod2\"></a>"); ?>
    
    <?php echo ($config_file->getThemeParams()); ?> 
    <br style="clear: both;" />
  </div>
  
  <div class="toggle_title">
  	<a href="#define_release"><?php echo _t('system','title_release'); ?> (<?php echo ($config_file->file_release); ?>)</a>
  </div>
  
  <div id="define_release" style="display: none;">
    <?php echo ("<a href=\"".$link_mod."define_release\" title=\""._t('system','mod')."\" class=\"ico_mod2\"></a>"); ?>
    <?php echo ($config_file->getReleaseParams()); ?>
    <br style="clear: both;" />
  </div>
  
  <div class="toggle_title">
  	<a href="#define_db"><?php echo _t('system','title_db'); ?> (<?php echo ($config_file->file_db); ?>)</a>
  </div>
  
  <div id="define_db" style="display: none;">
    <?php echo ("<a href=\"".$link_mod."define_db\" title=\""._t('system','mod')."\" class=\"ico_mod2\"></a>"); ?>
    <?php echo ($config_file->getDbParams()); ?> <br style="clear: both;" />
  </div>
  
  <div class="toggle_title">
  	<a href="#php_info"><?php echo _t('system','title_php_info'); ?></a>
  </div>
  
  <div id="php_info" style="display: none;">
    <?php echo ($config_file->getPhpInfo()); ?>
  </div>

</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>