<?php
/**
 * @package linea21.core
 * @subpackage system
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once ("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

include_once('../lib/input_helpers.php');

$config_file = new config_file;

$hidden=false; //variable pour cacher ou non les champs de formulaire
$link_mod=$rub_link."&amp;todo=mod&amp;type=";
$updatable=true; //le formulaire est en modification ou en visualisation

if (isset($_GET['type']))	$type=$_GET['type'];
if (isset($_POST['type'])) $type=$_POST['type'];

if(isset($_POST['valider'])) {
  $updatable=false;
  $hidden=true;
  $config_file->setParams($type,$_POST);
}
if(isset($_POST['enregistrer'])) {

  $config_file->setParams($type,$_POST);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  //ok on écrit les paramètres en fichiers
  if($type == 'define_release' || $type == 'theme') $result=$config_file->writeReleaseParams();
  else if($type == 'define_db') $result=$config_file->writeDbParams();
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','system')?></a></li>
	<li><span><?php echo _t('system','mod') ?></span></li>
</ul>
</div>

<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer">
  <?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));?>
  <div id="content">
    <h2><?php echo _t('system','mod'); ?></h2>
    <form id="<?php echo $type; ?>" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
      <?php
        switch ($type)
        {
          case 'define_release':
            echo $config_file->getReleaseParams($updatable,$hidden);
            break;
          case 'define_db':
            echo $config_file->getDbParams($updatable,$hidden);
            break;
          case 'theme':
            echo $config_file->getThemeParams($updatable,$hidden);
            break;
          default:
            echo $config_file->getReleaseParams($updatable,$hidden);
        }
      ?>
      <div>
        <input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
        <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
        <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
        <?php
        if(!isset($_POST['valider']) && !isset($_POST['enregistrer'])){
          echo cancel_button('javascript:history.go(-1);');
        ?>
        <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
        <?php }
        else if(isset($_POST['valider'])){
        ?>
        <?php echo cancel_button('?rub=system&amp;todo=list'); ?>
      	<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
      	<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="enregistrer" />
        <?php } ?>
       </div>
    </form>
  </div>
  <?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>