<?php
/**
 * @package linea21.templates
 * @subpackage admin
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @param  $rub : connu de admin/index.php
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * displayitem()
 * affichage des items du menu. Prise en charge de leur ETAT : actif ou non
 *
 * @param string $rubactive
 * @param string $currentrub
 * @param string $accesskey
 * @return string $content
 */

function displayitem($rubactive, $currentrub, $accesskey)
{
  $content = "<li><a href=\"index.php?rub=" . $currentrub . "\" accesskey=\"" . $accesskey . "\" title=\"" . $GLOBALS['lang']['menu_alt'][$currentrub] . "\" id=\"menu_".$currentrub."\" >" . mb_ucfirst($GLOBALS['lang']['menu_alt'][$currentrub]) . "</a></li>\n";
  return $content;
}

$menu_constructor_com = '';
$menu_constructor_gestion = '';
$menu_constructor_config = '';

if (MOD_NEWS === 1 && $l21auth->hasRight('news')) $menu_constructor_com .= displayitem($rub, 'news', 'a');


if (MOD_PUBLICATION === 1 && $l21auth->hasRight('publication')) $menu_constructor_com .= displayitem('workshop', 'publication', 'd');

if (MOD_NEWSLETTER === 1 && $l21auth->isSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'newsletter', 'r');
if (MOD_COMMENT === 1 && $l21auth->isSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'comment', '');
if (MOD_LIBRARY === 1 && $l21auth->isSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'library', 'l');
if (MOD_PAGE === 1 && $l21auth->isSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'page', 'c');

if (MOD_WORKSHOP === 1 && $l21auth->hasRight('workshop')) $menu_constructor_gestion .= displayitem('workshop', 'workshop', 'g');
if (MOD_PROJECT === 1 && $l21auth->isSuperAdmin()) $menu_constructor_gestion .= displayitem($rub, 'project', 'p');
if (MOD_SDI === 1 && $l21auth->isSuperAdmin()) $menu_constructor_gestion .= displayitem($rub, 'sdi', 'b');
if (MOD_DASHBOARD === 1 && $l21auth->hasRight('dashboard')) $menu_constructor_gestion .= displayitem($rub, 'dashboard', 'i');
if (MOD_YELLOWPAGES === 1 && $l21auth->hasRight('yellowpages')) $menu_constructor_gestion .= displayitem($rub, 'yellowpages', 'y');

if (MOD_USER === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'user', 'u');
if (MOD_THEME === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'theme', 't');
if (MOD_SCALE === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'scale', 'e');
if (MOD_LEVEL === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'level', 'n');
if (MOD_SYSTEM === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'system', 'n');
if (MOD_PLUGINS === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'plugins', 'o');
?>
<br />
<a href="<?php echo SITE_LINEA_URL; ?>" id="l21_logo" title="<?php echo SITE_LINEA_NAME; ?>"><span><?php echo SITE_LINEA_NAME; ?></span></a>
<ul class="containermenu">
	
	<li><a href="index.php" class="menu" id="menu_home"><?php echo $GLOBALS['lang']['menu_alt']['home_dashboard'];?></a></li>
	<li class="menu" id="menu_com"><?php echo $GLOBALS['lang']['menu_alt']['communication'];?>
	<ul class="sub_menu" id="menu_com_list">
	<?php echo $menu_constructor_com; ?>
	</ul>
	</li>
	<li class="menu" id="menu_gestion"><?php echo $GLOBALS['lang']['menu_alt']['suivi_gestion'];?>
	<ul class="sub_menu" id="menu_gestion_list">
	<?php echo $menu_constructor_gestion; ?>
	</ul>
	</li>
	<li class="menu" id="menu_config"><?php echo $GLOBALS['lang']['menu_alt']['configuration'];?>

	<ul class="sub_menu" id="menu_config_list">
	<?php echo $menu_constructor_config; ?>
	</ul>
	</li>
	<li><a href="../public/index.php" class="menu" id="menu_public_interface"><?php echo $GLOBALS['lang']['menu_alt']['interface_publique'];?>
	</a></li>
</ul>
<br style="clear: both" />
