<?php
/**
 * @package linea21.modules
 * @subpackage content
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Content' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

$contents_object = new contents;
$complete_type=strtoupper($mod_inc);
$form_title='';
$form_body='';

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$contents_object->AddContents($parent, $data_table, $complete_type, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&type=".$type."&id=".$parent;

  if($result===true) header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {
  $table[0]=$_POST['part_title'];
  $table[1]=$_POST['part_body'];


  $integrity=$contents_object->CheckDataIntegrity($table,$type);

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  
  $form_title=formatText($_POST['part_title'], $text_format);
  $form_body=formatText($_POST['part_body'], $text_format);

  $table=urlencode(serialize($table));
}

if($type=='P') {
  $requete= SQL_getPublicationTitle($parent);
  $result=$sql_object->DBSelect($requete);
  $current_title=FormatText($result[0]['publi_title']);
  $publi_owner=$result[0]['publi_posted_by'];
  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('publication')) ReloadIndex('admin');
  if ($l21auth->GetSessionElement('id')!=$publi_owner && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
}

if($type=='W') {
  $requete= SQL_getWorkshopRepTitleAndGroup($parent);
  $result=$sql_object->DBSelect($requete);
  $current_title=FormatText($result[0]['workrep_title']).' ('.FormatText($result[0]['workshop_denomination']).')';
  $workshop_id=$result[0]['workrep_workshop_id'];
  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
  if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $workshop_id) && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
}

?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu',$mod_inc)?></a></li>
	<li><span><?php echo formatNavTitle(_t('contents',$mod_inc.'_type')." : ". $current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2(_t('contents',$mod_inc.'_type')." : ". $current_title); ?></h2>
<form id="addpart" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <p>
    <label for="part_title"><?php echo mb_ucfirst(_t('contents','title')); ?> : *</label>
    <input name="part_title" type="text" class="textfield" id="part_title" maxlength="200" value="<?php echo $form_title; ?>" />
  </p>
  <p>
    <label for="part_body"><?php echo mb_ucfirst(_t('contents','body')); ?> : *</label>
    <textarea id="part_body" name="part_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
  </p>
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
    <input name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" />
    <?php echo cancel_button($cancel_link); ?>
    <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
  </div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
// Récapitulatif
} else	{
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo _t('recap','title') ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('contents','title'))." : </dt>\n";
echo "<dd>".$form_title."</dd>\n";
echo "<dt>".mb_ucfirst(_t('contents','body'))." :</dt>\n";
echo "<dd>".linkin_content($form_body)."</dd>\n";
echo "</dl>\n";
?>
<form id="addscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
    <input name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
}
?>