<?php
/**
 * @package linea21.modules
 * @subpackage dashboard
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


/**
 * Warning : If a trailing whitespace is present in any embedded file (for example, a plugin file), this graph won't display
 */

ob_start();
session_start();
include_once("../config/define.php");
//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
	include_once("../lib/lib_common.php");
	ReloadIndex('admin');
}
////////////

$scale_id=$_GET['scale_id'];
$id=$_GET['id'];

if(isset($_GET['type'])) {
	$type = $_GET['type'];
} else {
	$type = 'auto';
}


include_once("../class/class.sdi.php");
include_once(SQL.".inc.php");

if(isset($_GET['display'])) {
	generateGraphic($id, $scale_id, 'SCP', $type, true);
}


/**
 *
 * @param integer $id
 * @param integer $scale_id
 * @param string $type
 * @param string $workingpath
 */
function generateGraphic($id, $scale_id, $status, $type = 'auto', $display = false, $workingpath = '') {

	global $sql_object;

	// we get values
	$req_sdiav=SQL_getAllValue($status, $scale_id, $id, 'ASC');
	$value = $sql_object->DBSelect($req_sdiav);
	$req_sdii=SQL_getInfoSdi($id);
	$result_sdii = $sql_object->DBSelect($req_sdii);

	$unit=$result_sdii[0]['sdii_unit'];
	$full_title=formatText($result_sdii[0]['sdii_name']);
	$title=cutText($full_title, 50, 0);
	
	// visualization type
	if($type == 'auto') {
		$type = $result_sdii[0]['sdii_detail_viz'];
	}

	$is_null_threshold = true; // is the threshold null or not? to know if we display it
	for ($i=0; $i<count($value); $i++) {
		$ydata[$i]=$value[$i]['sdiv_value'];
		// setting $threshold_value
		// By default initial value
		$ydata2[$i]=$result_sdii[0]['sdii_threshold_value'];
		// if set, we get it from the table
		if(!is_null($value[$i]['sdiv_threshold'])) {
			$ydata2[$i]=$value[$i]['sdiv_threshold'];
		}
		// if at least one numeric value is there test is false
		if(is_numeric($ydata2[$i])) $is_null_threshold = false;

		list($day, $month, $year)=explode('-',$value[$i]['date_p']);
		$months[$i] = $day . '-' .$month. '-'. substr($year, 2, 2);
	}


	/* pChart library inclusions */
	include_once("../class/system/pChart/class/pData.class.php");
	include_once("../class/system/pChart/class/pDraw.class.php");
	include_once("../class/system/pChart/class/pImage.class.php");

	/* Create and populate the pData object */
	$MyData = new pData();
	//  $MyData->loadPalette("../class/system/pChart/palettes/blind.color",TRUE);
	$MyData->setAxisName(0,$unit);
	$MyData->addPoints($ydata,$full_title);
	$MyData->addPoints($ydata2,"thresholds");
	$MyData->addPoints($months,"Dates");
	$MyData->setSerieDescription($full_title,$unit);
	$MyData->setAbscissa("Dates");

	/* Create the pChart object */
	$myPicture = new pImage(500,350,$MyData);
	/* Turn of Antialiasing */
	$myPicture->Antialias = TRUE;
	/* Add a border to the picture */
	// $myPicture->drawRectangle(0,0,499,349,array("R"=>180,"G"=>180,"B"=>180));
	/* Set the default font */
	$myPicture->setFontProperties(array("FontName"=>"../class/system/pChart/fonts/verdana.ttf","FontSize"=>7,"R"=>80,"G"=>80,"B"=>80));
	/* Define the chart area */
	$myPicture->setGraphArea(50,20,480,300);


	/* Draw the scale */
	$scaleSettings = array(
			// grid settings
			"GridR"=>160,"GridG"=>160,"GridB"=>160,"GridTicks"=>1, "DrawSubTicks"=>TRUE,
			// axis settings
			"AxisR"=>80,"AxisG"=>80,"AxisB"=>80,
			"CycleBackground"=>TRUE, 'LabelRotation'=>50,
			"DrawArrows"=>FALSE);
	$myPicture->drawScale($scaleSettings);



	/* Draw the chart */
	$myPicture->setShadow(TRUE,array("X"=>1,"Y"=>1,"R"=>0,"G"=>0,"B"=>0,"Alpha"=>10)); /* Turn on shadow computing */
	$settings = array(
			"InnerBorderR"=>80, "InnerBorderG"=>80, "InnerBorderB"=>80,
			"BorderR"=>80, "BorderG"=>80, "BorderB"=>80,
			// color and gradient settings
			"DisplayColor"=>DISPLAY_MANUAL,
			"Gradient"=>TRUE,"GradientStartR"=>207,"GradientStartG"=>228,"GradientStartB"=>252,
			"GradientEndR"=>146, "GradientEndG"=>174, "GradientEndB"=>206,"GradientAlpha"=>100,
			// label settings
			"DisplayValues"=>FALSE, "DisplayPos"=>LABEL_POS_OUTSIDE,"DisplayR"=>115,"DisplayG"=>115,"DisplayB"=>115,"DisplayOrientation"=>ORIENTATION_AUTO,
			"DisplayShadow"=>FALSE,
			"Draw0Line"=>FALSE,
			//"Rounded"=>TRUE, // not working with gradient
			"Surrounding"=>-30,
			"InnerSurrounding"=>0);

	/* Write the chart legend */
	//$myPicture->drawLegend(50,5,array("Style"=>LEGEND_NOBORDER,"Mode"=>LEGEND_HORIZONTAL));




	switch ($type) {
		case 'line':
			$MyData->setSerieDrawable($full_title,TRUE);
			$MyData->setSerieDrawable("thresholds",FALSE);

			$thresholdsSettings = array("R"=>254,"G"=>148,"B"=>64);
			$MyData->setPalette("thresholds",$thresholdsSettings);
			$valuesSettings = array("R"=>36,"G"=>47,"B"=>74);
			$MyData->setPalette($full_title,$valuesSettings);

			//$MyData->setSerieWeight($full_title, 0.5); // will draw a 1px curve - not nice with drawSplineChart
			//$myPicture->drawLineChart($settings);
			$myPicture->drawSplineChart($settings);
			$myPicture->drawPlotChart($settings);

			/* Draw the line and plot chart */
			$myPicture->setShadow(FALSE); /* Turn off shadow computing */

			// if at least one threshold is there we display the serie on graph
			if(!$is_null_threshold) {
				$MyData->setSerieDrawable("thresholds",TRUE);
			}
			$MyData->setSerieDrawable($full_title,FALSE);
			$myPicture->drawSplineChart();
			// $myPicture->drawLineChart($settings);
			// $myPicture->drawPlotChart();

			break;
		case 'area':
			$MyData->setSerieDrawable($full_title,TRUE);
			$MyData->setSerieDrawable("thresholds",FALSE);
				
			$thresholdsSettings = array("R"=>254,"G"=>148,"B"=>64);
			$MyData->setPalette("thresholds",$thresholdsSettings);
			$valuesSettings = array("R"=>207,"G"=>228,"B"=>252);
			$MyData->setPalette($full_title,$valuesSettings);


			$myPicture->drawAreaChart($settings);

			/* Draw the line and plot chart */
			$myPicture->setShadow(FALSE); /* Turn off shadow computing */

			// if at least one threshold is there we display the serie on graph
			if(!$is_null_threshold) {
				$MyData->setSerieDrawable("thresholds",TRUE);
			}
			$MyData->setSerieDrawable($full_title,FALSE);
			//$myPicture->drawSplineChart();
			$myPicture->drawLineChart();
			$myPicture->drawPlotChart();

			break;
		default: // 'column' type
			$MyData->setSerieDrawable($full_title,TRUE);
			$MyData->setSerieDrawable("thresholds",FALSE);

			$thresholdsSettings = array("R"=>254,"G"=>148,"B"=>64);
			$MyData->setPalette("thresholds",$thresholdsSettings);
			$valuesSettings = array("R"=>207,"G"=>228,"B"=>252);
			$MyData->setPalette($full_title,$valuesSettings);

			$myPicture->drawBarChart($settings);

			/* Draw the line and plot chart */
			$myPicture->setShadow(FALSE); /* Turn off shadow computing */

			// if at least one threshold is there we display the serie on graph
			if(!$is_null_threshold) {
				$MyData->setSerieDrawable("thresholds",TRUE);
			}
			$MyData->setSerieDrawable($full_title,FALSE);
			$myPicture->drawSplineChart();
			$myPicture->drawPlotChart();
			break;
	}

	if($display == true) {
		/* Render the picture - display it */
		$myPicture->autoOutput("simple.png");
	} else {
		/* Save the picture */
		if(!file_exists($workingpath)) mkdir($workingpath);
		$myPicture->render($workingpath.'/'.$id.'_'.$scale_id.'.png');
	}
	
	return true;

}

?>