<?php
/**
 * @package linea21.modules
 * @subpackage dashboard
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('dashboard')) ReloadIndex('admin');
////////////

include_once("../lib/input_helpers.php");
if (!isset($_GET['value_id']) && !isset($_POST['value_id'])) {
  $value_id = 1;
} else {
  if (isset($_POST['value_id'])) $value_id = $_POST['value_id'];
  if (isset($_GET['value_id'])) $value_id = $_GET['value_id'];
}
if (!isset($_GET['id']) && !isset($_POST['id'])) {
  $id = 1;
} else {
  if (isset($_POST['id'])) $id = $_POST['id'];
  if (isset($_GET['id'])) $id = $_GET['id'];
}
if (!isset($_GET['scale_id']) && !isset($_POST['scale_id'])) {
  $scale_id = 1;
} else {
  if (isset($_POST['scale_id'])) $scale_id = $_POST['scale_id'];
  if (isset($_GET['id'])) $scale_id = $_GET['scale_id'];
}

$req_sdii=SQL_getInfoSdi($id);
$result_sdii = $sql_object -> DBSelect($req_sdii);

$navtitle=_t('dashboard','mod')." : ".$result_sdii[0]['sdii_name'];

$sdi_object = new sdi;
$req_sdiov=SQL_getOneValue($value_id);
$result_value = $sql_object -> DBSelect($req_sdiov);
//$result_value = $sdi_object -> GetOneValue($value_id, $sql_object);

$link_mod_sdi = "index.php?&amp;rub=sdi&amp;todo=det&amp;id=";
$link_cancel=$rub_link."&amp;todo=det&amp;id=".$id."&amp;scale_id=".$scale_id;

if (isset($_POST['enregistrer'])) {
  $data_table = unserialize(urldecode($_POST['data_table']));
  $sdi_object = new sdi;
  $result = $sdi_object -> ModifyValue($value_id, $data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id."&scale_id=".$scale_id;
  if (isset($result)) header("Location: " . $link_confirm);
  else system_error();
}
$form_value = $result_value[0]['sdiv_value'];
$form_sdi_id = $id;
$form_scale_id = $scale_id;

// setting $form_threshold value
// By default initial value
$default_threshold = $result_sdii[0]['sdii_threshold_value'];
// if set, we get it from the table
if(!is_null($result_value[0]['sdiv_threshold'])) {
	$form_threshold = $result_value[0]['sdiv_threshold'];
} else {
	$form_threshold = $default_threshold;
}

$form_date = $result_value[0]['date_p'];
$form_statut = $result_value[0]['sdiv_statut'];
$form_comment = $result_value[0]['sdiv_comment'];
$form_statutc = $result_value[0]['sdiv_comment_display'];
if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
if($form_statutc=='Y') $mask_statutc_public="checked=\"checked\""; else $mask_statutc_public='';
if($form_statutc=='N') $mask_statutc_private="checked=\"checked\""; else $mask_statutc_private='';

if (isset($_POST['valider1'])) {

  $table[0] = $_POST['value'];
  $table[1] = $_POST['id'];
  $table[2] = $_POST['threshold'];
  $table[3] = $_POST['scale'];
  $table[4] = $_POST['date'];
  $table[5] = $_POST['statut'];
  $table[6] = $_POST['comment'];
  $table[7] = $_POST['statutc'];

  $sdi_object = new sdi;
  $integrity = $sdi_object -> CheckDataIntegrity_value($table, $sql_object);

  $form_value = $_POST['value'];
  $form_sdi_id = $_POST['id'];
  $form_threshold = $_POST['threshold'];
  $form_scale_id = $_POST['scale'];
  $form_date = $_POST['date'];
  $form_statut = $_POST['statut'];
  $form_statutc = $_POST['statutc'];
  if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  if($form_statutc=='Y') $mask_statutc_public="checked=\"checked\""; else $mask_statutc_public='';
  if($form_statutc=='N') $mask_statutc_private="checked=\"checked\""; else $mask_statutc_private='';
  $table = urlencode(serialize($table));
}

include_once(THEME_ADMIN_PATH."quickicons.php");
$resultscale = $sql_object -> DBSelect($req_list_scale);
$listing=ScaleSelectBox($resultscale, "scale" ,$form_scale_id);


footerAddJS('../lib/js/jquery.datePicker.l10n/jquery.ui.datepicker-'.U_L.'.js');
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','dashboard'); ?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->


<script type="text/javascript">	
	$(function()
	{
		var dateFormat = "<?php echo DATE_FORMAT; ?>";
		dateFormat = dateFormat.replace("yyyy", "yy");
		
		$(".date-pick").datepicker({
			showOn: "button",
			buttonImage: "../lib/js/calendar.png",
			buttonImageOnly: true,
			dateFormat: dateFormat,
			dateMin: new Date(2000, 1 - 1, 1)
		});
		$( ".date-pick" ).datepicker( $.datepicker.regional[ "<?php echo U_L; ?>" ] );

		var thresholds = <?php echo json_encode($sdi_object->getScalesThresholds($id, $default_threshold, $sql_object)); ?>;

		// update threshold value when changing scale
		$('#scale').change(function() {
			  var key = $("#scale").val()
			  $("#threshold").val(thresholds[key]);
			});
		
    });
</script>

<?php
if (!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if (isset($integrity) && is_string($integrity)) display_errors($integrity);

if ($l21auth->isSuperAdmin()){?>
<div class="mod_link">
	<a href="<?php echo $link_mod_sdi . $id ; ?>"><?php echo _t('dashboard','det_sdi');?></a>
</div>
<br class="brendstep" />

<?php }?>
<h2><?php echo formatTitleh2($result_sdii[0]['sdii_name']); ?></h2>

<form id="addvalue" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
	<label for="value"><?php echo mb_ucfirst(_t('dashboard','value')) ?> (<?php echo formatText($result_sdii[0]['sdii_unit'], '2HTML'); ?>) : *</label>
	<input name="value" type="text" id="value" maxlength="255" value="<?php echo $form_value; ?>" class="textfield" />
</p>
<p>
	<label for="scale"><?php echo mb_ucfirst(_t('dashboard','scale')) ?> : *</label>
    <?php echo $listing; ?>
</p>
<p>
	<label for="threshold"><?php echo mb_ucfirst(_t('sdi','threshold_value')) ?> :</label>
	<input name="threshold" type="text" id="threshold" maxlength="100" value="<?php echo $form_threshold; ?>" class="textfield" />
</p>
<div class="label"><?php echo mb_ucfirst(_t('divers','statut')); ?> : *</div>
<div class="rightpanel">
	<input name="statut" type="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> />
	<label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
	<input name="statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> />
	<label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
</div>

<p>
	<label for="date"><?php echo mb_ucfirst(_t('dashboard','date')); ?> * : </label>
	<input name="date" type="text" maxlength="10" id="date" class="date-pick shorttextfield" value="<?php echo $form_date; ?>" />
</p>
<p>
	<label for="comment"><?php echo mb_ucfirst(_t('dashboard','comment')) ?> : </label> 
	<textarea id="comment" name="comment" <?php echo AREA_SETTINGS; ?>	class="largetextfield"><?php echo $form_comment; ?></textarea>
</p>

<div class="label"><?php echo mb_ucfirst(_t('dashboard','comment_status')); ?> * : </div>
<div class="rightpanel">
	<input name="statutc" type="radio" id="statutc_P" value="Y" <?php echo $mask_statutc_public; ?> />
	<label for="statutc_P"><?php echo mb_ucfirst(_t('dashboard','public')); ?></label>
	<input name="statutc" type="radio" id="statutc_D" value="N" <?php echo $mask_statutc_private; ?> />
	<label for="statutc_D"><?php echo mb_ucfirst(_t('dashboard','private')); ?></label>
</div>


<div class="toggle_title">
	<a href="#" id="affeval"><?php echo _t('sdi','info_mesure'); ?></a>
</div>
<div id="evaluation" style="display: none;"><br class="brendstep" />
<table cellspacing="0" cellpadding="3">
	<thead>
		<tr>
		<?php
		echo "<td>" . mb_ucfirst(_t('sdi','unit')) . "</td>\n";
		echo "<td>" . mb_ucfirst(_t('sdi','max_value')) . "</td>\n";
		echo "<td>" . mb_ucfirst(_t('sdi','min_value')) . "</td>\n";
		echo "<td>" . mb_ucfirst(_t('sdi','initial_threshold_value')) . "</td>\n";

		?>
		</tr>
	</thead>
	<tbody>
	<?php echo "<tr>\n";
	echo "<td>" . $result_sdii[0]['sdii_unit'] . "</td>\n";
	echo "<td>" . empty_nc($result_sdii[0]['sdii_max_value']) . "</td>\n";
	echo "<td>" . empty_nc($result_sdii[0]['sdii_min_value']) . "</td>\n";
	echo "<td>" . empty_nc($result_sdii[0]['sdii_threshold_value']) . "</td>\n";
	echo "</tr>\n";

	?>
	</tbody>
</table>
</div>
<div>
	<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
	<input name="scale_id" type="hidden" value="<?php echo $scale_id; ?>" id="scale_id" />
	<input name="value_id" type="hidden" value="<?php echo $value_id; ?>" id="value_id" />
	<?php echo cancel_button($link_cancel); ?>
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<input name="valider1" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div>
    <?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
    <?php
    // Récapitulatif
} else {
  if (!isset($integrity5) || is_string($integrity5)) {
    $table = unserialize(urldecode($table));
    $req_scale = SQL_getonescale($table[3]);
    $resultscale2 = $sql_object -> DBSelect($req_scale);

    $display_comment = formatText(empty_none($_POST['comment']), '2HTML');
	    
	($form_statutc == 'Y') ? $display_comment_status = _t('dashboard', 'public') : $display_comment_status = _t('dashboard', 'private');
	
    $display_sdi_value = $table[0];
    $display_threshold_value = empty_nc($table[2]);
    // afficher nom de scale
    $display_sdi_scale = formatText($resultscale2[0]['scale_denomination'], '2HTML');
    $display_sdi_date = $table[4];
    $display_sdi_statut = $table[5];
    $table = urlencode(serialize($table));

    ?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo _t('recap','title') ;?></h2>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('dashboard','value'));	?> :</dt>
	<dd><?php echo $display_sdi_value . " " . $result_sdii[0]['sdii_unit']; ?>
	</dd>
	<dt><?php echo mb_ucfirst(_t('sdi','name2')); ?> :</dt>
	<dd><?php echo formatText($result_sdii[0]['sdii_name'], '2HTML'); ?> </dd>
	<dt><?php echo mb_ucfirst(_t('divers','statut')); ?> :</dt>
	<dd><?php echo display_statut($display_sdi_statut); ?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','date'));	?> :</dt>
	<dd><?php echo $display_sdi_date; ?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','scale'));	?> :</dt>
	<dd><?php echo $display_sdi_scale;	?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','threshold_value'));	?> :</dt>
	<dd><?php echo $display_threshold_value;	?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','comment')); ?> :</dt>
	<dd><?php echo $display_comment ;?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','comment_status')); ?> :</dt>
	<dd><?php echo $display_comment_status ;?></dd>
</dl>
<form id="addvalue2" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="scale_id" type="hidden" value="<?php echo $scale_id; ?>" id="scale_id" />
    <input name="value_id" type="hidden" value="<?php echo $value_id; ?>" id="value_id" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <?php echo cancel_button($link_cancel); ?>
    <input	name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>
<?php
  }
}
?>