<?php
/**
 * @package linea21.core
 * @subpackage level
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

$req_det= SQL_getdetlevel($id);

$result=$sql_object->DBSelect($req_det);
$current_title=$result[0]['level_name'];
$display_desc=formatText($result[0]['level_description'], '2HTML');
$display_comment=formatText(empty_none($result[0]['level_comment'], '2HTML'));
$display_range=$result[0]['level_range'];
$display_date_crea=$result[0]['level_date_crea'];
$display_last_modify=$result[0]['level_last_modify'];
$display_status=display_statut($result[0]['level_statut']);

// formattage des données
if(!empty($result[0]['level_visual_identity'])) {
  $complete_uri="../".$result[0]['level_visual_identity'];
  $complete_uri='<img src="' . $complete_uri . '" alt="" />' . END_LINE;
} else $complete_uri=_t('divers','novisu');


$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','level'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('level','det')." : ".$current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2($current_title); ?></h2>
<?php
echo "\t<a href=\"".$link_mod.$id."\" title=\""._t('level','mod')."\" class=\"ico_mod2\"></a>\n";
?>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('level','description')); ?> :</dt>
	<dd><?php echo $display_desc; ?></dd>
	<dt><?php echo mb_ucfirst(_t('level','comment')); ?> :</dt>
	<dd><?php echo $display_comment;?></dd>
	<dt><?php echo mb_ucfirst(_t('level','visual_identity')); ?> :</dt>
	<dd><?php echo $complete_uri; ?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','range')); ?> :</dt>
	<dd><?php echo $display_range;?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','last_modify')); ?> :</dt>
	<dd><?php echo $display_last_modify;?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','date_crea')); ?> :</dt>
	<dd><?php echo $display_date_crea; ?></dd>
	<!--
		<dt><?php echo mb_ucfirst(_t('divers','statut')); ?>  :</dt>
		<dd><?php echo $display_status;?></dd>
		-->
</dl>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>