<?php
/**
 * @package linea21.core
 * @subpackage mail
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


require_once '../lib/vendor/swift/lib/swift_required.php';

// We create the Transport
if (defined('MAIL_MAILER')) {
	
	// by default
	$transport = Swift_MailTransport::newInstance();

	// sendmail
	if(MAIL_MAILER=='sendmail') {
		
		$transport = Swift_SendmailTransport::newInstance(MAIL_SENDMAIL);
		
	}
	// smtp
	if(MAIL_MAILER=='smtp') {
		if(defined('MAIL_SMTP_AUTH') && MAIL_SMTP_AUTH == 1) {
			
			$transport = Swift_SmtpTransport::newInstance(MAIL_HOST, MAIL_PORT)
			->setUsername(MAIL_SMTP_USER)
			->setPassword(MAIL_SMTP_PASS);
			
		} else {
			
			$transport = Swift_SmtpTransport::newInstance(MAIL_HOST, MAIL_PORT);
			
		}

	}
	
}


/**
 echo "destinataire : ".$email_recipient."<br />";
 echo "sujet : ".$email_subject."<br />";
 echo "body : ".$email_html_body."<br />";
 echo "methode : ".$email_method."<br />";
 echo "host : ".$mail->Host."<br />";
 echo "port : ".$mail->Port."<br />";
 */

// Create the Mailer using the Transport
$mailer = Swift_Mailer::newInstance($transport);


isset($email_from) ? $from = $email_from : $from = MAIL_FROM;
isset($email_fromname) ? $fromname = $email_fromname : $fromname = MAIL_FROMNAME;
$altbody = str_replace('&amp;', '&', $email_text_body);

// preparing footer
$html_footer = _t('mail', 'footer');
$html_footer .= "<br />-------------------<br />";
$html_footer .= "<small><a href=\"".SITE_ROOT_URL. "public/\">".SITE_NAME."</a> - <a href=\"mailto:".SITE_MAIL. "\">"._t('contact','contact_us')."</a></small>";

$txt_footer = strip_tags(_t('mail', 'footer'));
$txt_footer .= "\n-------------------\n";
$txt_footer .= SITE_ROOT_URL. "public/ - "._t('contact','contact_us')." : ".SITE_MAIL;

// We add greetings to content
$email_html_body = _t('mail', 'header_hello')."<br /><br />".$email_html_body. $html_footer;
$email_html_body = '<div style="font-family: Arial, Helvetica, sans-serif;">'. $email_html_body. '</div>';
$altbody = _t('mail', 'header_hello')."\n\n".$altbody. $txt_footer;

// if only one email is given we put it an array
if(is_string($email_recipient)) {
	$tmp = $email_recipient;
	$email_recipient = array();
	array_push($email_recipient, $tmp);
}

// Create a message
$message = Swift_Message::newInstance($email_subject)
					->setFrom(array($from => $fromname))
					->setBody($email_html_body, 'text/html')
					->addPart($altbody, 'text/plain')
					->setReplyTo(array(MAIL_REPLY => MAIL_REPLYNAME))
					;
					

					
if(is_array($email_recipient)) {
	
	for($i=0; $i<count($email_recipient); $i++) {

		$message->setTo($email_recipient[$i]);
		$r = $mailer->Send($message, $failures);
		
		if(!$r) { 
			$logmsg = 'not sent';
		} else {
			$logmsg = 'sent';
		}
		
		logfile(LOG_MAILER, array($email_subject, $email_recipient[$i], $logmsg));
		if(!$r && MOD_DEBUG == 1) {
			_debug('<b>Mail has not been sent</b>. "'. $email_recipient[$i] .' / '.$email_subject.'" : ' .$logmsg);
		}


	}
	
}


?>