<?php
/**
 * @package linea21.modules
 * @subpackage news
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('news')) ReloadIndex('admin');
////////////
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','news'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('news','add')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
$form_title='';
$form_header='';
$form_body='';
$form_theme=-1;
$form_scale=-1;
$form_level=-1;
$mask_statut_P="checked=\"checked\"";
$mask_statut_D='';


$news_object = new news;

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$news_object->AddNews($data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if(is_numeric($result)) header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {
  $table[0]=$_POST['news_title'];
  $table[1]=$_POST['news_header'];
  $table[2]=$_POST['news_body'];
  $table[3]=$_POST['news_theme'];
  $table[4]=$_POST['news_scale'];
  $table[5]=$_POST['news_level'];
  $table[6]=0; //range
  $table[7]=$l21auth->GetSessionElement('id'); // ID posteur
  $table[8]=''; // date de péremption
  $table[9]='N'; // is_national
  $table[10]=$_POST['news_statut'];

  $integrity=$news_object->CheckDataIntegrity($table);

 
  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  $form_title=formatText($_POST['news_title'], $text_format);
  $form_header=formatText($_POST['news_header'], $text_format);
  $form_body=formatText($_POST['news_body'], $text_format);
  $form_theme=$_POST['news_theme'];
  $form_scale=$_POST['news_scale'];
  $form_level=$_POST['news_level'];


  if($_POST['news_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['news_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  $table=urlencode(serialize($table));
}


if(!isset($integrity) || is_string($integrity)) {
  include_once("../lib/input_helpers.php");

  // select-box de thèmes
  $data=$sql_object->DBSelect($req_list_theme);
  $select_theme=ThemeSelectBox($data, "news_theme", $form_theme);

  // select-box des échelles
  $data=$sql_object->DBSelect($req_list_scale);
  $select_scale=ScaleSelectBox($data, "news_scale", $form_scale);

  // select-box des niveaux
  $data=$sql_object->DBSelect($req_list_level);
  $select_level=LevelSelectBox($data, "news_level", $form_level);

}

include_once(THEME_ADMIN_PATH."quickicons.php");

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2(_t('news','add_title')); ?></h2>
<form id="addnews" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="news_title"><?php echo mb_ucfirst(_t('news','title')); ?> : *</label>
  <input name="news_title" type="text" maxlength="200" id="news_title" class="textfield" value="<?php echo $form_title; ?>" />
</p>
<p>
  <label for="news_header"><?php echo mb_ucfirst(_t('news','header')); ?> : *</label>
  <textarea id="news_header" name="news_header" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_header; ?></textarea>
</p>
<p>
  <label for="news_body"><?php echo mb_ucfirst(_t('news','body')); ?> : *</label>
  <textarea id="news_body" name="news_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
</p>
<p>
  <label for="news_theme"><?php echo mb_ucfirst(_t('news','theme')); ?> : *</label>
  <?php echo $select_theme; ?>
</p>
<p>
<label for="news_scale"><?php echo mb_ucfirst(_t('news','scale')); ?> : *</label>
  <?php echo $select_scale; ?>
</p>
<p>
  <label for="news_level"><?php echo mb_ucfirst(_t('news','level')); ?> : </label>
  <?php echo $select_level; ?>
</p>
  <div class="label"><?php echo mb_ucfirst(_t('news','statut')); ?> : *</div>
  <div class="rightpanel">
  <input name="news_statut" type="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> /><label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
  <input name="news_statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> /><label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
  </div>
<div>
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?>
  <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div>
	<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
	<?php
	// Récapitulatif
} else	{

  $requete=SQL_getonethemeName($form_theme);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) exit;
  else $theme_denomination=formatText($result[0]['theme_name'], '2HTML');

  $requete=SQL_getonescaleDenomination($form_scale);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) exit;
  else $scale_denomination=formatText($result[0]['scale_denomination'], '2HTML');

  if($form_level <> -1) {
    $requete=SQL_getonelevelName($form_level);
    $result=$sql_object->DBSelect($requete);
    if($result==0 || count($result)!=1) exit;
    else $level_denomination=formatText($result[0]['level_name'], '2HTML');
  }else $level_denomination=_t('divers','none');


  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('news','title'))." :</dt>\n";
echo "<dd>". $form_title."</dd>\n";
echo "<dt>". mb_ucfirst(_t('news','header')). " :</dt>\n";
echo "<dd>".empty_nc(linkin_content($form_header))."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','body'))." :</dt>\n";
echo "<dd>".linkin_content($form_body)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','theme'))." :</dt>\n";
echo "<dd>".$theme_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','scale'))." :</dt>\n";
echo "<dd>".$scale_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','level'))." :</dt>\n";
echo "<dd>".$level_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
echo "<dd>". display_statut($_POST['news_statut']). "</dd>\n";
echo "</dl>\n";
?>
<form id="addscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <?php echo cancel_button('?rub=news&amp;todo=list'); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
  </div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
}
?>