<?php
/**
 * @package linea21.modules
 * @subpackage news
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('news')) ReloadIndex('admin');
////////////

if (isset($_GET['id'])) $id = $_GET['id'];
if (isset($_POST['id'])) $id = $_POST['id'];

$req_det = SQL_getoneCompleteNews($id);
$result = $sql_object->DBSelect($req_det);
if ($result == 0 || count($result) != 1) exit;

$news_object = new news;

$display_title = formatText($result[0]['news_title'], '2HTML');
$display_header = linkin_content(formatText(empty_none($result[0]['news_header']), '2HTML'));
$display_body = linkin_content(formatText($result[0]['news_body'], '2HTML'));
$display_theme = formatText($result[0]['theme_name'], '2HTML');
$display_scale = formatText($result[0]['scale_denomination'], '2HTML');
$display_level = formatText(empty_none($result[0]['level_name'], '2HTML'));
$display_user = formatText($result[0]['user_login'], '2HTML');
$display_date_crea = $result[0]['news_date_crea_display'];
$display_last_modify = $result[0]['news_last_modify_display'];
$news_theme_id=$result[0]['news_theme'];
$news_scale_id=$result[0]['news_scale'];
$news_level_id=$result[0]['news_level'];
$news_owner = $result[0]['news_posted_by'];

$display_statut = display_statut($result[0]['news_statut']);
if ($result[0]['news_published_date_display'] == '01-01-0001') $display_published_date = mb_ucfirst(_t('statut','draft'));
else $display_published_date = $result[0]['news_published_date_display'];


$link_sup = $rub_link . "&amp;todo=sup&amp;id=";
$link_mod = $rub_link . "&amp;todo=mod&amp;id=";

?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"> <?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"> <?php echo _t('menu','news'); ?> </a></li>
	<li><span><?php echo formatNavTitle(_t('news','det') . " : " . $display_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");

?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

?>
<div id="content"><?php
echo "<h2>";
echo formatTitleh2($display_title);
echo "</h2>\n";
if ($l21auth->GetSessionElement('id') == $news_owner || $l21auth->isSuperAdmin()) {
  echo "\t<a href=\"" . $link_sup . $id . "\" class=\"ico_sup2\" title=\"" . _t('news','sup') . "\"><i class=\"icon-trash\"></i><span>" . _t('news','sup') . "</span></a>\n";
  echo "\t<a href=\"" . $link_mod . $id . "\" class=\"ico_mod2\" title=\"" . _t('news','mod') . "\"><i class=\"icon-pencil\"></i><span>" . _t('news','mod') . "</span></a>\n";
}
echo "<dl class=\"summary\">\n";
echo "<dt>" . mb_ucfirst(_t('news','title')) . " :</dt>\n";
echo "<dd>" . $display_title . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('news','header')) . " :</dt>\n";
echo "<dd>" . $display_header . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('news','body')) . " :</dt>\n";
echo "<dd>" . $display_body . "</dd>\n";

if($l21auth->isSuperAdmin()) {
  echo "<dt>" . mb_ucfirst(_t('news','theme')) . " :</dt>\n";
  echo '<dd><a href="?rub=theme&amp;todo=det&amp;id='.$news_theme_id.'">' . $display_theme . '</a></dd>'.END_LINE;
  echo "<dt>" . mb_ucfirst(_t('news','scale')) . " :</dt>\n";
  echo '<dd><a href="?rub=scale&amp;todo=det&amp;id='.$news_scale_id.'">' . $display_scale . '</a></dd>'.END_LINE;
  echo "<dt>" . mb_ucfirst(_t('news','level')) . " :</dt>\n";
  if($news_level_id <> -1) echo '<dd><a href="?rub=level&amp;todo=det&amp;id='.$news_level_id.'">' . $display_level . '</a></dd>'.END_LINE;
  else echo '<dd>' . $display_level . '</dd>'.END_LINE;
  echo "<dt>" . mb_ucfirst(_t('news','author')) . " :</dt>\n";
  echo '<dd><a href="?rub=user&amp;todo=det&amp;id='.$news_owner.'">' . $display_user . '</a></dd>'.END_LINE;
} else {
  echo "<dt>" . mb_ucfirst(_t('news','theme')) . " :</dt>\n";
  echo "<dd>" . $display_theme . "</dd>\n";
  echo "<dt>" . mb_ucfirst(_t('news','scale')) . " :</dt>\n";
  echo "<dd>" . $display_scale . "</dd>\n";
  echo "<dt>" . mb_ucfirst(_t('news','level')) . " :</dt>\n";
  echo "<dd>" . $display_level . "</dd>\n";
  echo "<dt>" . mb_ucfirst(_t('news','author')) . " :</dt>\n";
  echo "<dd>" . $display_user . "</dd>\n";
}
echo "<dt>" . mb_ucfirst(_t('statut','published_on')) . " :</dt>\n";
echo "<dd>" . $display_published_date . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','date_crea')) . " :</dt>\n";
echo "<dd>" . $display_date_crea . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','last_modify')) . " :</dt>\n";
echo "<dd>" . $display_last_modify . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','statut')) . " :</dt>\n";
echo "<dd>" . $display_statut . "</dd>\n";
echo "</dl>\n";

?></div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>