<?php
/**
 * @package linea21.modules
 * @subpackage news
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../news/' . SQL . '.inc.php'));



/**
 * get_latestnews_id()
 * return latestnews_id
 *
 * @return int or false
 */

function get_latestnews_id()
{
	global $sql_object;

	$r = $sql_object->DBSelect(SQL_getLatestNews());

	if(isset($r[0])) return $r[0]['news_id'];

	return false;
}

/**
 * DisplayListNews()
 * Affichage de la liste des news publique
 *
 * @param  $statut
 * @param  $filter
 * @param  $id_filter
 * @param  $debut
 * @return void echo content
 */
if(!function_exists('DisplayListNews')) {

  function DisplayListNews($statut, $filter, $id_filter, $debut)
  {
    if ($statut == 'public') {
      $pas = SELECT_LIMIT;
      $suffix = '';
    } else $pas = SELECT_LIMIT;
    
    
    if ($statut == 'archives_p') $suffix = ' "'.strtolower(_t('statut','PA')).'"';
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getNewsList($debut, $pas, $statut, $filter, $id_filter));
    $datacount = $GLOBALS['sql_object']->DBSelect(SQL_getCountNewsList($statut, $filter, $id_filter));
    $bdd_nb_com = $datacount[0]['num_rows'];
    $bdd_nb_com_display = '<p>' . $bdd_nb_com . ' ' . _t('news','name2') . $suffix . '</p>' . END_LINE;
    $content = '<h1>' . _t('news','list') . '</h1>' . END_LINE;
    if ($data != 0) {
      // echo $bdd_nb_com_display;	// affichage du nombre d'enregistrements
      $current_link = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue']);
      $content .= get_linkin_page($current_link, $bdd_nb_com, $debut, $pas);
      
      for($i = 0; $i < count($data); $i++) {
        $link_detail = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'id' => $data[$i]['news_id'], 'name' => $data[$i]['news_title']);
        $link_theme = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['theme']['linkvalue'], 'id' => $data[$i]['sdtheme_id'], 'name' => $data[$i]['sdtheme_name']);
        $link_level = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['level']['linkvalue'], 'id' => $data[$i]['news_level'], 'name' => $data[$i]['level_name']);
        $link_scale = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['scale']['linkvalue'], 'id' => $data[$i]['news_scale'], 'name' => $data[$i]['scale_denomination']);
        $link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[$i]['news_posted_by'], 'name' => $data[$i]['user_login']);
        $news_title = formatText($data[$i]['complete_news_title'], '2HTML');
        $news_header = formatText($data[$i]['news_header'], '2HTML');
        $news_sdtheme = formatText($data[$i]['sdtheme_name'], '2HTML');
        $level_name = formatText($data[$i]['level_name'], '2HTML');
        $scale_denomination = formatText($data[$i]['scale_denomination'], '2HTML');
        $news_posted_on = formatText($data[$i]['news_published_date_display'], '2HTML');
        $news_posted_by = formatText($data[$i]['user_login'], '2HTML');

        $content .= '<h2>'.END_LINE;
        $content .= '<a href="' . HrefMaker($link_detail) . '" title="' . formatText($news_title, '2ATT') . '">' . $news_title . '</a>' . END_LINE;
        $content .= '</h2>' . END_LINE;
        $content .= '<p class="published_by">' . END_LINE;
        $content .= '<span class="published-on">'._t('statut','published_on') . '</span> <span class="date">' . $news_posted_on . '</span> ';
        $content .= _t('divers','by').' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links'][U_L]['user-profile']['desc'] . ' (' . $news_posted_by . ')">' . $news_posted_by . '</a>';
        $content .= '</p>' . END_LINE;
         
        $content .= '<div class="chapo">' . $news_header . '</div>' . END_LINE;
        $content .= '<a class="readmore" href="'.HrefMaker($link_detail).'">'._t('btn', 'read_more').'</a>';
        $content .= '<p class="filter_info">';
        $content .= _t('divers','level') . ' : ';
        $content .= '<a href="' . HrefMaker($link_level) . '" title="' . $GLOBALS['filters'][U_L]['level']['desc'] . ' : ' . formatText($level_name, '2ATT') . '" class="filter_info_level">' . $level_name . '</a> ' . END_LINE;
        $content .= _t('divers','themeref') . ' : ';
        $content .= ' <a href="' . HrefMaker($link_theme) . '" title="' . $GLOBALS['filters'][U_L]['theme']['desc'] . ' : ' . formatText($news_sdtheme, '2ATT') . '" class="filter_info_theme">' . $news_sdtheme . '</a>' . END_LINE;
        $content .= _t('divers','scale') . ' : ';
        $content .= ' <a href="' . HrefMaker($link_scale) . '" title="' . $GLOBALS['filters'][U_L]['scale']['desc'] . ' : ' . formatText($scale_denomination, '2ATT') . '" class="filter_info_scale">' . $scale_denomination . '</a></p>' . END_LINE;
        if($i<count($data)-1) $content .= '<hr />' . END_LINE;
      }
    } else {
      $content .= '<p class="info">' . _t('divers','nodata') . '</p>';
    }
    $content .= get_linkin_page($current_link, $bdd_nb_com, $debut, $pas);

    echo $content;
  }
}

/**
 * DisplayOneNews()
 * Affichage d'une actualté en détail
 *
 * @param  $news_id
 * @return $stat Nom du statut + echo content
 */
if(!function_exists('DisplayOneNews')) {

  function DisplayOneNews($news_id, $display_comments = true)
  {
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getoneCompleteNews($news_id, array('P', 'PA')));
    $content = '';
    
    if($data == 0) error_redirect();
    
    if (count($data) != 1) exit;
    else {
      $link_theme = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['theme']['linkvalue'], 'id' => $data[0]['theme_sd_theme'], 'name' => $data[0]['sdtheme_name']);
      $link_level = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['level']['linkvalue'], 'id' => $data[0]['news_level'], 'name' => $data[0]['level_name']);
      $link_scale = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['scale']['linkvalue'], 'id' => $data[0]['news_scale'], 'name' => $data[0]['scale_denomination']);
      $link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[0]['news_posted_by'], 'name' => $data[0]['user_login']);
      $link_self = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'id' => $news_id);
      $news_title = formatText($data[0]['news_title'], '2HTML');
      $news_header = linkin_content(formatText($data[0]['news_header'], '2HTML'));
      $news_body = linkin_content(formatText($data[0]['news_body'], '2HTML'));
      $news_sdtheme = formatText($data[0]['sdtheme_name'], '2HTML');
      $news_scale_denomination = formatText($data[0]['scale_denomination'], '2HTML');
      $news_theme = formatText($data[0]['theme_name'], '2HTML');
      $news_level = formatText($data[0]['level_name'], '2HTML');
      $news_posted_on = formatText($data[0]['news_published_date_display'], '2HTML');
      $news_modify_on = formatText($data[0]['news_last_modify_display'], '2HTML');
      $news_posted_by = formatText($data[0]['user_login'], '2HTML');
      $news_statut = $data[0]['news_statut'];

      if(commentEnabled('news') && $display_comments == true) {
        postCommentAction(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $news_id));
        $content .= '<div id="anchor-comments">'.END_LINE;
        $content .= getCommentsAnchor(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $news_id));
        if($news_statut == 'P') $content .= getPostCommentAnchor();
        $content .= '</div>'.END_LINE;
      }
      $content .= '<h1>' . $news_title . '</h1>' . END_LINE;

      $content .= '<p class="published_by">' . END_LINE;
      $content .= '<span class="published-on">'._t('statut','published_on') . '</span> <span class="date">' . $news_posted_on . '</span> ';
      $content .= _t('divers','by').' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links'][U_L]['user-profile']['desc'] . ' (' . $news_posted_by . ')">' . $news_posted_by . '</a>';
      if ($news_statut == 'PA') {
        $content .= ' (' . _t('statut','archived_on') . ' ' . $news_modify_on . ')';
      }
      $content .= formatted_permalink($link_self, ' - ');
      $content .= '</p>' . END_LINE;

      $content .= '<div class="chapo">' . $news_header . '</div>' . END_LINE;
      $content .= '<div class="body">' . $news_body . '</div>' . END_LINE;

      $content .= '<p class="filter_info">' . END_LINE;
      $content .= _t('divers','level') . ' : ';
      $content .= '<a href="' . HrefMaker($link_level) . '" title="' . $GLOBALS['filters'][U_L]['level']['desc'] . ' : ' . formatText($news_level, '2ATT') . '" class="filter_info_level">' . $news_level . '</a> ' . END_LINE;
      $content .= ' ' . _t('divers','themeref') . ' : ';
      $content .= '<a href="' . HrefMaker($link_theme) . '" title="' . $GLOBALS['filters'][U_L]['theme']['desc'] . ' : ' . formatText($news_sdtheme, '2ATT') . '" class="filter_info_theme">' . $news_sdtheme . '</a> ';
      //$content .= ' '._t('divers','sousthemeref') . ' :';
      //$content .= $news_theme . END_LINE;
      $content .= ' ' . _t('divers','scale') . ' : ';
      $content .= '<a href="' . HrefMaker($link_scale) . '" title="' . $GLOBALS['filters'][U_L]['scale']['desc'] . ' : ' . formatText($news_scale_denomination, '2ATT') . '" class="filter_info_scale">' . $news_scale_denomination . '</a>' . END_LINE;
      $content .= '</p>' . END_LINE;
    }
    echo $content;
    return GetStatutName($news_statut);
  }
}

/**
 * GetStatutName()
 *
 * @param  $statut
 * @return $stat Nom du statut
 */
if(!function_exists('GetStatutName')) {

  function GetStatutName($statut)
  {
    switch ($statut) {
      case 'P':
        $stat = 'public';
        break;
      case 'PA':
        $stat = 'archives_p';
        break;
      case 'AA':
        $stat = 'archives_a';
        break;
      default:
        $stat = 'public';
    }
    return $stat;
  }
}

/**
 * DisplayLinkNews()
 * Affiche ou non 1 lien vers les news a venir ou qui précéde.
 *
 * @param  $current_news
 * @param  $direction
 * @param  $statut
 * @return echo content
 */
if(!function_exists('DisplayLinkNews')) {

  function DisplayLinkNews($current_news, $direction, $statut)
  {
    $q = SQL_getNewsRangeAndDate($current_news);
    $r = $GLOBALS['sql_object']->DBSelect($q);

    $range = $r[0]['news_range'];
    $published_date = $r[0]['news_published_date'];

    if ($direction == 'NEXT') {
      if($range != 0) {
        $q = SQL_getNextNewsByRange($current_news, $range, $statut);
      } else {
        $q = SQL_getNextNewsByDate($current_news, $published_date, $statut);
      }
      $class = 'next';
      $prefix = ' | ';
      $suffix = ' →';
      $title = _t('news','next_news');
    }
    if ($direction == 'PREVIOUS') {
      if($range != 0) {
        $q = SQL_getPreviousNewsByRange($current_news, $range, $statut);
      } else {
        $q = SQL_getPreviousNewsByDate($current_news, $published_date, $statut);
      }
      $class = 'previous';
      $prefix = '← ';
      $suffix = '';
      $title = _t('news','prev_news');
    }
    $data = $GLOBALS['sql_object']->DBSelect($q);

    if ($data == false || count($data) != 1) $content = '';
    else {
      $link_news = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'id' => $data[0]['news_id'], 'name' => $data[0]['news_title']);
      $news_complete_title = formatText($data[0]['news_title'], '2HTML');
      $news_title = formatText(cutText($data[0]['news_title'], 45), '2HTML');

      $content = '<div class="' . $class . '">' . END_LINE;
      $content .= $prefix . END_LINE;
      $content .= '<a href="' . HrefMaker($link_news) . '" title="' . $title .' : '.formatText($news_complete_title, '2ATT'). '">' . $news_title .'</a>';
      $content .= $suffix . END_LINE;
      $content .= '</div>' . END_LINE;
    }
    echo $content;
  }
}

?>