<?php
/**
 * @package linea21.modules
 * @subpackage news
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('news')) ReloadIndex('admin');
////////////

if(!isset($_GET['statut']) || $_GET['statut']==-1) $statut=-1;
elseif($_GET['statut']!=-1) $statut=$_GET['statut'];


if(!isset($_GET['debut'])) $debut=0;
else $debut=$_GET['debut'];

$mask_statut_1='';
$mask_statut_2='';
$mask_statut_3='';
$mask_statut_4='';
if($statut=='public') $mask_statut_1='selected="selected"';
if($statut=='draft') $mask_statut_2='selected="selected"';
if($statut=='archives_p') $mask_statut_3='selected="selected"';
if($statut=='archives_a') $mask_statut_4='selected="selected"';

// Nombre d'enregistrement total dans la bdd
$result_nb_req=$sql_object->DBSelect($req_count_news);
$bdd_nb_news=$result_nb_req[0]['num_rows'];
$bdd_nb_news_display = $bdd_nb_news." "._t('news','nb_total')."<br />\n";

if($statut!=-1) {
  $link_back="<div class=\"filter\"><a href=\"".$rub_link."&amp;todo=list\">"._t('news','all')."</a></div>";
  $req_count_news=SQL_getCountNewsList($statut);
  $result_nb_req=$sql_object->DBSelect($req_count_news);
  $count_request=$result_nb_req[0]['num_rows'];
  $req_list_news=SQL_getNewsList($debut, SELECT_LIMIT, $statut);
  $result_news_list=$sql_object->DBSelect($req_list_news);
} else {
  $link_back='';
  $count_request=$bdd_nb_news;
  $req_list_news=SQL_getNewsList($debut, SELECT_LIMIT, $statut);
  $result_news_list=$sql_object->DBSelect($req_list_news);
}

if($count_request<=1) $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','record')."<br />\n";
else $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','records')."<br />\n";

$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_statut=$rub_link."&amp;todo=list&amp;statut=";
$link_self=$link_statut.$statut;


// Liste des statuts disponibles
$select_statut="<select name=\"statut_filter\" id=\"statut_filter\">\n";
$select_statut.="<option value=\"-1\">"._t('news','statut_filter')."</option>\n";
$select_statut.="<option value=\"".$link_statut."public\"".$mask_statut_1.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"".$link_statut."draft\"".$mask_statut_2.">".display_statut('D')."</option>\n";
$select_statut.="<option value=\"".$link_statut."archives_p\"".$mask_statut_3.">".display_statut('PA')."</option>\n";
$select_statut.="<option value=\"".$link_statut."archives_a\"".$mask_statut_4.">".display_statut('AA')."</option>\n";
$select_statut.="</select>\n";

$js = "	$('#statut_filter').change(function() {
					window.location = $(this).val();
				});";

footerAddInlineJS($js);
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','news'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('news','list')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content"><?php
echo $link_back;
?>
<div class="filterselect"><?php
echo $select_statut;
?></div>
<p><?php
echo $bdd_nb_news_display;
echo $count_request_display;
?></p>
<?php
echo linkin_page($link_self, $count_request, $debut);

if($result_news_list!=0) {
  echo "<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable multisort\" id=\"sort-table\">\n";
  echo "<thead>\n";
  echo "<tr>\n";
  echo "<td>".mb_ucfirst(_t('news','title'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('divers','date_crea'))."</td>\n";
  echo "<td>".cutText(mb_ucfirst(_t('divers','date_publi')), 13, 1, '')."</td>\n";
  echo "<td class=\"sorter-false\">&nbsp;<span class=\"semnone\">".mb_ucfirst(_t('divers','actions'))."</span></td>\n";
  echo "</tr>\n";
  echo "</thead>\n";

  echo "<tbody>\n";


  for($i=0; $i<count($result_news_list); $i++) {
    $news_title=formatText(cutText($result_news_list[$i]['news_title'],53), '2HTML');
    $news_owner=$result_news_list[$i]['news_posted_by'];
    $news_statut=$result_news_list[$i]['news_statut'];
    $news_published_date = $news_statut=='D' ? _t('statut','draft') : $result_news_list[$i]['news_published_date_display'];
    echo "<tr id=\"news-".$result_news_list[$i]['news_id']."\">\n";
    echo "<td><a href=\"".$link_det.$result_news_list[$i]['news_id']."\" title=\""._t('news','det')."\">".$news_title."</a></td>\n";
    echo "<td>".$result_news_list[$i]['news_date_crea_display']."</td>\n";
    echo "<td>".$news_published_date."</td>\n";
    echo "<td style=\"width:80px\">\n";

    if ($l21auth->GetSessionElement('id') == $news_owner || $l21auth->isSuperAdmin()) {
      echo "<div class=\"iconetab\">\n";
      echo "<a href=\"".$link_sup.$result_news_list[$i]['news_id']."\" class=\"ico_sup\" title=\""._t('news','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('news','sup') . "</span></a>\n";
      echo "<a href=\"".$link_mod.$result_news_list[$i]['news_id']."\" class=\"ico_mod\" title=\""._t('news','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('news','mod') . "</span></a>\n";
      echo "</div>\n";
    } else echo '';
    echo "</td>\n";
    echo "</tr>\n";
  }

  echo "</tbody>";
  echo "</table>";
} else {
  echo "<div class=\"info\">"._t('news','noresult')."</div>";
}
echo linkin_page($link_self, $count_request, $debut);

?></div>
<?php
// Ability to sort table
addDynamicCSS('../lib/js/jquery.tablesorter/theme.default.css');
footerAddJS('../lib/js/jquery.tablesorter/jquery.tablesorter.min.js');
$str = '$("table.multisort").tablesorter({	});';
footerAddInlineJS($str);

// Ability to drag'n drop items
if ($l21auth->isSuperAdmin()) {
	footerAddJS('../lib/js/jquery.tablednd_0_5.js');
	dragTableSettings();
}
?>

<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>