<?php
/**
 * @package linea21.modules
 * @subpackage news
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('news')) ReloadIndex('admin');
////////////


if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

$news_object = new news;
$mask_statut_P='';
$mask_statut_D='';
$mask_archive_P='';
$mask_archive_D='';
$mask_archive_AA='';
$mask_archive_PA='';

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$news_object->ModifyNews($id, $data_table, $sql_object);

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

// Titre de l'actu en cours de modification
$requete=SQL_getNewsTitle($id);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $news_current_title=formatText($result[0]['news_title'],'2HTML');


// Obtention des données  de la BDD
$req_det= SQL_getoneCompleteNews($id);
$result=$sql_object->DBSelect($req_det);
if($result==0 || count($result)!=1) exit;

$form_title=formatText($result[0]['news_title'], '2FIELD');
$form_header=formatText($result[0]['news_header'], '2FIELD');
$form_body=formatText($result[0]['news_body'], '2FIELD');
$form_theme=$result[0]['news_theme'];
$form_scale=$result[0]['news_scale'];
$form_level=$result[0]['news_level'];
$form_statut=$result[0]['news_statut'];
$current_status=$result[0]['news_statut'];
$news_owner = $result[0]['news_posted_by'];

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('news')) ReloadIndex('admin');
if ($l21auth->GetSessionElement('id')!=$news_owner && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////



if(isset($_POST['valider'])) {
  $table[0]=$_POST['news_title'];
  $table[1]=$_POST['news_header'];
  $table[2]=$_POST['news_body'];
  $table[3]=$_POST['news_theme'];
  $table[4]=$_POST['news_scale'];
  $table[5]=$_POST['news_level'];
  $table[6]=$_POST['news_statut'];
  $table[7]=$current_status;

  $integrity=$news_object->CheckDataIntegrity($table);


  if(is_string($integrity)) $text_format='2FIELD';
  else $text_format='2HTML';
  $form_title=formatText($_POST['news_title'],$text_format);
  $form_header=formatText($_POST['news_header'], $text_format);
  $form_body=formatText($_POST['news_body'], $text_format);
  $form_theme=$_POST['news_theme'];
  $form_scale=$_POST['news_scale'];
  $form_level=$_POST['news_level'];
  $form_statut=$_POST['news_statut'];

  $table=urlencode(serialize($table));
}


include_once("../lib/input_helpers.php");

// select-box de thèmes
$data=$sql_object->DBSelect($req_list_theme);
$select_theme=ThemeSelectBox($data, "news_theme", $form_theme);

// select-box des échelles
$data=$sql_object->DBSelect($req_list_scale);
$select_scale=ScaleSelectBox($data, "news_scale", $form_scale);

// select-box des niveaux
$data=$sql_object->DBSelect($req_list_level);
$select_level=LevelSelectBox($data, "news_level", $form_level);

// select-box statut
if($form_statut=='P') $mask_archive_P=' selected="selected"';
if($form_statut=='D') $mask_archive_D=' selected="selected"';
if($form_statut=='AA') $mask_archive_AA=' selected="selected"';
if($form_statut=='PA') $mask_archive_PA=' selected="selected"';
$select_statut="<select name=\"news_statut\" id=\"news_statut\">\n";
$select_statut.="<option value=\"P\"".$mask_archive_P.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"D\"".$mask_archive_D.">".display_statut('D')."</option>\n";
$select_statut.="<option value=\"AA\"".$mask_archive_AA.">".display_statut('AA')."</option>\n";
$select_statut.="<option value=\"PA\"".$mask_archive_PA.">".display_statut('PA')."</option>\n";
$select_statut.="</select>\n";
?>


<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','news');?></a></li>
	<li><span><?php echo formatNavTitle(_t('news','mod'). ' : '.$news_current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($news_current_title); ?></h2>
<form id="modnews" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="news_title"><?php echo mb_ucfirst(_t('news','title')); ?> : *</label>
  <input name="news_title" type="text" class="textfield" maxlength="200" id="news_title" value="<?php echo $form_title; ?>" />
</p>
<p>
  <label for="news_header"><?php echo mb_ucfirst(_t('news','header')); ?> : *</label>
  <textarea id="news_header" name="news_header" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_header; ?></textarea>
</p>
<p>
  <label for="news_body"><?php echo mb_ucfirst(_t('news','body')); ?> : *</label>
  <textarea id="news_body" name="news_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
</p>
<p>
  <label for="news_theme"><?php echo mb_ucfirst(_t('news','theme')); ?> : *</label>
  <?php echo $select_theme; ?>
</p>
<p>
  <label for="news_scale"><?php echo mb_ucfirst(_t('news','scale')); ?> : *</label>
  <?php echo $select_scale; ?>
</p>
<p>
  <label for="news_level"><?php echo mb_ucfirst(_t('news','level')); ?> : </label>
  <?php echo $select_level; ?>
</p>
<p>
  <label for="news_statut"><?php echo mb_ucfirst(_t('news','statut')); ?> :  </label>
  <?php echo $select_statut; ?>
</p>
<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?>
  <input name="valider" type="submit" value="<?php echo _t('btn','valid'); ?>" class="button" id="valider" />
</div>
</form>
</div>
	<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
	<?php
	// Récapitulatif
} else	{

  $requete=SQL_getonethemeName($form_theme);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) exit;
  else $theme_denomination=formatText($result[0]['theme_name']);

  $requete=SQL_getonescaleDenomination($form_scale);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) exit;
  else $scale_denomination=formatText($result[0]['scale_denomination']);

  if($form_level <> -1) {
    $requete=SQL_getonelevelName($form_level);
    $result=$sql_object->DBSelect($requete);
    if($result==0 || count($result)!=1) exit;
    else $level_denomination=formatText($result[0]['level_name']);
  } else $level_denomination=_t('divers','none');

  $display_form_header=formatText(empty_nc($form_header));

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('news','title'))." :</dt>\n";
echo "<dd>".$form_title."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','header')). " :</dt>\n";
echo "<dd>".linkin_content($display_form_header)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','body'))." :</dt>\n";
echo "<dd>".linkin_content($form_body)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','theme'))." :</dt>\n";
echo "<dd>".$theme_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','scale'))." :</dt>\n";
echo "<dd>".$scale_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','level'))." :</dt>\n";
echo "<dd>".$level_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut')) ." :</dt>\n";
echo "<dd>". display_statut($_POST['news_statut']). "</dd>\n";
echo "</dl>\n";
?>
<form id="modpage" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">
<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
  <?php echo cancel_button('?rub=news&amp;todo=list'); ?>
  <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
  <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
</div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
}
?>