<?php
/**
 * @package linea21.modules
 * @subpackage newsletter
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../newsletter/'.SQL.'.inc.php'));

if(!function_exists('displayNewsletter')) {

  function displayNewsletter($id) {

    $data=$GLOBALS['sql_object']->DBSelect(SQL_getNewsletter($id));

    $content=''.END_LINE;
    if($data!=0)
    {
      $title=formatText($data[0]['newsletter_title'], '2HTML');
      $body=formatText($data[0]['newsletter_body'], '2HTML');
  
      $posted_on=formatText($data[0]['published_date_display'], '2HTML');
       
      $content.='<h2>'.$title.'</h2>'.END_LINE;
      $content.='<p class="published_by">'.END_LINE;
      $content.=_t('statut','published_on') . ' ' .$posted_on.' ';
      $content.='</p>'.END_LINE;
      $content.='<div>'.$body.'</div>'.END_LINE;
    }
    else
    {
      $content.='<p class="info">'._t('divers','nodata').'</p>';
    }

    echo $content;
  }
}

if(!function_exists('newslettersList')) {

  function newslettersList($id) {

    $data=$GLOBALS['sql_object']->DBSelect(SQL_getPublishedNewsletters($id));
    if($data!=0) {
      $str = '<ul id="newsletternav">'.END_LINE;
      for($i=0; $i<count($data); $i++) {
        $title=formatText($data[$i]['newsletter_title'], '2HTML');
        $posted_on=formatText($data[$i]['published_date_display'], '2HTML');
        $link = array('rub'=> $GLOBALS['links'][U_L]['newsletter']['linkvalue'],'id'=>$data[$i]['newsletter_id'],'name'=>$title);

        $str .= '<li><a href="'.HrefMaker($link).'">'.$title.'</a> <em>('._t('statut','published_on') . ' ' .$posted_on.')</em></li>'.END_LINE;
      }
      $str .='</ul>'.END_LINE;
    }
    return $str;
  }
}

?>