<?php
/**
 * @package linea21.modules
 * @subpackage page
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if (isset($_GET['id'])) $id = $_GET['id'];
if (isset($_POST['id'])) $id = $_POST['id'];

$req_det = SQL_getoneCompletePage($id);
$result = $sql_object->DBSelect($req_det);
if ($result == 0 || count($result) != 1) exit;

$display_title = formatText($result[0]['page_title'], '2HTML');
$display_header = linkin_content(formatText(empty_none($result[0]['page_header']), '2HTML'));
$display_body = linkin_content(formatText($result[0]['page_body'], '2HTML'));
$display_user = formatText($result[0]['user_login'], '2HTML');
$display_date_crea = $result[0]['page_date_crea_display'];
$display_last_modify = $result[0]['page_last_modify_display'];
$page_owner = $result[0]['page_posted_by'];

if($result[0]['page_homepage']=='Y') {
	$display_homepage = _t('divers', 'yes');
} else {
	$display_homepage = _t('divers', 'no');
}
$display_statut = display_statut($result[0]['page_status']);
if ($result[0]['page_published_date_display'] == '01-01-0001') $display_published_date = mb_ucfirst(_t('statut','draft'));
else $display_published_date = $result[0]['page_published_date_display'];


$link_sup = $rub_link . "&amp;todo=sup&amp;id=";
$link_mod = $rub_link . "&amp;todo=mod&amp;id=";

?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"> <?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"> <?php echo _t('menu','page'); ?> </a></li>
	<li><span><?php echo formatNavTitle(_t('page','det') . " : " . $display_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");

?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

?>
<div id="content"><?php
echo "<h2>";
echo formatTitleh2($display_title);
echo "</h2>\n";
echo "\t<a href=\"" . $link_sup . $id . "\" class=\"ico_sup2\" title=\"" . _t('page','sup') . "\"><i class=\"icon-trash\"></i><span>" . _t('page','sup') . "</span></a>\n";
echo "\t<a href=\"" . $link_mod . $id . "\" class=\"ico_mod2\" title=\"" . _t('page','mod') . "\"><i class=\"icon-pencil\"></i><span>" . _t('page','mod') . "</span></a>\n";
echo "<dl class=\"summary\">\n";
echo "<dt>" . mb_ucfirst(_t('page','title')) . " :</dt>\n";
echo "<dd>" . $display_title . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('page','header')) . " :</dt>\n";
echo "<dd>" . $display_header . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('page','body')) . " :</dt>\n";
echo "<dd>" . $display_body . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('page','author')) . " :</dt>\n";
echo '<dd><a href="?rub=user&amp;todo=det&amp;id='.$page_owner.'">' . $display_user . '</a></dd>'.END_LINE;
echo "<dt>" . mb_ucfirst(_t('page','is_homepage'))." :</dt>\n";
echo "<dd>" . $display_homepage."</dd>\n";
echo "<dt>" . mb_ucfirst(_t('statut','published_on')) . " :</dt>\n";
echo "<dd>" . $display_published_date . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','date_crea')) . " :</dt>\n";
echo "<dd>" . $display_date_crea . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','last_modify')) . " :</dt>\n";
echo "<dd>" . $display_last_modify . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','statut')) . " :</dt>\n";
echo "<dd>" . $display_statut . "</dd>\n";
echo "</dl>\n";

?></div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>