<?php
/**
 * @package linea21.modules
 * @subpackage page
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../page/' . SQL . '.inc.php'));

/**
 * get_page()
 * return a specific page
 *
 * @param  $page_id
 * @return $content string
 */
if(!function_exists('get_page')) {

	function get_page($page_id, $display_title = true, $display_header = true, $html_title = false, $breadcrumb = false) 	{
		
		$data = $GLOBALS['sql_object']->DBSelect(SQL_getoneCompletePage($page_id, array('P')));
		$content = '';

		if (!isset($data[0]['page_title'] )) {
			_debug(__FUNCTION__ . ' : no data retrieved (the given ID may be incorrect or the page is not public).');
			return false;
		} else {
			$title = formatText($data[0]['page_title'], '2HTML');
			$header = linkin_content(formatText($data[0]['page_header'], '2HTML'));
			$body = linkin_content(formatText($data[0]['page_body'], '2HTML'));
			$posted_on = formatText($data[0]['page_published_date_display'], '2HTML');
			$modify_on = formatText($data[0]['page_last_modify_display'], '2HTML');
			$posted_by = formatText($data[0]['user_login'], '2HTML');
			$statut = $data[0]['page_status'];

			$link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[0]['page_posted_by'], 'name' => $data[0]['user_login']);
			$link_self = array('rub' => $GLOBALS['links'][U_L]['page']['linkvalue'], 'id' => $page_id, 'name' => $title);


			if($html_title) SetHTMLTitle($title);
			if($breadcrumb) setBreadcrumb(array($title => false));

			if($display_title) $content .= '<h1>' . $title . '</h1>' . END_LINE;


			if($display_header) $content .= '<div class="chapo">' . $header . '</div>' . END_LINE;

			$content .= '<div class="body">' . $body . '</div>' . END_LINE;
			
			return $content;
		}
		
	}
}


/**
 * display_page()
 *
 * @param  $page_id
 * @return void
 */
if(!function_exists('display_page')) {
	
	function display_page($page_id, $display_title = true, $display_header = true, $html_title = false, $breadcrumb = false) {
		echo get_page($page_id, $display_title, $display_header, $html_title, $breadcrumb);
	}
	
}

/**
 * get_page_slot()
 *
 * @param  $page_id
 * @return $content string
 */
if(!function_exists('get_page_slot')) {
	
	function get_page_slot($page_id, $display_title = false) {
		
		$content  = '<div class="page-slot slot-'.$page_id.'">';
		$content .= get_page($page_id, $display_title, false, false, false);
		$content .='</div>';

		return $content;
	}
	
}

/**
 * display_page_slot()
 *
 * @param  $page_id
 * @return void
 */
if(!function_exists('display_page_slot')) {
	
	function display_page_slot($page_id, $display_title = true) {
		
		echo get_page_slot($page_id, $display_title, false, false, false);
	}
	
}

/**
 * get_page_link()
 *
 * @param  $page_id
 * @return $content string
 */
if(!function_exists('get_page_link')) {
	
	function get_page_link($page_id) {

		$data = $GLOBALS['sql_object']->DBSelect(SQL_getoneCompletePage($page_id, array('P')));
		$content = '';

		if (!isset($data[0])) {
			_debug(__FUNCTION__ . ' : no data retrieved (the given ID may be incorrect).');
			return false;
		} else {
			$title = formatText($data[0]['page_title'], '2HTML');
			$link = array('rub' => $GLOBALS['links'][U_L]['page']['linkvalue'], 'id' => $page_id, 'name' => $title);
			
			return HrefMaker($link);
		}
		
	}
	
}

/**
 * display_page_title()
 *
 * @param  $page_id
 * @return void
 */
if(!function_exists('display_page_title')) {
	
	function display_page_title($page_id) {
		
		echo get_page_title($page_id);
	}
	
}

/**
 * get_page_title()
 *
 * @param  $page_id
 * @return $content string
 */
if(!function_exists('get_page_title')) {
	
	function get_page_title($page_id) {

		$data = $GLOBALS['sql_object']->DBSelect(SQL_getPageTitle($page_id, array('P')));
		$content = '';

		if (!isset($data[0])) {
			_debug(__FUNCTION__ . ' : no data retrieved (the given ID may be incorrect).');
			return false;
		} else {
			$title = formatText($data[0]['page_title'], '2HTML');
			return $title;
		}
	}
	
}

?>