<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
// set HTML Title
SetHTMLTitle('Guía de accesibilidad Linea21');
setBreadcrumb(array('Política de Accesibilidad de Linea21' => false));
?>

<div id="accessibilite">
<h1>Política de Accesibilidad de Linea21</h1>
<div class="sub-title">Este sitio está diseñado
para ser leido por todos los internautas, independientemente de sus
handicaps, del medio utilizado y del hardware.</div>


<h2>Accesos de teclado</h2>
<p>La mayoría de los navegadores permiten el seguimiento de vínculos
utilizando una combinación de teclas definidas en el sitio web. En
Windows, presione alt + tecla de acceso. En Macintosh, presione ctrl +
tecla de acceso. <br />
Todas las páginas de este sitio web contienen estas <span xml:lang="es">llaves
de acceso</span> :</p>
<dl>
	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['accessibility']['accesskey'] ?></kbd>
	:</dt>
	<dd>Política de Accesibilidad</dd>
	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['home']['accesskey'] ?></kbd>
	:</dt>
	<dd>Inicio</dd>
	<dt xml:lang="es">Atajo de teclado <kbd>2</kbd> :</dt>
	<dd>Contenido</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['search']['accesskey'] ?></kbd>
	:</dt>
	<dd>Búsqueda</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['news']['accesskey'] ?></kbd>
	:</dt>
	<dd>Noticias</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['project']['accesskey'] ?></kbd>
	:</dt>
	<dd>Proyectos</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['directory']['accesskey'] ?></kbd>
	:</dt>
	<dd>Anuario</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['workgroup']['accesskey'] ?></kbd>
	:</dt>
	<dd>Grupos de trabajo</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['publication']['accesskey'] ?></kbd>
	:</dt>
	<dd>Publicaciones</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['dashboard']['accesskey'] ?></kbd>
	:</dt>
	<dd>Panel de indicadores</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['user-prefs']['accesskey'] ?></kbd>
	:</dt>
	<dd>Preferencias usuario</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['user-registration']['accesskey'] ?></kbd>
	:</dt>
	<dd>Registro de usuarios</dd>

	<dt xml:lang="es">Atajo de teclado <kbd><?php echo $GLOBALS['links'][U_L]['logout']['accesskey'] ?></kbd>
	:</dt>
	<dd>Cerrar sesión</dd>
</dl>
<br style="clear: both;" />
<h2 style="margin-top: 1em">Standars</h2>
<ul>
	<li>Todas las páginas de este sitio han sido validadas en <abbr
		title="eXtensible HyperText Markup Language">XHTML</abbr> 1.0 Strict</li>
	<li>Todas las páginas de este sitio han sido testeadas con <a
		href="http://www-3.ibm.com/able/solution_offerings/hpr.html"
		title="Information" xml:lang="es" hreflang="en">Home Page Reader 3.0
	(IBM® Accessibility Tool)</a>.</li>
	<li>Todas las páginas de este sitio cumplen con los valores semánticos.
	Las etiquetas H1 se utilizan para los títulos. Las etiquetas H2 se
	utilizan para los subtítulos. Como ejemplo, en esta página, los
	usuarios del software <abbr title="Job Access With Speech">JAWS</abbr>
	pueden acceder a la sección siguiente mediante la combinación de teclas
	: ALT+INSERT+3</li>
</ul>


<h2>Ayudas para la navegación</h2>
<ul>
	<li>Todas las páginas de este sitio web contienen elementos de
	navegación relacionados. <br />
	<pre>
			<code>
&lt;link rel="home" titulo="inicio" href="inicio" /&gt;
&lt;link rel="search" titulo="búsqueda" href="búsqueda" /&gt;
&lt;link rel="help" titulo="Politica de Accesibilidad Linea21" href="accesibilidad" /&gt;
			</code>
		</pre></li>
	<li>La página de inicio y el resto de las páginas contienen un cuadro
	de búsqueda (Atajo de teclado <kbd>4</kbd>).</li>
</ul>

<h2>Enlaces</h2>
<ul>
	<li>La mayoría de los enlaces llevan asociado un "título" que describe
	el enlace en detalle.</li>
	<li>Les enlaces se han escrito para que tengan sentido fuera de
	contexto.</li>
	<li>Para facilitar la navegación se utilizan scripts , pero sus
	desactivaciones pueden ocasionar algunas restricciones en la
	accesibilidad al contenido y navegación.</li>
</ul>

<h2>Imágenes</h2>
<ul>
	<li>Todas las imágenes decorativas se incluyen en los tipos de estilo <abbr
		title="Cascading Style Sheet">CSS</abbr>.</li>
	<li>Todas las imagenes referidas al contenido tienen etiquetas
	descriptivas <acronym title="Alternative">Alt</acronym>.</li>
</ul>

<h2>Formularios</h2>
<ul>
	<li>Se ha realizado un esfuerzo para elaborar formularios accesibles :
	el uso de la etiqueta 'LABEL' da significado a cada campo del
	formulario.</li>
</ul>

<h2>Diseño visual</h2>
<ul>
	<li>Este sitio utiliza hojas de estilo en cascada (<abbr
		title="Cascading Style Sheet">CSS</abbr>) para la presentación
	gráfica. Si su navegador no admite los <abbr
		title="Cascading Style Sheet">CSS</abbr>, el contenido de la web
	seguirá siendo legible.</li>
	<li>Este sitio utiliza exclusivamente tamaños de fuente relativos,
	compatible con el "tamaño de texto" especificado por el usuario en el
	navegador visual. Usted puede utilizar el método abreviado <kbd>ctrl +
	tecla</kbd>, para cambiar el tamaño de texto.</li>
</ul>

<h2>Advertencias - Responsabilidad</h2>
<ul>
	<li>El contenido público de este sitio no proviene de <a
		href="<?php echo SITE_LINEA_URL; ?>">Linea21</a>, no podemos
	garantizar la perfecta accesibilidad a los datos contenidos en la
	aplicación.</li>
	<li>No dude en informarnos de cualquier deficiencia y enviarnos sus
	comentarios sobre la accesibilidad de la información contenida en este
	sitio: : <a href="mailto:<?php echo MAIL_LINEA; ?>"><?php echo MAIL_LINEA; ?></a></li>
</ul>

<h2>Referencias</h2>
<ul>
	<li><a href="http://www.w3.org/TR/WCAG20/"
		title="Web Content Accessibility Guidelines (WCAG) 2.0" hreflang="en">normas Web Content Accessibility Guidelines</a> (WCAG) 2.0(<abbr title="World Wide Web Consortium">W3C</abbr>)</li>
	<li><a href="http://www.la-grange.net/accessibilite/index.html"
		title="Pourquoi dois-je rendre mon site Web plus accessible ? Comment puis-je rendre mon site web plus accessible ?">Profundizar
	en la Accesibilidad</a> : traducción francesa de Karl Dubost de un
	texto muy pedagógico escrito por Mark Pilgrim.</li>
</ul>

<h2>Herramientas gratuitas</h2>
<ul>
	<li><a href="http://validator.w3.org/" hreflang="en">W3C MarkUp
	Validation Service</a> : control de la sintaxis de las páginas <abbr
		title="HyperText Markup Language ">HTML</abbr> y <abbr
		title="eXtensible HyperText Markup Language">XHTML</abbr>.</li>
	<li><a href="http://jigsaw.w3.org/css-validator/" hreflang="en">W3C CSS
	Validation service</a> : control de la conformidad sintáctica de las
	hojas de estilo en cascada.</li>
	<li><a href="http://www.w3.org/People/Raggett/tidy/"
		title="Clean up your Web pages with HTML TIDY" hreflang="en"><abbr
		title="HyperText Markup Language ">HTML</abbr> Tidy</a> : herramienta
	que corrige rápidamente la mayor parte de los errores de sintaxis del
	lenguaje <abbr title="HyperText Markup Language ">HTML</abbr> y
	proporciona varias recomendaciones de accesibilidad.</li>
	<li><a href="http://www.delorie.com/web/wpbcv.html" hreflang="en">Web
	Page Backward Compatibility Viewer</a> : permite mostrar el aspecto de
	la pagina web utilizando un software más antiguo o menos potente.</li>
	<li><a href="http://lynx.isc.org/release/"
		title="Page de la distribution stable de Lynx" hreflang="en">Lynx</a>
	: navegador en modo texto.</li>
	<li><a href="http://artax.karlin.mff.cuni.cz/~mikulas/links/"
		title="Sources du programme Links" hreflang="en">Links</a> : otro
	navegador en modo texto, para Unix y OS/2.</li>
</ul>
</div>