<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php

if(defined('MOD_COMMENT') && MOD_COMMENT == 1 && commentEnabled('contribute')) {

  $id = 1;
  
  SetHTMLTitle(_t('comment','contribute_title'));
  setBreadcrumb(array(_t('comment','contribute_title') => false));
  
  postCommentAction(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $id));
  
  echo '<h1>'._t('comment','contribute_title').'</h1>'.END_LINE;
  echo '<div class="sub-title">'.END_LINE;
  echo sprintf(_t('comment','contribute_chapo'), getNbComments(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $id)));
  echo '</div>'.END_LINE;
  
  displayCommentForm(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $id));
  

} else {
  ReloadIndex(CURRENT_APP);
}


if( ActiveItemKey($GLOBALS['activeitem']) =='contact') {
  // set HTML Title
  SetHTMLTitle(_t('contact','contact_us'));
  setBreadcrumb(array(_t('contact','contact_us') => false));
  include_once('../class/system/class.form.php');

  $name='';
  $email='';
  $subject='';
  $body='';

  if(isset($_POST['name'])) {
    $passed = true;
    $name=$_POST['name'];
    $email=$_POST['email'];
    $subject=$_POST['subject'];
    $body=$_POST['body'];

    if(strlen($body)< 8) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'body'));
      $class='error';
      $passed = false;
    }
    if(strlen($subject)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'subject'));
      $class='error';
      $passed = false;
    }
    if(!validEmail($email)) {
      $msg=sprintf(_t('contact','email_error'), $email);
      $class='error';
      $passed = false;
    }
    if(strlen($email)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'email'));
      $class='error';
      $passed = false;
    }
    if(strlen($name)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'name'));
      $class='error';
      $passed = false;
    }
    if($passed == true) {
      $class = 'info';
      $msg = _t('contact', 'message_sent');
      $email_recipient = SITE_MAIL;
      $email_fromname = $name;
      $email_from = $email;
      $email_subject = formatText($subject, '2HTML') . ' - '. SITE_NAME;
      $email_html_body = formatText($body, '2HTML');
      $email_text_body = strip_tags($email_html_body);
      include_once(override('../mail/template.php'));
    }
  }
  echo '<div>'.END_LINE;
  echo '<h1>'._t('contact','contact_us').'</h1>'.END_LINE;
  if(isset($passed)) echo '<div class="'.$class.'">'.$msg.'</div>'.END_LINE;

  if(!isset($passed) || $passed == false) {
    $form = new genForm;
    $form->startForm('index.php', '#contactform');
    $form->textInput('name', _t('contact', 'name'). ' : ', 'shorttextfield', 'labelised', 'title', 100, 30, false, $name, false);
    $form->insertBR();
    $form->textInput('email', _t('contact', 'email'). ' : ', 'shorttextfield', 'labelised', 'title', 150, 30, false, $email, false);
    $form->insertBR();
    $form->textInput('subject', _t('contact', 'subject'). ' : ', 'shorttextfield', 'labelised', 'title', 150, 30, false, $subject, false);
    $form->insertBR();
    $form->textareaInput('body',ucfirst(_t('contact', 'body')) .' : ',false,'labelised', false, $body, 60, 10);
    $form->insertBR();
    $form->submitButton(false, _t('btn', 'valid'), true, 'submitbut');
    $form->hiddenInput('rub', $_REQUEST['rub']);
    $form->closeForm();
    if(!$output = $form->getForm()) { die("error: " . $form->error); }
    else { echo $output; }
  }
  echo '</div>'.END_LINE;
}

?>