<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

$GLOBALS['filters'][U_L]['scale']['active'] = 1; // filter activation
SetHTMLTitle(_t('dashboard','section')); // HTML title
//////////////////////////////////////////
/////récupération des variables GET et POST
//////////////////////////////////////////
include_once(override('../dashboard/display.php'));

// if $_REQUEST['parentid'] is not fired, ID's value goes to $scale_id var
if(isset($_REQUEST['id'])) {
	$scale_id=$_REQUEST['id'];
} else {
	$scale_id=1;
}
// if parentid is fired, ID's value goes to $sdi_id var
// and parentid's value goes to $scale_id
if (isset($_REQUEST['parentid'])) {
  $sdi_id=$_REQUEST['id'];
  $scale_id=$_REQUEST['parentid'];
}

isset($_REQUEST['altmode']) ? $altmode = true : $altmode = false;


$scale = $GLOBALS['sql_object'] -> DBSelect(SQL_getonescale($scale_id));


//////////////////////////////////////////
/////affichage tableau de bord
//////////////////////////////////////////

if(!isset($_REQUEST['parentid'])) {

  if ( ActiveItemKey($GLOBALS['activeitem']) == 'dashboard') {

    setBreadcrumb(array(ucfirst(_t('dashboard','section')) => false));

    //////////////////////////////////////////
    /////affichage liste des indicateurs
    //////////////////////////////////////////
    
    echo getDataVizSwitcher($altmode, $scale_id);
   
    echo "<h1>"._t('dashboard','list_public'). " - " . formatText($scale[0]['scale_denomination'], '2HTML') ."</h1>".END_LINE;
    ?>
		<div class="sub-title">
		<?php echo _t('dashboard','h1_public_comment'); ?>
		</div>
    <?php
    if( $altmode ) {
    	DisplayListValuesByProjects($scale_id, $GLOBALS['filters'][U_L]['scale']['linkvalue']);
    } else {
    	DisplayListValuesByThemes($scale_id, $GLOBALS['filters'][U_L]['scale']['linkvalue']);
    }    
  }


} else {
  //////////////////////////////////////////
  /////affichage détail d'un indicateur
  //////////////////////////////////////////

  // set HTML Title
  $result=$GLOBALS['sql_object']->DBSelect(SQL_getOnesdiname($sdi_id));
  SetHTMLTitle(formatText($result[0]['sdii_name'], '2HTML'));
  setBreadcrumb(array(ucfirst(_t('dashboard','section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue']))));
  setBreadcrumb(array(formatText($result[0]['sdii_name'], '2HTML') => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $sdi_id, 'parentid' => $scale_id, 'name' => formatText($result[0]['sdii_name'], '2HTML')))));

  echo '<div>'.END_LINE;
  if(commentEnabled('indicator')) {
    postCommentAction(array('module'=> 'indicator', 'module_id'=> $sdi_id));
    echo '<div id="anchor-comments">'.END_LINE;
    echo getCommentsAnchor(array('module'=> 'indicator', 'module_id'=> $sdi_id));
    echo getPostCommentAnchor();
    echo '</div>'.END_LINE;
  }
  if(isset($_REQUEST['parentid']) && ActiveItemKey($GLOBALS['activeitem'])=='dashboard') {
    DisplayOneSdi($sdi_id, $scale_id);
    setBreadcrumb(array(ucfirst(_t('dashboard','mode_aff_info')) => false));
  }
  if (isset($_REQUEST['parentid']) && ActiveItemKey($GLOBALS['activeitem'])=='dashboard-rules') {
    DisplayOneSdirules($sdi_id, $scale_id);
    setBreadcrumb(array(ucfirst(_t('dashboard','mode_aff_rules')) => false));
  }
  if (isset($_REQUEST['parentid']) && ActiveItemKey($GLOBALS['activeitem'])=='dashboard-assessment') {
    DisplayOneSdievaluation($sdi_id, $scale_id);
    setBreadcrumb(array(ucfirst(_t('dashboard','mode_aff_evaluation')) => false));
  }
  if (isset($_REQUEST['parentid']) && ActiveItemKey($GLOBALS['activeitem'])=='dashboard-provider') {
    DisplayOneSdiprovider($sdi_id, $scale_id);
    setBreadcrumb(array(ucfirst(_t('dashboard','mode_aff_provider')) => false));
  }
  if(commentEnabled('indicator')) {
    echo '<h3>'._t('comment', 'section').'</h3>'.END_LINE;
    echo '<div id="comments">'.END_LINE;
    displayComments(array('module'=> 'indicator', 'module_id'=> $sdi_id, 'order_by' => 'ASC'), false, true);
    displayCommentForm(array('module'=> 'indicator', 'module_id'=> $sdi_id));
    echo '</div>'.END_LINE;
  }
  echo '</div>'.END_LINE;
  
  echo '<script type="text/javascript">
		$(document).ready(function() {
			$(".valuecomment").hover(
				function() {
					$(".cont", this).fadeIn();
				},
				function() {
					$(".cont", this).hide();
				}
			);
		})
		</script>';
}?>