<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>
<?php
include_once(override('../user/display.php'));
include_once(override('../lib/input_helpers.php'));

//////////////////////////////////////////
///// déconnexion utilisateur authentifié
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'logout') {
	$GLOBALS['l21auth']->logOut();
	header("Location: ".$_SERVER['HTTP_REFERER']);
}


SetHTMLTitle(_t('user','section')); // set HTML title

//////////////////////////////////////////
/////affichage formulaire Password
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'forgot-password') {
	setBreadcrumb(array(ucfirst(_t('user', 'forgot_pass')) => false));
	SetHTMLTitle(ucfirst(_t('user', 'forgot_pass'))); // set HTML title
	echo '<h2>'.ucfirst(_t('user', 'forgot_pass')).'</h2>';

	if(isset($_REQUEST['token'])) {
		$r=$GLOBALS['sql_object']->DBSelect(SQL_get_UserInfoPK($_REQUEST['token']));

		if($r != 0) {
			$user_email=$r[0]['profile_email'];
			$user_login=$r[0]['user_login'];
			$user_id=$r[0]['user_id'];

			include_once('../class/class.user.php');
			$user = new user;
			$new_pass = $user->GetNewPassword();
			$res = $user->UpdateUserPassword($user_id, $new_pass, $GLOBALS['sql_object']);
			if($res) {
				$user->resetPasskey($user_id, $GLOBALS['sql_object']);
				$todo_mail='change_pass';
				include_once(override('../user/mail_actions.php'));
				include_once(override('../mail/template.php'));
				echo '<div class="info">'._t('user', 'new_password_confirmation').'</div>';
			}
		} else {
			ReloadIndex('public');
		}
	} else {
		echo forgotPass();
	}
}

//////////////////////////////////////////
/////affichage profil utilisateur
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'user-profile') {
	setBreadcrumb(array(ucfirst(_t('user', 'profile')) => false));
	/** préparation des variables
	 * 	$id -> default -1
	 **/
	if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;

	/** Détail d'un utilisateur
	 */
	if(isset($_REQUEST['id'])) {
		// set HTML Title
		$result=$GLOBALS['sql_object']->DBSelect(SQL_getUserLogin($id));
		SetHTMLTitle(formatText($result[0]['user_login'], '2HTML'));
		DisplayInfoUser($id);
	}
}

//////////////////////////////////////////
/////affichage formulaire inscription utilisateur
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'user-registration') {


	if(isset($_POST['valid']) || isset($_POST['valid_x'])) {
		$fired = true;

		include_once('../class/class.user.php');
		$user_object= new user;

		$data_table_user[0] = $u_login = $_POST['login'];
		$data_table_user[1] = $u_mail = $_POST['email'];
		$data_table_user[2] = 'N'; // Affichage public de l'email (par défaut Non)
		$data_table_user[3] = $_POST['firstname'];
		$data_table_user[4] = $_POST['lastname'];
		$data_table_user[5] = $u_password = $user_object -> GetNewPassword();
		$data_table_right=$user_object->InitUserRight('SIMPLE_USER');
		$result=$user_object->CheckDataIntegrity($data_table_user, $GLOBALS['sql_object']);

		if($result===true) {
			/** include envoi de mail */
			$todo_mail='add_user';
			include_once(override('../user/mail_actions.php'));
			include_once(override('../mail/template.php'));

			/** end mail */

			$result=$user_object->AddUser($data_table_user, $data_table_right, $GLOBALS['sql_object']);
			if(is_numeric($result)) $msg='<p class="confirm">'._t('user','confirm_public').'</p>'.END_LINE;
		}

	}

	SetHTMLTitle(_t('divers','user_inscription'));
	echo '<h1>'._t('divers','user_inscription').'</h1>'.END_LINE;
	echo '<div class="sub-title">';
	echo _t('user','h1_public_comment_insc');
	echo '</div>';
	if(isset($result) && !is_numeric($result)) {
		echo '<p class="error">'.END_LINE;
		echo $result.END_LINE;
		echo '</p>'.END_LINE;
	} else {
		if(isset($msg)) echo $msg;
	}

	if(!isset($result) || (isset($result) && !is_numeric($result))) echo AuthForm('SUBSCRIBE');

}

//////////////////////////////////////////
/////affichage prefs utilisateurs
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'user-prefs') {
	setBreadcrumb(array(ucfirst(_t('divers', 'myprofile')) => false));
	SetHTMLTitle(_t('divers','auth'). ' / '._t('user','p_mod'));

	$submitted = -1;

	if(isset($_REQUEST['login'])) {
		include_once('../class/class.auth.php');
		
		if(isset($_POST['rememberme'])) {
			$rememberme = true;
		} else {
			$rememberme = false;
		}

		$auth_value= $GLOBALS['l21auth']->logIn($_POST['login'], $_POST['password'],  'PUBLIC', $rememberme);
		//$auth_value=AuthenthificationProcess($_POST['login'], $_POST['password'], 'PUBLIC');
		if($auth_value === true) header("Location: ".$_POST['referer']);
	}

	if(isset($_SESSION['authenticated'])) {
		
		if(isset($_REQUEST['current_email'])) {
			$update_msg = ModifyProfile();
			$submitted=1;
		}
		
		$content ='<h1>'._t('user','p_mod'). ' - ' .$_SESSION['userlogin']. '</h1>'.END_LINE;
		$content.='<div class="sub-title">';
		$content.=_t('user','h1_public_comment');
		$content.='</div>';

		echo $content;
		// confirmation messages on deleting avatar
		if(isset($_REQUEST['delavatar'])) {
			deleteUserAvatar();
		}
		// confirmation message on changes
		if(isset($_REQUEST['notifyUpdate'])) {
			ChangeNotifySettings(base64_decode($_SESSION['userid']));
		}
		if(isset($update_msg)) {
			echo $update_msg;
		}
		DisplayFormProfileUser(base64_decode($_SESSION['userid']), $submitted);
		echo '<h1>'._t('user','preferences').'</h1>'.END_LINE;
		DisplayWorkgroupsSettings(base64_decode($_SESSION['userid']));


	} else {
		echo '<h1>'._t('divers','auth').'</h1>'.END_LINE;
		echo '<div class="sub-title">';
		echo _t('user','h1_public_comment_auth');
		echo '</div>';

		if(isset($auth_value)) {
			echo '<p class="error">'.END_LINE;
			echo $auth_value.END_LINE;
			echo '</p>'.END_LINE;
		}
		echo '<div id="cookieEnabled"></div>';
		echo '<script type="text/javascript">cookieAlert("#cookieEnabled", "'._t('alert', 'cookie_disabled').'");</script>';
		echo AuthForm('LOGON');
		DisplayAuthTextInfo();
	}

}

?>