<?php
/**
 * @package linea21.modules
 * @subpackage publication
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('publication')) ReloadIndex('admin');
////////////

if(!isset($_GET['statut']) || $_GET['statut']==-1) $statut=-1;
elseif($_GET['statut']!=-1) $statut=$_GET['statut'];


if(!isset($_GET['debut'])) $debut=0;
else $debut=$_GET['debut'];

$mask_statut_1='';
$mask_statut_2='';
$mask_statut_3='';
$mask_statut_4='';
if($statut=='public') $mask_statut_1='selected="selected"';
if($statut=='draft') $mask_statut_2='selected="selected"';
if($statut=='archives_p') $mask_statut_3='selected="selected"';
if($statut=='archives_a') $mask_statut_4='selected="selected"';

// Nombre d'enregistrement total dans la bdd
$req_count_publi=SQL_getCountPublicationList();
$result_nb_req=$sql_object->DBSelect($req_count_publi);
$bdd_nb_publi=$result_nb_req[0]['num_rows'];
$bdd_nb_publi_display = $bdd_nb_publi." "._t('publication','nb_total')."<br />\n";

if($statut!=-1) {
  $link_back="<div class=\"filter\"><a href=\"".$rub_link."&amp;todo=list\">"._t('publication','all')."</a></div>";
  $req_count_publi=SQL_getCountPublicationList($statut);
  $result_nb_req=$sql_object->DBSelect($req_count_publi);
  $count_request=$result_nb_req[0]['num_rows'];
  $req_list_publi=SQL_getPublicationList($debut, SELECT_LIMIT, $statut);
  $result_publi_list=$sql_object->DBSelect($req_list_publi);
} else {
  $link_back='';
  $count_request=$bdd_nb_publi;
  $req_list_publi=SQL_getPublicationList($debut, SELECT_LIMIT, $statut);
  $result_publi_list=$sql_object->DBSelect($req_list_publi);
}

if($count_request<=1) $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','record')."<br />\n";
else $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','records')."<br />\n";


$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_statut=$rub_link."&amp;todo=list&amp;statut=";
$link_self=$link_statut.$statut;


// Liste des statuts disponible
$select_statut="<select name=\"statut_filter\" id=\"statut_filter\">\n";
$select_statut.="<option value=\"-1\">"._t('publication','statut_filter')."</option>\n";
$select_statut.="<option value=\"".$link_statut."public\"".$mask_statut_1.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"".$link_statut."draft\"".$mask_statut_2.">".display_statut('D')."</option>\n";
$select_statut.="<option value=\"".$link_statut."archives_p\"".$mask_statut_3.">".display_statut('PA')."</option>\n";
$select_statut.="<option value=\"".$link_statut."archives_a\"".$mask_statut_4.">".display_statut('AA')."</option>\n";
$select_statut.="</select>\n";

$js = "	$('#statut_filter').change(function() {
					window.location = $(this).val();
				});";

footerAddInlineJS($js);
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','publication'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('publication','list')) ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">
<?php echo $link_back; ?>
<div class="filterselect"><?php echo $select_statut; ?></div>
<p>
	<?php
	echo $bdd_nb_publi_display;
	echo $count_request_display;
	?>
</p>
<?php
echo linkin_page($link_self, $count_request, $debut);

if($result_publi_list!=0) {
  echo "<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable multisort\" id=\"sort-table\">\n";
  echo "<thead>\n";
  echo "<tr>\n";
  echo "<td>".mb_ucfirst(_t('publication','title'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('publication','author'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('divers','date_crea'))."</td>\n";
  echo "<td>".cutText(mb_ucfirst(_t('divers','date_publi')), 13, 1, '')."</td>\n";
  echo "<td class=\"sorter-false\">&nbsp;<span class=\"semnone\">".mb_ucfirst(_t('divers','actions'))."</span></td>\n";
  echo "</tr>\n";
  echo "</thead>\n";


  echo "<tbody>";
  for($i=0; $i<count($result_publi_list); $i++) {
    $publi_title=formatText(cutText($result_publi_list[$i]['publi_title'],50), '2HTML');
    $publi_owner=$result_publi_list[$i]['publi_posted_by'];
    $publi_statut=$result_publi_list[$i]['publi_statut'];
    $publi_published_date = $publi_statut=='D' ? _t('statut','draft') : $result_publi_list[$i]['publi_published_date_display'];
    echo "<tr id=\"publi-".$result_publi_list[$i]['publi_id']."\">\n";
    echo "<td><a href=\"".$link_det.$result_publi_list[$i]['publi_id']."\" title=\""._t('publication','det')."\">".$publi_title."</a></td>\n";
    echo "<td>".$result_publi_list[$i]['user_login']."</td>\n";
    echo "<td>".$result_publi_list[$i]['publi_date_crea_display']."</td>\n";
    echo "<td>".$publi_published_date."</td>\n";
    echo "<td style=\"width:80px\">\n";
    if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
      echo "<div class=\"iconetab\">";
      echo "\t<a href=\"".$link_sup.$result_publi_list[$i]['publi_id']."\" class=\"ico_sup\" title=\""._t('publication','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('publication','sup') . "</span></a>\n";
      echo "\t<a href=\"".$link_mod.$result_publi_list[$i]['publi_id']."\" class=\"ico_mod\" title=\""._t('publication','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('publication','mod') . "</span></a>\n";
      echo "</div>";
    } else echo '';
    echo "</td>\n";
    echo "</tr>\n";
  }

  echo "</tbody>";
  echo "</table>";
} else {
  echo "<div class=\"info\">"._t('publication','noresult')."</div>";
}
echo linkin_page($link_self, $count_request, $debut);

?></div>

<?php
// Ability to sort table
addDynamicCSS('../lib/js/jquery.tablesorter/theme.default.css');
footerAddJS('../lib/js/jquery.tablesorter/jquery.tablesorter.min.js');
$str = '$("table.multisort").tablesorter({	});';
footerAddInlineJS($str);

// Ability to drag'n drop items
if ($l21auth->isSuperAdmin()) {
	footerAddJS('../lib/js/jquery.tablednd_0_5.js');
	dragTableSettings();
}
?>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>